/***************************************************************************
                          editparameterdlg.cpp  -  description
                             -------------------
    begin                : Mit Jul 23 2003
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qfileinfo.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qregexp.h>
#include <qtimer.h>
#include <kapp.h>
#include <klocale.h>
#include "editparameterdlg.h"
#include "kpldoc.h"
#include "kpldoubleedit.h"
#include "sourcewidget.h"

EditParameterDlg::EditParameterDlg(QWidget* _parent, KplDoc* m, double* p0,
                                   const QString& file, const QString& func,
                                   bool applyButton, bool d3) :
 KDialogBase(Plain, i18n("Parameters"),
             applyButton ? Ok | Cancel | Apply : Ok | Cancel,
             Ok, _parent, 0, true, true), p(p0)
{
  QHBoxLayout* hbox = 0;
  QVBoxLayout* vbox;
  QFrame* frame = plainPage();
  if (m->options()->showSource) {
    hbox = new QHBoxLayout(frame, 0, spacingHint());
    vbox = new QVBoxLayout(hbox);
  } else
    vbox = new QVBoxLayout(frame, 0, spacingHint());
  QGroupBox* g = new QGroupBox(0, Qt::Vertical, frame);
  QGridLayout* grid = new QGridLayout(g->layout(), QMIN(KPL_NPMAX, 10),
                                      2 + 3 * ((KPL_NPMAX - 1) / 10),
                                      spacingHint());
  vbox->addWidget(g);
  QString s;
  char frm = m->options()->format;
  int prec = m->options()->prec;
  int w = 0;
  for (int i = 0; i < KPL_NPMAX; i++) {
    int ix = 3 * (i / 10);
    int iy = i % 10;
    grid->addWidget(new QLabel(s.sprintf("p%i", i), g), iy, ix);
    grid->addWidget(par[i] = new KplDoubleEdit(p[i], g, frm, prec), iy,
                    ix + 1);
    if (!i)
      w = par[0]->fontMetrics().width(m->number(-1.0e-123 / 3.0)) + 3;
    par[i]->setMinimumWidth(w);
  }
  for (int i = 0; i < ((KPL_NPMAX - 1) / 10); i++)
    grid->addItem(new QSpacerItem(20, 10), 0, 3 * i + 2);
  if (m->options()->showSource) {
    QFileInfo fi(file);
#if KDE_VERSION_MAJOR > 2
    QRegExp rx2(d3 ? "\\S+__FddPCd" : "\\S+__FdPCd");
    QRegExp rx3(d3 ? "_Z\\d+\\S+ddPKd" : "_Z\\d+\\S+dPKd");
    int pp2 = rx2.search(func);
    int pp3 = rx3.search(func);
#else
    QRegExp rx2(d3 ? "[^\\s]+__FddPCd" : "[^\\s]+__FdPCd");
    QRegExp rx3(d3 ? "_Z\\d+[^\\s]+ddPKd" : "_Z\\d+[^\\s]+dPKd");
    int l2, l3;
    int pp2 = rx2.match(func, 0, &l2);
    int pp3 = rx3.match(func, 0, &l3);
#endif
    s = fi.dirPath(true) + "/" + fi.baseName();
    bool guessC = pp2 && pp3;
    QFile f(s + (guessC ? ".c" : ".cpp"));
    bool open = f.open(IO_ReadOnly);
    if (!open) {
      f.setName(s + (guessC ? ".cpp" : ".c"));
      open = f.open(IO_ReadOnly);
    }
    if (open) {
      SourceWidget* sw = new SourceWidget(frame, &f);
      hbox->addWidget(sw, 1);
      sw->setMinimumWidth(400);
      if (!pp2)
#if KDE_VERSION_MAJOR > 2
        sw->highlight(func.left(rx2.matchedLength() - 7));
      else
        if (!pp3)
          sw->highlight(func.mid(3, rx3.matchedLength() - 7));
#else
        sw->highlight(func.left(l2 - 7));
      else
        if (!pp3)
          sw->highlight(func.mid(3, l3 - 7));
#endif
        else
          sw->highlight(func);
      QTimer::singleShot(0, sw, SLOT(slotHighlight()));
    }
  }
}

EditParameterDlg::~EditParameterDlg()
{
}

void EditParameterDlg::getValues(bool ok)
{
  for (int i = 0; i < KPL_NPMAX; i++)
    p[i] = par[i]->value();
  if (ok)
    accept();
  else
    emit applyClicked();
}

void EditParameterDlg::slotOk()
{
  getValues(true);
}

void EditParameterDlg::slotApply()
{
  getValues(false);
}
