/***************************************************************************
                          funcdlg.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <math.h>
#include <qdir.h>
#include <qfileinfo.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qmultilinedit.h>
#include <kapp.h>
#include <kcolorbtn.h>
#include <kfiledialog.h>
#include <kio/netaccess.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kurl.h>
#include "brushdlg.h"
#include "choosefuncdlg.h"
#include "editparameterdlg.h"
#include "fitpack.h"
#include "funcdlg.h"
#include "funitem.h"
#include "kpldoc.h"
#include "kpldoubleedit.h"
#include "kplspinbox.h"
#include "rootdlg.h"
#include "splineitem.h"
#include "symboldlg.h"
#include "utils.h"

FuncDlg::FuncDlg(QWidget* _parent, KplDoc* model, FunItem* fd0) :
 KDialogBase(Plain, i18n("Function"),
             Help | Ok | Apply | Cancel | User1 | User2, Ok, _parent, 0,
             true, false, i18n("&Export"), i18n("R&oots")),
 m(model), fd(fd0)
{
  fdt = new FunItem(*fd);
  QFrame* frame = plainPage();
  QVBoxLayout* vbox = new QVBoxLayout(frame, 0, spacingHint());
  QGroupBox* g = new QGroupBox(0, Qt::Vertical, "y(x)", frame);
  vbox->addWidget(g);
  QGridLayout* grid = new QGridLayout(g->layout(), 3, 2, spacingHint());
  grid->addWidget(new QLabel(i18n("Library"), g), 0, 0);
  QHBoxLayout* hbox = new QHBoxLayout();
  grid->addLayout(hbox, 0, 1);
  hbox->addWidget(fileName = new QLineEdit(fd->pathy.isLocalFile() ?
                                           fd->pathy.path() :
                                           fd->pathy.url(), g));
  QPushButton* b = new QPushButton("...", g);
  b->setFixedWidth(28);
  hbox->addWidget(b);
  connect(b, SIGNAL(clicked()), SLOT(slotFile()));
  grid->addWidget(new QLabel(i18n("Function"), g), 1, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 1, 1);
  hbox->addWidget(func = new QLineEdit(fd->namey, g));
  hbox->addWidget(b = new QPushButton("...", g));
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotFunc()));
  grid->addWidget(new QLabel(i18n("Parameter"), g), 2, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 2, 1);
  hbox->addWidget(b = new QPushButton(i18n("Edit"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotEditParameter()));
  hbox->addWidget(b = new QPushButton(i18n("Load"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotGetParameter()));
  hbox->addWidget(b = new QPushButton(i18n("Save"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotSaveParameter()));
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Range"), frame));
  grid = new QGridLayout(g->layout(), 3, 5, spacingHint());
  grid->addWidget(new QLabel("xmin", g), 0, 0);
  char frm = m->options()->format;
  int prec = m->options()->prec;
  grid->addWidget(exMin = new KplDoubleEdit(fd->tmin, g, frm, prec), 0, 1);
  int w = exMin->fontMetrics().width(m->number(-1.0e-123 / 3.0)) + 3;
  exMin->setMinimumWidth(w);
  grid->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 2);
  grid->addWidget(new QLabel("xmax", g), 0, 3);
  grid->addWidget(exMax = new KplDoubleEdit(fd->tmax, g, frm, prec), 0, 4);
  exMax->setMinimumWidth(w);
#if KDE_VERSION_MAJOR > 2
  grid->addWidget(new QLabel(QString::fromUtf8("\316\224x"), g), 1, 0);
#else
  grid->addLayout(hbox = new QHBoxLayout(1), 1, 0);
  QLabel* l = new QLabel("D", g);
  l->setFont(QFont("Symbol", 12, QFont::Normal, false, QFont::AnyCharSet));
  hbox->addWidget(l);
  hbox->addWidget(new QLabel("x", g));
  hbox->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding));
#endif
  grid->addWidget(exStep = new KplDoubleEdit(fd->dt, g, frm, prec), 1, 1);
  exStep->setMinimumWidth(w);
  grid->addWidget(new QLabel(i18n("x normalization"), g), 2, 0);
  grid->addWidget(efx = new KplDoubleEdit(fd->fx, g), 2, 1);
  grid->addWidget(new QLabel(i18n("y normalization"), g), 2, 3);
  grid->addWidget(efy = new KplDoubleEdit(fd->fy, g), 2, 4);
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Representation"),
                                    frame));
  grid = new QGridLayout(g->layout(), 2, 6, spacingHint());
  grid->addWidget(new QLabel(i18n("Symbol"), g), 0, 0);
  grid->addWidget(symb = new KplSpinBox(-17, 9, 1, g), 0, 1);
  symb->setValue(fd->symb);
  grid->addWidget(new SymbolButton(g, symb), 0, 2);
  grid->addWidget(new QLabel(i18n("Color"), g), 0, 4);
  grid->addWidget(colData = new KColorButton(fd->color, g), 0, 5);
  colData->setMinimumWidth(50);
  grid->addWidget(new QLabel(i18n("Size"), g), 1, 0);
  grid->addWidget(eRelSize = new KplSpinBox(10, 800, 1, g), 1, 1);
  eRelSize->setValue(qRound(100 * fd->relsiz));
  eRelSize->setSuffix(" %");
  grid->addWidget(new QLabel(i18n("Fill pattern"), g), 1, 4);
  grid->addWidget(fill = new BrushButton(g, fd->fillStyle), 1, 5);
  setHelp("SEC-FUNC");
  Utils::setSize(this, "FuncDialog");
}

FuncDlg::~FuncDlg()
{
  Utils::saveSize(this, "FuncDialog");
  delete fdt;
}

void FuncDlg::getFunc(QWidget* parent, QLineEdit* name, QLineEdit* func, bool d3)
{
  QFileInfo fi(name->text());
  QString path = fi.dirPath(true) + "/" + fi.baseName() + ".def";
  QFile f(path);
  if (f.open(IO_ReadOnly)) {
    ChooseFuncDlg dlg(parent, &f, func, d3);
    dlg.exec();
  } else
    KMessageBox::error(parent,
                       i18n("while trying to open module definition file"));
}

bool FuncDlg::getTemp()
{
  fdt->fx = efx->value();
  fdt->fy = efy->value();
  fdt->tmin = exMin->value();
  fdt->tmax = exMax->value();
  fdt->dt = exStep->value();
  fdt->pathy = fileName->text();
  fdt->namey = func->text();
  if (fdt->hmody)
    lt_dlclose(fdt->hmody);
  if (FunItem::getFuncAddr(fdt->pathy.path(), fdt->namey, &fdt->hmody,
                           &fdt->fkty))
    return false;
  fdt->color = colData->color().rgb();
  fdt->symb = symb->interpretedValue();
  fdt->relsiz = 0.01 * eRelSize->interpretedValue();
  fdt->fillStyle = fill->value();
  return true;
}

void FuncDlg::getValues(bool ok)
{
  if (getTemp()) {
    *fd = *fdt;
    m->setModified();
    m->backupItems();
    if (ok)
      accept();
    else
      *fdt = *fd;
  }
}

void FuncDlg::slotFile()
{
  m->getFile(fileName);
}

void FuncDlg::slotFunc()
{
  getFunc(this, fileName, func);
}

void FuncDlg::slotGetParameter()
{
  m->getPar(this, fdt->py);
}

void FuncDlg::slotEditParameter()
{
  EditParameterDlg dlg(this, m, fdt->py, fileName->text(), func->text(), true);
  connect(&dlg, SIGNAL(applyClicked()), SLOT(slotApply()));
  dlg.exec();
}

void FuncDlg::slotSaveParameter()
{
  m->saveFunPar(this, fdt->py);
}

void FuncDlg::slotUser1()
{
  if (getTemp()) {
    KURL url;
    if (m->getWriteURL(this, url, "*.dat\n*")) {
      QFile f(url.isLocalFile() ? url.path() : m->tmpFile());
      if (f.open(IO_WriteOnly)) {
        QTextStream ts(&f);
        fdt->exportTable(ts, m);
        f.close();
        m->setCurrentDir(url);
        if (!url.isLocalFile())
          m->copyTmp(f.name(), url);
      } else
        KMessageBox::error(this, i18n("while trying to open"));
    }
  }
}

void FuncDlg::slotUser2()
{
  if (getTemp())
    if (fdt->tmax > fdt->tmin) {
      int n = fdt->calcTable(fdt->logxo);
      QArray<double> w(n);
      for (int i = 0; i < n; i++)
        w[i] = 1.0;
      int nest = n + 4;
      int lwrk = n * 4 + nest * 16;
      QArray<double> wrk(lwrk);
      QArray<int> iwrk(nest);
      double fp;
      SplineItem spl;
      spl.t.resize(nest);
      spl.c.resize(nest);
      int ier;
      FitPack::curfit(0, n, fdt->tv, fdt->yv, w, fdt->tmin, fdt->tmax, 3, 0.0,
                      nest, &spl.nk, spl.t.data(), spl.c.data(), &fp,
                      wrk.data(), lwrk, iwrk.data(), &ier);
      RootDlg dlg(this, m, &spl);
      dlg.exec();
    } else
      KMessageBox::sorry(this, i18n("invalid range!"));
}

void FuncDlg::slotOk()
{
  getValues(true);
}

void FuncDlg::slotApply()
{
  getValues(false);
}

ParFuncDlg::ParFuncDlg(QWidget* _parent, KplDoc* model, ParFunItem* fd0) :
 KDialogBase(Plain, i18n("Parametric function"),
             Help | Ok | Apply | Cancel | User1, Ok, _parent, 0,
             true, false, i18n("&Export")),
 m(model), fd(fd0)
{
  fdt = new ParFunItem(*fd);
  QFrame* frame = plainPage();
  QVBoxLayout* vbox = new QVBoxLayout(frame, 0, spacingHint());
  QGroupBox* g = new QGroupBox(0, Qt::Vertical, "x(t)", frame);
  vbox->addWidget(g);
  QGridLayout* grid = new QGridLayout(g->layout(), 3, 2, spacingHint());
  grid->addWidget(new QLabel(i18n("Library"), g), 0, 0);
  QHBoxLayout* hbox = new QHBoxLayout();
  grid->addLayout(hbox, 0, 1);
  hbox->addWidget(fileNamex = new QLineEdit(fd->pathx.isLocalFile() ?
                                            fd->pathx.path() :
                                            fd->pathx.url(), g));
  QPushButton* b = new QPushButton("...", g);
  b->setFixedWidth(28);
  hbox->addWidget(b);
  connect(b, SIGNAL(clicked()), SLOT(slotFilex()));
  grid->addWidget(new QLabel(i18n("Function"), g), 1, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 1, 1);
  hbox->addWidget(funcx = new QLineEdit(fd->namex, g));
  hbox->addWidget(b = new QPushButton("...", g));
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotFuncx()));
  grid->addWidget(new QLabel(i18n("Parameter"), g), 2, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 2, 1);
  hbox->addWidget(b = new QPushButton(i18n("Edit"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotEditParameterx()));
  hbox->addWidget(b = new QPushButton(i18n("Load"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotGetParameterx()));
  hbox->addWidget(b = new QPushButton(i18n("Save"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotSaveParameterx()));
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, "y(t)", frame));
  grid = new QGridLayout(g->layout(), 3, 2, spacingHint());
  grid->addWidget(new QLabel(i18n("Library"), g), 0, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 0, 1);
  hbox->addWidget(fileNamey = new QLineEdit(fd->pathy.isLocalFile() ?
                                            fd->pathy.path() :
                                            fd->pathy.url(), g));
  hbox->addWidget(b = new QPushButton("...", g));
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotFiley()));
  grid->addWidget(new QLabel(i18n("Function"), g), 1, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 1, 1);
  hbox->addWidget(funcy = new QLineEdit(fd->namey, g));
  hbox->addWidget(b = new QPushButton("...", g));
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotFuncy()));
  grid->addWidget(new QLabel(i18n("Parameter"), g), 2, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 2, 1);
  hbox->addWidget(b = new QPushButton(i18n("Edit"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotEditParametery()));
  hbox->addWidget(b = new QPushButton(i18n("Load"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotGetParametery()));
  hbox->addWidget(b = new QPushButton(i18n("Save"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotSaveParametery()));
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Range"), frame));
  grid = new QGridLayout(g->layout(), 3, 5, spacingHint());
  grid->addWidget(new QLabel("tmin", g), 0, 0);
  char frm = m->options()->format;
  int prec = m->options()->prec;
  grid->addWidget(etMin = new KplDoubleEdit(fd->tmin, g, frm, prec), 0, 1);
  int w = etMin->fontMetrics().width(m->number(-1.0e-123 / 3.0)) + 3;
  etMin->setMinimumWidth(w);
  grid->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 2);
  grid->addWidget(new QLabel("tmax", g), 0, 3);
  grid->addWidget(etMax = new KplDoubleEdit(fd->tmax, g, frm, prec), 0, 4);
  etMax->setMinimumWidth(w);
#if KDE_VERSION_MAJOR > 2
  grid->addWidget(new QLabel(QString::fromUtf8("\316\224t"), g), 1, 0);
#else
  grid->addLayout(hbox = new QHBoxLayout(1), 1, 0);
  QLabel* l = new QLabel("D", g);
  l->setFont(QFont("Symbol", 12, QFont::Normal, false, QFont::AnyCharSet));
  hbox->addWidget(l);
  hbox->addWidget(new QLabel("t", g));
  hbox->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding));
#endif
  grid->addWidget(etStep = new KplDoubleEdit(fd->dt, g, frm, prec), 1, 1);
  etStep->setMinimumWidth(w);
  grid->addWidget(new QLabel(i18n("x normalization"), g), 2, 0);
  grid->addWidget(efx = new KplDoubleEdit(fd->fx, g), 2, 1);
  grid->addWidget(new QLabel(i18n("y normalization"), g), 2, 3);
  grid->addWidget(efy = new KplDoubleEdit(fd->fy, g), 2, 4);
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Representation"),
                                    frame));
  grid = new QGridLayout(g->layout(), 2, 6, spacingHint());
  grid->addWidget(new QLabel(i18n("Symbol"), g), 0, 0);
  grid->addWidget(symb = new KplSpinBox(-17, 9, 1, g), 0, 1);
  symb->setValue(fd->symb);
  grid->addWidget(new SymbolButton(g, symb), 0, 2);
  grid->addWidget(new QLabel(i18n("Color"), g), 0, 4);
  grid->addWidget(colData = new KColorButton(fd->color, g), 0, 5);
  colData->setMinimumWidth(50);
  grid->addWidget(new QLabel(i18n("Size"), g), 1, 0);
  grid->addWidget(eRelSize = new KplSpinBox(10, 800, 1, g), 1, 1);
  eRelSize->setValue(qRound(100 * fd->relsiz));
  eRelSize->setSuffix(" %");
  grid->addWidget(new QLabel(i18n("Fill pattern"), g), 1, 4);
  grid->addWidget(fill = new BrushButton(g, fd->fillStyle), 1, 5);
  setHelp("SEC-PARFUNC");
  Utils::setSize(this, "ParFuncDialog");
}

ParFuncDlg::~ParFuncDlg()
{
  Utils::saveSize(this, "ParFuncDialog");
  delete fdt;
}

bool ParFuncDlg::getTemp()
{
  fdt->fx = efx->value();
  fdt->fy = efy->value();
  fdt->tmin = etMin->value();
  fdt->tmax = etMax->value();
  fdt->dt = etStep->value();
  fdt->pathx = fileNamex->text();
  fdt->namex = funcx->text();
  if (fdt->hmodx)
    lt_dlclose(fdt->hmodx);
  if (FunItem::getFuncAddr(fdt->pathx.path(), fdt->namex, &fdt->hmodx,
                           &fdt->fktx))
    return false;
  fdt->pathy = fileNamey->text();
  fdt->namey = funcy->text();
  if (fdt->hmody)
    lt_dlclose(fdt->hmody);
  if (FunItem::getFuncAddr(fdt->pathy.path(), fdt->namey, &fdt->hmody,
                           &fdt->fkty))
    return false;
  fdt->color = colData->color().rgb();
  fdt->symb = symb->interpretedValue();
  fdt->relsiz = 0.01 * eRelSize->interpretedValue();
  fdt->fillStyle = fill->value();
  return true;
}

void ParFuncDlg::getValues(bool ok)
{
  if (getTemp()) {
    *fd = *fdt;
    m->setModified();
    m->backupItems();
    if (ok)
      accept();
  }
}

void ParFuncDlg::slotFilex()
{
  m->getFile(fileNamex);
}

void ParFuncDlg::slotFiley()
{
  m->getFile(fileNamey);
}

void ParFuncDlg::slotFuncx()
{
  FuncDlg::getFunc(this, fileNamex, funcx);
}

void ParFuncDlg::slotFuncy()
{
  FuncDlg::getFunc(this, fileNamey, funcy);
}

void ParFuncDlg::slotGetParameterx()
{
  m->getPar(this, fdt->px);
}

void ParFuncDlg::slotGetParametery()
{
  m->getPar(this, fdt->py);
}

void ParFuncDlg::slotEditParameterx()
{
  EditParameterDlg dlg(this, m, fdt->px, fileNamex->text(), funcx->text(),
                       true);
  connect(&dlg, SIGNAL(applyClicked()), SLOT(slotApply()));
  dlg.exec();
}

void ParFuncDlg::slotEditParametery()
{
  EditParameterDlg dlg(this, m, fdt->py, fileNamey->text(), funcy->text(),
                       true);
  connect(&dlg, SIGNAL(applyClicked()), SLOT(slotApply()));
  dlg.exec();
}

void ParFuncDlg::slotSaveParameterx()
{
  m->saveFunPar(this, fdt->px);
}

void ParFuncDlg::slotSaveParametery()
{
  m->saveFunPar(this, fdt->py);
}

void ParFuncDlg::slotUser1()
{
  if (getTemp()) {
    KURL url;
    if (m->getWriteURL(this, url, "*.dat\n*")) {
      QFile f(url.isLocalFile() ? url.path() : m->tmpFile());
      if (f.open(IO_WriteOnly)) {
        QTextStream ts(&f);
        fdt->exportTable(ts, m);
        f.close();
        m->setCurrentDir(url);
        if (!url.isLocalFile())
          m->copyTmp(f.name(), url);
      } else
        KMessageBox::error(this, i18n("while trying to open"));
    }
  }
}

void ParFuncDlg::slotOk()
{
  getValues(true);
}

void ParFuncDlg::slotApply()
{
  getValues(false);
}
