if(BUILD_REENTRANT)
set(REENTRANT 1)
set(_REENTRANT 1)
endif(BUILD_REENTRANT)

if(BUILD_THREADSAFE)
set(THREADSAFE 1)
set(_THREADSAFE 1)
set(THREAD_SAFE 1)
set(_THREAD_SAFE 1)
endif(BUILD_THREADSAFE)

#/* set to the number of arguments ctime_r() expects */
set(CTIME_R_NARGS 2) # best guess
#/* define to enable rewriting in back-ldap and back-meta */
set(ENABLE_REWRITE 1)
#/* defined to be the EXE extension */
set(EXEEXT "\".exe\"")
#/* if you have NT Event Log */
set(HAVE_NT_EVENT_LOG 1)
#/* if you have NT Service Manager */
set(HAVE_NT_SERVICE_MANAGER 1)
#/* if you have NT Threads */
set(HAVE_NT_THREADS 1)
#/* Define to 1 if the system has the type `ptrdiff_t'. */
set(HAVE_PTRDIFF_T 1)
#/* define if you have winsock */
set(HAVE_WINSOCK 1)
#/* define if you have winsock2 */
set(HAVE_WINSOCK2 1)
#/* define to snprintf routine */
set(snprintf _snprintf)
set(HAVE_SYS_ERRLIST 1)

if(${OPENSSL_FOUND})
    set(HAVE_OPENSSL 1)
    #/* define if you have OpenSSL with CRL checking capability */
    set(HAVE_OPENSSL_CRL 1)
    #/* define if OpenSSL needs RSAref */
    set(HAVE_RSAREF 0)
    set(CMAKE_REQUIRED_INCLUDES ${OPENSSL_INCLUDE_DIR})
endif(${OPENSSL_FOUND})

if(${SASL2_FOUND})
    #/* define if your SASL library has sasl_version() */
    set(HAVE_SASL 1)
    set(HAVE_SASL_VERSION 1)
endif(${SASL2_FOUND})

include(CheckIncludeFile)
include(CheckTypeSize)
check_include_file("arpa/inet.h" HAVE_ARPA_INET_H)
check_include_file("arpa/nameser.h" HAVE_ARPA_NAMESER_H)
check_include_file("assert.h" HAVE_ASSERT_H)
check_include_file("bits/types.h" HAVE_BITS_TYPES_H)
check_include_file("conio.h" HAVE_CONIO_H)
check_include_file("crypt.h" HAVE_CRYPT_H)
check_include_file("cthreads.h" HAVE_CTHREADS_H)
check_include_file("db.h" HAVE_DB_H)
check_include_file("direct.h" HAVE_DIRECT_H)
check_include_file("dirent.h" HAVE_DIRENT_H)
check_include_file("dlfcn.h" HAVE_DLFCN_H)
check_include_file("errno.h" HAVE_ERRNO_H)
check_include_file("fcntl.h" HAVE_FCNTL_H)
check_include_file("filio.h" HAVE_FILIO_H)
check_include_file("getopt.h" HAVE_GETOPT_H)
check_include_file("gmp.h" HAVE_GMP_H)
check_include_file("gnutls/gnutls.h" HAVE_GNUTLS_GNUTLS_H)
check_include_file("grp.h" HAVE_GRP_H)
check_include_file("inttypes.h" HAVE_INTTYPES_H)
check_include_file("libutil.h" HAVE_LIBUTIL_H)
check_include_file("limits.h" HAVE_LIMITS_H)
check_include_file("locale.h" HAVE_LOCALE_H)
check_include_file("ltdl.h" HAVE_LTDL_H)
check_include_file("mach/cthreads.h" HAVE_MACH_CTHREADS_H)
check_include_file("malloc.h" HAVE_MALLOC_H)
check_include_file("memory.h" HAVE_MEMORY_H)
check_include_file("ndir.h" HAVE_NDIR_H)
check_include_file("netinet/tcp.h" HAVE_NETINET_TCP_H)
check_include_file("nssutil.h" HAVE_NSSUTIL_H)
check_include_file("openssl/bn.h" HAVE_OPENSSL_BN_H)
check_include_file("openssl/crypto.h" HAVE_OPENSSL_CRYPTO_H)
check_include_file("openssl/ssl.h" HAVE_OPENSSL_SSL_H)
check_include_file("io.h" HAVE_IO_H)
check_include_file("poll.h" HAVE_POLL_H)
check_include_file("process.h" HAVE_PROCESS_H)
check_include_file("psap.h" HAVE_PSAP_H)
check_include_file("pthread.h" HAVE_PTHREAD_H)
check_include_file("pth.h" HAVE_PTH_H)
check_include_file("pwd.h" HAVE_PWD_H)
check_include_file("regex.h" HAVE_REGEX_H)
check_include_file("pcreposix.h" HAVE_PCREPOSIX_H)
if(HAVE_PCREPOSIX_H)
    set(HAVE_REGEX_H 1)
endif(HAVE_PCREPOSIX_H)
check_include_file("resolv.h" HAVE_RESOLV_H)
check_include_file("sasl.h" HAVE_SASL_H)
check_include_file("sasl/sasl.h" HAVE_SASL_SASL_H)
check_include_file("sched.h" HAVE_SCHED_H)
check_include_file("sgtty.h" HAVE_SGTTY_H)
check_include_file("shadow.h" HAVE_SHADOW_H)
check_include_file("sqlext.h" HAVE_SQLEXT_H)
check_include_file("sql.h" HAVE_SQL_H)
check_include_file("stddef.h" HAVE_STDDEF_H)
check_include_file("stdint.h" HAVE_STDINT_H)
check_include_file("stdlib.h" HAVE_STDLIB_H)
check_include_file("slp.h" HAVE_SLP_H)
check_include_file("strings.h" HAVE_STRINGS_H)
check_include_file("string.h" HAVE_STRING_H)
check_include_file("synch.h" HAVE_SYNCH_H)
check_include_file("sysexits.h" HAVE_SYSEXITS_H)
check_include_file("syslog.h" HAVE_SYSLOG_H)
check_include_file("sys/devpoll.h" HAVE_SYS_DEVPOLL_H)
check_include_file("sys/dir.h" HAVE_SYS_DIR_H)
check_include_file("sys/epoll.h" HAVE_SYS_EPOLL_H)
check_include_file("sys/errno.h" HAVE_SYS_ERRNO_H)
check_include_file("sys/file.h" HAVE_SYS_FILE_H)
check_include_file("sys/filio.h" HAVE_SYS_FILIO_H)
check_include_file("sys/fstyp.h" HAVE_SYS_FSTYP_H)
check_include_file("sys/ioctl.h" HAVE_SYS_IOCTL_H)
check_include_file("sys/ndir.h" HAVE_SYS_NDIR_H)
check_include_file("sys/param.h" HAVE_SYS_PARAM_H)
check_include_file("sys/poll.h" HAVE_SYS_POLL_H)
check_include_file("sys/privgrp.h" HAVE_SYS_PRIVGRP_H)
check_include_file("sys/resource.h" HAVE_SYS_RESOURCE_H)
check_include_file("sys/select.h" HAVE_SYS_SELECT_H)
check_include_file("sys/socket.h" HAVE_SYS_SOCKET_H)
check_include_file("sys/stat.h" HAVE_SYS_STAT_H)
check_include_file("sys/syslog.h" HAVE_SYS_SYSLOG_H)
check_include_file("sys/time.h" HAVE_SYS_TIME_H)
check_include_file("sys/types.h" HAVE_SYS_TYPES_H)
check_include_file("sys/ucred.h" HAVE_SYS_UCRED_H)
check_include_file("sys/uio.h" HAVE_SYS_UIO_H)
check_include_file("sys/un.h" HAVE_SYS_UN_H)
check_include_file("sys/uuid.h" HAVE_SYS_UUID_H)
check_include_file("sys/vmount.h" HAVE_SYS_VMOUNT_H)
check_include_file("sys/wait.h" HAVE_SYS_WAIT_H)
check_include_file("tcpd.h" HAVE_TCPD_H)
check_include_file("termios.h" HAVE_TERMIOS_H)
check_include_file("thread.h" HAVE_THREAD_H)
check_include_file("unicode/utypes.h" HAVE_UNICODE_UTYPES_H)
check_include_file("unistd.h" HAVE_UNISTD_H)
check_include_file("utime.h" HAVE_UTIME_H)
check_include_file("uuid/uuid.h" HAVE_UUID_UUID_H)
check_include_file("winsock2.h" HAVE_WINSOCK2_H)
check_include_file("winsock.h" HAVE_WINSOCK_H)

# berkeley db might be interesting for later usage
#/* define this if Berkeley DB is available */#undef HAVE_BERKELEY_DB
#/* define if Berkeley DB has DB_THREAD support */#undef HAVE_BERKELEY_DB_THREAD
#/* define if you have Cyrus SASL */#undef HAVE_CYRUS_SASL
#/* define if you have GNUtls */#undef HAVE_GNUTLS
#/* if you have GNU Pth */#undef HAVE_GNU_PTH
#/* define if you actually have ICU */#undef HAVE_ICU
#/* Define to 1 if you have the `gmp' library (-lgmp). */#undef HAVE_LIBGMP

#/* define to use both <string.h> and <strings.h> */#undef BOTH_STRINGS_H
#/* define if toupper() requires islower() */ #undef C_UPPER_LOWER
#/* set to the number of arguments gethostbyaddr_r() expects */#undef GETHOSTBYADDR_R_NARGS
#/* set to the number of arguments gethostbyname_r() expects */#undef GETHOSTBYNAME_R_NARGS
#/* Define to 1 if `TIOCGWINSZ' requires <sys/ioctl.h>. */#undef GWINSZ_IN_SYS_IOCTL
#/* define if you have AIX security lib */#undef HAVE_AIX_SECURITY

include(CheckFunctionExists)
check_function_exists("chroot" HAVE_CHROOT)
check_function_exists("bcopy" HAVE_BCOPY)
check_function_exists("closesocket" HAVE_CLOSESOCKET)
check_function_exists("ctime_r" HAVE_CTIME_R)
check_function_exists("endgrent" HAVE_ENDGRENT)
check_function_exists("endpwent" HAVE_ENDPWENT)
check_function_exists("fcntl" HAVE_FCNTL)
check_function_exists("flock" HAVE_FLOCK)
check_function_exists("fstat" HAVE_FSTAT)
check_function_exists("gai_strerror" HAVE_GAI_STRERROR)
check_function_exists("getaddrinfo" HAVE_GETADDRINFO)
check_function_exists("getdtablesize" HAVE_GETDTABLESIZE)
check_function_exists("geteuid" HAVE_GETEUID)
check_function_exists("getgrgid" HAVE_GETGRGID)
check_function_exists("gethostbyaddr_r" HAVE_GETHOSTBYADDR_R)
check_function_exists("gethostbyname_r" HAVE_GETHOSTBYNAME_R)
check_function_exists("gethostname" HAVE_GETHOSTNAME)
check_function_exists("getnameinfo" HAVE_GETNAMEINFO)
check_function_exists("getopt" HAVE_GETOPT)
check_function_exists("getpassphrase" HAVE_GETPASSPHRASE)
check_function_exists("getpeereid" HAVE_GETPEEREID)
check_function_exists("getpeerucred" HAVE_GETPEERUCRED)
check_function_exists("getpwnam" HAVE_GETPWNAM)
check_function_exists("getpwuid" HAVE_GETPWUID)
check_function_exists("getspnam" HAVE_GETSPNAM)
check_function_exists("gettimeofday" HAVE_GETTIMEOFDAY)
check_function_exists("gmtime_r" HAVE_GMTIME_R)
check_function_exists("hstrerror" HAVE_HSTRERROR)
check_function_exists("inet_ntoa_b" HAVE_INET_NTOA_B)
check_function_exists("inet_ntop" HAVE_INET_NTOP)
check_function_exists("initgroups" HAVE_INITGROUPS)
check_function_exists("ioctl" HAVE_IOCTL)
check_function_exists("localtime_r" HAVE_LOCALTIME_R)
check_function_exists("lockf" HAVE_LOCKF)
check_function_exists("memcpy" HAVE_MEMCPY)
check_function_exists("memmove" HAVE_MEMMOVE)
check_function_exists("memrchr" HAVE_MEMRCHR)
check_function_exists("mkstemp" HAVE_MKSTEMP)
check_function_exists("mktemp" HAVE_MKTEMP)
check_function_exists("pipe" HAVE_PIPE)
check_function_exists("poll" HAVE_POLL)
check_function_exists("pthread_detach" HAVE_PTHREAD_DETACH)
check_function_exists("pthread_getconcurrency" HAVE_PTHREAD_GETCONCURRENCY)
check_function_exists("pthread_kill" HAVE_PTHREAD_KILL)
check_function_exists("pthread_kill_other_threads_np" HAVE_PTHREAD_KILL_OTHER_THREADS_NP)
check_function_exists("pthread_rwlock_destroy function" HAVE_PTHREAD_RWLOCK_DESTROY)
check_function_exists("pthread_setconcurrency" HAVE_PTHREAD_SETCONCURRENCY)
check_function_exists("pthread_yield" HAVE_PTHREAD_YIELD)
check_function_exists("read" HAVE_READ)
check_function_exists("recv" HAVE_RECV)
check_function_exists("recvfrom" HAVE_RECVFROM)
check_function_exists("sched_yield" HAVE_SCHED_YIELD)
check_function_exists("send" HAVE_SEND)
check_function_exists("sendmsg" HAVE_SENDMSG)
check_function_exists("sendto" HAVE_SENDTO)
check_function_exists("setegid" HAVE_SETEGID)
check_function_exists("seteuid" HAVE_SETEUID)
check_function_exists("setgid" HAVE_SETGID)
check_function_exists("setpwfile" HAVE_SETPWFILE)
check_function_exists("setsid" HAVE_SETSID)
check_function_exists("setuid" HAVE_SETUID)
check_function_exists("sigaction" HAVE_SIGACTION)
check_function_exists("signal" HAVE_SIGNAL)
check_function_exists("sigset" HAVE_SIGSET)
check_function_exists("snprintf" HAVE_SNPRINTF)
check_function_exists("strdup" HAVE_STRDUP)
check_function_exists("strerror" HAVE_STRERROR)
check_function_exists("strerror_r" HAVE_STRERROR_R)
check_function_exists("strftime" HAVE_STRFTIME)
check_function_exists("strpbrk" HAVE_STRPBRK)
check_function_exists("strrchr" HAVE_STRRCHR)
check_function_exists("strsep" HAVE_STRSEP)
check_function_exists("strspn" HAVE_STRSPN)
check_function_exists("strstr" HAVE_STRSTR)
check_function_exists("strtol" HAVE_STRTOL)
check_function_exists("strtoll" HAVE_STRTOLL)
check_function_exists("strtoq" HAVE_STRTOQ)
check_function_exists("strtoul" HAVE_STRTOUL)
check_function_exists("strtoull" HAVE_STRTOULL)
check_function_exists("strtouq" HAVE_STRTOUQ)
check_function_exists("sysconf" HAVE_SYSCONF)
#check_function_exists("thr_getconcurrency" HAVE_THR_GETCONCURRENCY)
#check_function_exists("thr_setconcurrency" HAVE_THR_SETCONCURRENCY)
#check_function_exists("thr_yield" HAVE_THR_YIELD)
check_function_exists("vprintf" HAVE_VPRINTF)
check_function_exists("vsnprintf" HAVE_VSNPRINTF)
check_function_exists("wait4" HAVE_WAIT4)
check_function_exists("waitpid" HAVE_WAITPID)
check_function_exists("write" HAVE_WRITE)
check_function_exists("_vsnprintf" HAVE__VSNPRINTF)

set(CMAKE_EXTRA_INCLUDE_FILES sys/types.h)
check_type_size("mode_t" MODE_T)
set(CMAKE_EXTRA_INCLUDE_FILES)

#/* define if crypt(3) is available */
#undef HAVE_CRYPT
#/* Define to 1 if you don't have `vprintf' but do have `_doprnt.' */
#undef HAVE_DOPRNT
#/* define if system uses EBCDIC instead of ASCII */
#undef HAVE_EBCDIC
#/* define if your system supports epoll */
#undef HAVE_EPOLL
#/* define if you actually have FreeBSD fetch(3) */
#undef HAVE_FETCH
#/* define if your system supports /dev/poll */
#undef HAVE_DEVPOLL
#/* define to you inet_aton(3) is available */
#undef HAVE_INET_ATON
#/* if you have LinuxThreads */
#undef HAVE_LINUX_THREADS
#/* define if you have Mach Cthreads */
#undef HAVE_MACH_CTHREADS
#/* define this if you have mkversion */
#undef HAVE_MKVERSION
#/* define if you have MozNSS */
#undef HAVE_MOZNSS
#/* define if strerror_r returns char* instead of int */
#undef HAVE_NONPOSIX_STRERROR_R



#/* Define to 1 if you have the `gen' library (-lgen). */
#undef HAVE_LIBGEN
#/* Define to 1 if you have the `inet' library (-linet). */
#undef HAVE_LIBINET
#/* define if you have libtool -ltdl */
#undef HAVE_LIBLTDL
#/* Define to 1 if you have the `net' library (-lnet). */
#undef HAVE_LIBNET
#/* Define to 1 if you have the `nsl' library (-lnsl). */
#undef HAVE_LIBNSL
#/* Define to 1 if you have the `nsl_s' library (-lnsl_s). */
#undef HAVE_LIBNSL_S
#/* Define to 1 if you have the `socket' library (-lsocket). */
#undef HAVE_LIBSOCKET
#/* Define to 1 if you have the `V3' library (-lV3). */
#undef HAVE_LIBV3

#/* Define to 1 if the system has the type `long long'. */
set(HAVE_LONG_LONG 1)

#/* define to pthreads API spec revision */
#undef HAVE_PTHREADS
#/* define if you have res_query() */
#undef HAVE_RES_QUERY
#/* define if setproctitle(3) is available */
#undef HAVE_SETPROCTITLE
#/* define if you have -lslp */
#undef HAVE_SLP
#/* if you have spawnlp() */
#undef HAVE_SPAWNLP
#/* Define to 1 if `msg_accrightslen' is member of `struct msghdr'. */
#undef HAVE_STRUCT_MSGHDR_MSG_ACCRIGHTSLEN
#/* Define to 1 if `msg_control' is member of `struct msghdr'. */
#undef HAVE_STRUCT_MSGHDR_MSG_CONTROL
#/* Define to 1 if `pw_gecos' is member of `struct passwd'. */
#undef HAVE_STRUCT_PASSWD_PW_GECOS
#/* Define to 1 if `pw_passwd' is member of `struct passwd'. */
#undef HAVE_STRUCT_PASSWD_PW_PASSWD
#/* Define to 1 if `st_blksize' is member of `struct stat'. */
#undef HAVE_STRUCT_STAT_ST_BLKSIZE
#/* Define to 1 if `st_fstype' is member of `struct stat'. */
#undef HAVE_STRUCT_STAT_ST_FSTYPE
#/* define to 1 if st_fstype is char * */
#undef HAVE_STRUCT_STAT_ST_FSTYPE_CHAR
#/* define to 1 if st_fstype is int */
#undef HAVE_STRUCT_STAT_ST_FSTYPE_INT
#/* Define to 1 if `st_vfstype' is member of `struct stat'. */
#undef HAVE_STRUCT_STAT_ST_VFSTYPE
#/* define if you have -lwrap */
#undef HAVE_TCPD
#/* if you have Solaris LWP (thr) package */
#undef HAVE_THR
#/* define if you have TLS */
#undef HAVE_TLS
#/* define if you have uuid_generate() */
#undef HAVE_UUID_GENERATE
#/* define if you have uuid_to_str() */
#undef HAVE_UUID_TO_STR
#/* define if select implicitly yields */
#undef HAVE_YIELDING_SELECT


#/* define to 32-bit or greater integer type */
set(LBER_INT_T "int")
#/* define to large integer type */
set(LBER_LEN_T "int")
#/* define to socket descriptor type */
set(LBER_SOCKET_T "int")
#/* define to large integer type */
set(LBER_TAG_T "int")

#########################################################
#/* define to 1 if library is thread safe */
if(BUILD_THREADSAFE)
    set(LDAP_API_FEATURE_X_OPENLDAP_THREAD_SAFE 1)
endif(BUILD_THREADSAFE)

#/* Major */
set(LDAP_VENDOR_VERSION_MAJOR 2)

#/* Minor */
set(LDAP_VENDOR_VERSION_MINOR 4)

#/* Patch */
set(LDAP_VENDOR_VERSION_PATCH 28)

#/* Version */
MATH(EXPR LDAP_VENDOR_VERSION "${LDAP_VENDOR_VERSION_MAJOR} * 10000 + ${LDAP_VENDOR_VERSION_MINOR} * 100 + ${LDAP_VENDOR_VERSION_PATCH}")

#/* define if memcmp is not 8-bit clean or is otherwise broken */
#undef NEED_MEMCMP_REPLACEMENT

#/* define if you have (or want) no threads */
#undef NO_THREADS

#/* define to use the original debug style */
#undef OLD_DEBUG

#/* Package */
set(OPENLDAP_PACKAGE "\"OpenLDAP\"")

#/* Version */
set(OPENLDAP_VERSION "\"${LDAP_VENDOR_VERSION_MAJOR}.${LDAP_VENDOR_VERSION_MINOR}.${LDAP_VENDOR_VERSION_PATCH}\"")

#/* Define to the address where bug reports for this package should be sent. */
set(PACKAGE_BUGREPORT "kde-windows@kde.org")
#/* Define to the full name of this package. */
set(PACKAGE_NAME "")
#/* Define to the full name and version of this package. */
set(PACKAGE_STRING "")
#/* Define to the one symbol short name of this package. */
set(PACKAGE_TARNAME "")
#/* Define to the version of this package. */
set(PACKAGE_VERSION "")

#/* define if sched_yield yields the entire process */
#undef REPLACE_BROKEN_YIELD
#/* Define to the type of arg 1 for `select'. */
#undef SELECT_TYPE_ARG1
#/* Define to the type of args 2, 3 and 4 for `select'. */
#undef SELECT_TYPE_ARG234
#/* Define to the type of arg 5 for `select'. */
#undef SELECT_TYPE_ARG5

#/* The size of `int', as computed by sizeof. */
set(SIZEOF_INT 4)
#/* The size of `long', as computed by sizeof. */
set(SIZEOF_LONG 4)
#/* The size of `long long', as computed by sizeof. */
set(SIZEOF_LONG_LONG 8)
#/* The size of `short', as computed by sizeof. */
set(SIZEOF_SHORT 2)
#/* The size of `wchar_t', as computed by sizeof. */
set(SIZEOF_WCHAR_T 2)

#/* Define as the return type of signal handlers (`int' or `void'). */
set(RETSIGTYPE void)
#/* Define to 1 if you have the ANSI C header files. */
set(STDC_HEADERS 1)

#/* set to urandom device */
#undef URANDOM_DEVICE

#/* define to use OpenSSL BIGNUM for MP */
#undef USE_MP_BIGNUM

#/* define to use GMP for MP */
#undef USE_MP_GMP

#/* define to use 'long' for MP */
#undef USE_MP_LONG

#/* define to use 'long long' for MP */
#undef USE_MP_LONG_LONG

#/* Define to 1 if your processor stores words with the most significant byte
#   first (like Motorola and SPARC, unlike Intel and VAX). */
#undef WORDS_BIGENDIAN

#/* Define to the type of arg 3 for `accept'. */
set(ber_socklen_t int)
#/* Define to `char *' if <sys/types.h> does not define. */
set(caddr_t "char*")
#/* Define to empty if `const' does not conform to ANSI C. */
#undef const
#/* Define to `int' if <sys/types.h> doesn't define. */
set(gid_t int)
#/* Define to `int' if <sys/types.h> does not define. */
if (NOT HAVE_MODE_T)
set(mode_t int)
endif()
#/* Define to `long' if <sys/types.h> does not define. */
#set(off_t long)
#/* Define to `int' if <sys/types.h> does not define. */
set(pid_t int)
#/* Define to `int' if <signal.h> does not define. */
#set(sig_atomic_t int)
#/* Define to `unsigned' if <sys/types.h> does not define. */
set(size_t unsigned int)
#/* Define like ber_socklen_t if <sys/socket.h> does not define. */
#undef socklen_t
#/* Define to `signed int' if <sys/types.h> does not define. */
set(ssize_t signed int)
#/* Define to `int' if <sys/types.h> doesn't define. */
set(uid_t int)
#/* define as empty if volatile is not supported */
#undef volatile
#/* define to snprintf routine */
#undef vsnprintf

