/****************************************************************************
**
** Copyright (C) 2012 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the test suite of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Digia.  For licensing terms and
** conditions see http://qt.digia.com/licensing.  For further information
** use the contact form at http://qt.digia.com/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Digia gives you certain additional
** rights.  These rights are described in the Digia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef HTMLGENERATOR_H
#define HTMLGENERATOR_H

#include "xmldata.h"

#include <QTextStream>
#include <QList>
#include <QString>

QT_FORWARD_DECLARE_CLASS(QStringList)
QT_FORWARD_DECLARE_CLASS(QSettings)

struct HTMLImage
{
public:
    QString        file;
    QString        generatorName;
    GeneratorFlags flags;
    QString        details;
};

struct HTMLRow
{
public:
    QString testcase;
    QList<HTMLImage> referenceImages;
    QList<HTMLImage> foreignImages;
    QList<HTMLImage> images;
};

struct HTMLSuite
{
public:
    QString name;
    QMap<QString, HTMLRow*> rows;
};

class HTMLGenerator
{
public:
    HTMLGenerator();

    void startSuite(const QString &name);
    void startRow(const QString &testcase);
    void addImage(const QString &generator, const QString &image,
                  const QString &details, GeneratorFlags flags);
    void endRow();
    void endSuite();

    void generateIndex(const QString &file);
    void generatePages();

    void run(int argc, char **argv);

private:
    void generateSuite(const HTMLSuite &suite);

    void generateReferencePage(const HTMLSuite &suite);
    void generateHistoryPages(const HTMLSuite &suite);
    void generateHistoryForEngine(const HTMLSuite &suite, const QString &engine);
    void generateQtComparisonPage(const HTMLSuite &suite);

    void generateHeader(QTextStream &out, const QString &name,
                        const QStringList &generators);
    void startGenerateRow(QTextStream &out, const QString &name);
    void generateImages(QTextStream &out,
                        const QList<HTMLImage> &images);
    void generateHistoryImages(QTextStream &out,
                               const QList<HTMLImage> &images);
    void finishGenerateRow(QTextStream &out, const QString &name);
    void generateFooter(QTextStream &out);

    void processArguments(int argc, char **argv);
    void convertToHtml();
    void createPerformance();
private:
    QMap<QString, HTMLSuite*> suites;
    QMap<QString, XMLEngine*> engines;

    QSettings *settings;
    QString outputDirName;
    QString baseDataDir;
    QString htmlOutputDir;
};

#endif
