<?php
/**
 * $Horde: imp/expand.php,v 1.13 2003/07/16 02:02:48 slusarz Exp $
 *
 * Copyright 2002-2003 Jan Schneider <jan@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

$no_compress = true;
$authentication = 'horde';

define('IMP_BASE', dirname(__FILE__));
require_once IMP_BASE . '/lib/base.php';

$actionID = Horde::getFormData('actionID');

if ($actionID == 'expand_addresses') {
    $field_name  = Horde::getFormData('field_name');
    $field_value = Horde::getFormData('field_value');
    $address = IMP::expandAddresses($field_value, true);

    if (is_a($address, 'PEAR_Error') &&
        $conf['compose']['add_maildomain_to_unexpandable']) {
        $addrString = preg_replace('/,\s+/', ',', $field_value);
        $addrString = preg_replace('/\s+/', '.', $addrString);
        $address = MIME::encodeAddress($addrString, null, $_SESSION['imp']['maildomain']);
    }
}

require IMP_TEMPLATES . '/compose/expand.inc';
