<?php
/**
 * Implementation of the Quota API for IMAP servers with a unix quota command.
 * This requires a modified "quota" command that allows the httpd server
 * account to get quotas for other users. It also requires that your
 * web server and imap server be the same server or at least have shared
 * authentication and file servers (e.g. via NIS/NFS).  And last, it (as
 * written) requires the POSIX PHP extensions.
 *
 * You must configure this in horde/imp/config/servers.php.  You must
 * pass the path to your quota and grep commands as parameters.  An example
 * config would be something like:
 *
 * 'quota' => array(
 *     'driver' => 'command',
 *     'params' => array(
 *         'quota_path' => '/usr/bin/quota',
 *         'grep_path'  => '/bin/grep'
 *     )
 * )
 *
 * $Horde: imp/lib/Quota/command.php,v 1.7 2003/01/07 23:36:32 ericr Exp $
 *
 * Copyright 2002-2003 Eric Jon Rostetter <eric.rostetter@physics.utexas.edu>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * @author  Eric Rostetter <eric.rostetter@physics.utexas.edu>
 * @version $Revision: 1.7 $
 * @since   IMP 4.0
 * @package imp.quota
 */
class IMP_Quota_command extends IMP_Quota {
    
    /**
     * Constructor 
     *
     * @access public
     *
     * @param optional array $params  Hash containing connection parameters.
     */
    function IMP_Quota_command($params = array())
    {
        $this->_params = array(
            'quota_path' => 'quota',
            'grep_path'  => 'grep'
        );

        $this->_params = array_merge($this->_params, $params);
    }

    /**
     * Get quota HTML to push to user.
     *
     * @access public
     *
     * @return string  The HTML representation of the quota data.
     */
    function quotaHTML()
    {
        global $imp;

        $imap_user = strtolower($imp['user']);
        $passwd_array = posix_getpwnam($imap_user);
        $homedir = split('/', $passwd_array['dir']);
        $cmdline = $this->_params['quota_path'] . " -u $imap_user | " . 
                   $this->_params['grep_path'] . " $homedir[1]";
        $junk = exec($cmdline, $quota_data, $return_code);
        if (($return_code == 0) && (count($quota_data) == 1)) {
           $quota = split("[[:blank:]]+", trim($quota_data[0]));
           return $this->_quotaHTML($quota[1] * 1024, $quota[2] * 1024);
        }
        return $this->_quotaError(_("Unable to retrieve quota"));
    }

}
