<?php
/**
 * The Auth_http class transparently logs users in to Horde using
 * already present HTTP authentication headers.
 *
 * $Horde: horde/lib/Auth/http.php,v 1.4 2003/01/03 02:33:18 jan Exp $
 *
 * Copyright 1999-2003 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @version $Revision: 1.4 $
 * @since   Horde 3.0
 * @package horde.auth
 */
class Auth_http extends Auth {

    /**
     * An array of capabilities, so that the driver can report which
     * operations it supports and which it doesn't.
     *
     * @var array $capabilities
     */
    var $capabilities = array('add'         => false,
                              'update'      => false,
                              'remove'      => false,
                              'list'        => false,
                              'transparent' => true,
                              'loginscreen' => false);

    /**
     * Constructs a new HTTP authentication object.
     *
     * @access public
     *
     * @param optional array $params  A hash containing parameters.
     */
    function Auth_http($params = array())
    {
        $this->_params = $params;
    }

    /**
     * Automatic authentication: Find out if the client has HTTP
     * authentication info present.
     *
     * @access public
     *
     * @return boolean  Whether or not the client is allowed.
     */
    function transparent()
    {
        if (!empty($_SERVER['PHP_AUTH_USER']) &&
            !empty($_SERVER['PHP_AUTH_PW'])) {
            Auth::setAuth($_SERVER['PHP_AUTH_USER'],
                          array('password' => $_SERVER['PHP_AUTH_PW'],
                                'transparent' => 1));
            return true;
        }

        $this->_setAuthError(_("HTTP Authentication not found."));
        return false;
    }

}
