<?php
/**
 * The Notification_Listener:: class provides functionality for displaying
 * messages from the message stack as a status line.
 *
 * $Horde: horde/lib/Notification/Listener.php,v 1.6 2003/01/16 18:36:25 chuck Exp $
 *
 * Copyright 2001-2003 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @version $Revision: 1.6 $
 * @since   Horde 2.1
 * @package horde.notification
 */
class Notification_Listener {

    /**
     * Array of message types that this listener handles.
     *
     * @var array $_handles
     */
    var $_handles = array();

    /**
     * Constructor
     *
     * @access public
     */
    function Notification_Listener()
    {
    }

    /**
     * Does this listener handle a certain type of message?
     *
     * @access public
     *
     * @param string $type  The message type in question.
     *
     * @return boolean  Whether this listener handles the type.
     */
    function handles($type)
    {
        return array_key_exists($type, $this->_handles);
    }

    /**
     * Return a unique identifier for this listener.
     *
     * @access public
     *
     * @return string  Unique id.
     */
    function getName()
    {
        return get_class($this);
    }

    /**
     * Outputs the status line, sends emails, pages, etc., if there
     * are any messages on this listener's message stack.
     *
     * @access public
     *
     * @param array &$messageStack     The stack of messages.
     * @param optional array $options  An array of options.
     *                                 Options: 'nospace'
     */
    function notify(&$messageStacks, $options)
    {
    }

    /**
     * Processes one message from the message stack.
     *
     * @access public
     *
     * @param array $message  One message hash from the stack.
     */
    function getMessage($message)
    {
    }

    /**
     * Unserialize an event from the message stack, checking to see if
     * the appropriate class exists and kludging it into a base
     * Notification_Event object if not.
     */
    function getEvent($message)
    {
        $ob = false;
        if (class_exists($message['class'])) {
            $ob = @unserialize($message['event']);
        } else {
            require_once dirname(__FILE__) . '/Event.php';
            $ob = @unserialize($message['event']);
            if (!is_a($ob, 'Notification_Event')) {
                if (isset($ob->_message)) {
                    $ob = &new Notification_Event($ob->_message);
                }
            }
        }

        // If we've failed to create a valid Notification_Event object
        // (or subclass object) so far, return a PEAR_Error.
        if (!$ob) {
            $ob = PEAR::raiseError('Unable to decode message event: ' . $message['event']);
        }

        return $ob;
    }

}
