<?php
/**
 * $Horde: mnemo/prefs.php,v 1.14 2003/05/23 13:21:28 chuck Exp $
 *
 * Copyright 2002-2003 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

function handle_notepadselect($updated)
{
    global $prefs;

    $default_notepad = Horde::getFormData('default_notepad');
    if (!is_null($default_notepad)) {
        $notepads = Mnemo::listNotepads();
        if (is_array($notepads) && array_key_exists($default_notepad, $notepads)) {
            $prefs->setValue('default_notepad', $default_notepad);
            $updated = true;
        }
    }
    return $updated;
}
 
function handle_category_management($updated)
{
    global $prefs;

    $actionID = Horde::getFormData('managementActionID');
    $categoryID = Horde::getFormData('category_id');
    $categoryName = Horde::getFormData('category_name');
    $newcolors = Horde::getFormData('newColors');

    /* Always save colors. */
    $memo_colors = '';
    foreach ($newcolors as $key => $color) {
        $memo_colors .= (empty($memo_colors)) ? "$key:$color" : "|$key:$color";
    }
    $prefs->setValue('memo_colors', $memo_colors);

    switch ($actionID) {
        case MNEMO_DELETE_CATEGORY:
            Mnemo::deleteCategory($categoryID);
            break;

        case MNEMO_RENAME_CATEGORY:
            Mnemo::renameCategory($categoryID, $categoryName);
            break;
            
        case MNEMO_ADD_CATEGORY:
            Mnemo::addCategory($categoryName);
            break;
            
        default:
            /* Must have been the Save button. */
            $update = true;
            return true;
    }

    /* Return false so it stays on this page. */
    return false;
}

function prefs_callback()
{
    global $prefs, $js_onLoad;

    if ($prefs->isDirty('theme') || $prefs->isDirty('language')) {
        $js_onLoad = 'if (window.parent.frames.horde_menu) window.parent.frames.horde_menu.location.reload();';
    }
}

function handle_showsummaryselect($updated)
{
    global $prefs;

    $summary_categories = Horde::getFormData('summary_categories');
    $prefs->setValue('summary_categories', $summary_categories);
    return true;
}

define('MNEMO_BASE', dirname(__FILE__));
require_once MNEMO_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/PrefsUI.php';
require MNEMO_BASE . '/config/prefs.php';

/* See if we have a preferences group set. */
$group = Horde::getFormData('group');

if (PrefsUI::handleForm($group)) {
    $group = null;
    include MNEMO_BASE . '/config/prefs.php';
}

$title = _("User Options");
require MNEMO_TEMPLATES . '/common-header.inc';
Mnemo::menu();
$default_note_category_options = Mnemo::listCategories();
PrefsUI::generateUI($group);
require MNEMO_TEMPLATES . '/common-footer.inc';
