<?php
/**
 * $Horde: nag/lib/Block/summary.php,v 1.10 2003/07/01 21:32:09 chuck Exp $
 *
 * @package horde.block
 */
class nag_summary_Block extends Horde_Block {

    function nag_summary_Block($params = array()) 
    {
        $this->_params = $params;
        $this->_app = 'nag';
        $this->_type = 'summary';
    }

    function isEditable() 
    {
        return false;
    }

    function _title() 
    {
        global $registry;
        $html  = Horde::link(Horde::applicationUrl($registry->getInitialPage(), true), $registry->getParam('name'), 'header') . $registry->getParam('name') . '</a> - ';
        $html .= Horde::link(Horde::applicationUrl('task.php?actionID=' . NAG_ADD_TASK, true), _("New Task"), 'smallheader') . Horde::img('nag.gif', _("New Task"), 'hspace="5"', Horde::url($registry->getParam('graphics'), true, -1)) . _("New Task") . '</a>';

        return $html;
    }
    
    function _content() 
    {
        global $registry, $prefs;
        require_once dirname(__FILE__) . '/../base.php';

        $summaryCategories = explode(';', $prefs->getValue('summary_categories'));
        if ($summaryCategories != array('')) {
            $categories = array();
            foreach ($summaryCategories as $summaryColumn) {
                list($categories[],) = explode(',', $summaryColumn);
            }
        }

        $html = '';
        $i = 0;
        $tasks = Nag::listTasks($prefs->getValue('sortby'), $prefs->getValue('sortdir'));
        foreach ($tasks as $id => $task) {
            if (isset($categories) && !in_array($task['category'], $categories)) {
                continue;
            }

            $due_begin = $due_end = '';
            $closed_begin = $closed_end = '';
            $owner = '';
            $html .= '<tr class="item' . ($i++ % 2) . '">';

            if ($prefs->getValue('summary_show_actions')) {
                $taskurl = Horde::addParameter('task.php', 'task', $task['task_id']);
                $taskurl = Horde::addParameter($taskurl, 'tasklist', $task['tasklist_id']);
                $taskurl = Horde::addParameter($taskurl, 'url', Horde::selfURL(true));
                $html .= '<td>' . Horde::link(Horde::applicationUrl(Horde::addParameter($taskurl, 'actionID', NAG_MODIFY_TASK)), _("Edit Task"), 'widget') . Horde::img('edit.gif', _("Edit Task")) . '</a></td>';
                if ($task['completed']) {
                    $html .= '<td>' . Horde::img('checked.gif', _("Completed")) . '</td>';
                } else {
                    $html .= '<td>' . Horde::link(Horde::applicationUrl(Horde::addParameter($taskurl, 'actionID', NAG_COMPLETE_TASKS)), _("Complete Task"), 'widget') . Horde::img('unchecked.gif', _("Complete Task")) . '</a></td>';
                }
            }

            if ($prefs->getValue('summary_show_priorities')) {
                $html .= '<td width="20" align="center">' . Nag::formatPriority($task['priority']) . '</td>';
            }

            $html .= '<td>';
            $viewurl = Horde::addParameter('view.php', 'task', $task['task_id']);
            $viewurl = Horde::addParameter($viewurl, 'tasklist', $task['tasklist_id']);
            $row = Horde::link(Horde::applicationUrl($viewurl, true), $task['name']);

            if ($prefs->getValue('summary_show_owner')) {
                $owner = $task['tasklist_id'];
                $shares = &Horde_Share::singleton($registry->getApp());
                $share = $shares->getShare($owner);
                if (is_a($share, 'PEAR_Error') || $owner == $share->getOwner()) {
                    $owner .= ' - ';
                } else {
                    $owner = $share->getShareName() . ' - ';
                }
            }

            $row .= (!empty($task['name']) ? htmlspecialchars($task['name']) : _("[none]")) . '</a>';

            if (!empty($task['completed'])) {
                $closed_begin = '<strike>';
                $closed_end = '</strike>';
            }
            if (!empty($task['due']) && $task['due'] < time() && empty($task['completed'])) {
                $due_begin = '<b><font color="red">';
                $due_end = '</font></b>';
            }
            if (!empty($task['due']) && empty($task['completed']) && $prefs->getValue('summary_show_due')) {
                $due_begin .= '(' .  strftime($prefs->getValue('summary_due_format'), $task['due']) . ') ';
            }
            $html .= $closed_begin . $owner . $due_begin . $row . $due_end . $closed_end;
            $html .= "</td></tr>\n";
        }
    
        if (empty($html)) {
            $html = sprintf('<tr><td><i>%s</i></td></tr>', _("No tasks to display"));
        }    
        $html = '<table border="0" cellpadding="0" cellspacing="0" width="100%">' . $html . '</table>';

        return $html;
    }

}
