<?php
/**
 * $Horde: turba/editobject.php,v 1.39 2003/07/23 15:21:12 chuck Exp $
 *
 * Turba: Copyright 2000-2003 Charles J. Hagenbuch <chuck@horde.org>
 *
 * You should have received a copy of the GNU Public
 * License along with this package; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

define('TURBA_BASE', dirname(__FILE__));
require_once TURBA_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Form.php';
require_once TURBA_BASE . '/lib/Renderer.php';
require_once TURBA_BASE . '/lib/Source.php';
require_once TURBA_BASE . '/lib/ObjectView.php';
require_once TURBA_BASE . '/lib/ObjectForm.php';

$renderer = &new Turba_Renderer();
$vars = &Horde_Form::getDefaultVars();

$url = $vars->getVar('url');
$source = $vars->getVar('source');
if ($source === null || !isset($cfgSources[$source])) {
    $notification->push(_("The object you requested does not exist."));
    header('Location: ' . Horde::applicationUrl($prefs->getValue('initial_page'), true));
    exit;
}

$driver = &Turba_Source::singleton($source, $cfgSources[$source]);

/* Set the object from the key requested */
$key = $vars->getVar('key');
$object = $driver->getObject($key);
if (is_a($object, 'PEAR_Error')) {
    $notification->push($object->getMessage(), 'horde.error');
    header('Location: ' . Horde::applicationUrl($prefs->getValue('initial_page'), true));
    exit;
}

/* Check permissions on this object */
$editdone = false;
if (!Turba::checkPermissions($object, 'object', _PERMS_EDIT)) {
    if (!Turba::checkPermissions($object, 'object', _PERMS_READ)) {
        $notification->push(_("You do not have permission to view this object."), 'horde.error');
        header('Location: ' . Horde::applicationUrl($prefs->getValue('initial_page'), true));
        exit;
    } else {
        $notification->push(_("You only have permission to view this object."), 'horde.error');
        $editdone = true;
    }
}

$title = sprintf(_("Edit entry for %s"), $object->getValue('name'));

/* Get the form object */
$formobject = &Horde_Form::singleton('ObjectForm', $vars, $title);

$renderer->setObject($object);
$view = &new Turba_ObjectView($object);
$view->setFormVariables($formobject);

if (!$vars->isVarSet('submitbutton') || $editdone) {
    $vars = array();
    foreach ($object->attributes as $info_key => $info_val) {
        $vars[$info_key] = $object->getValue($info_key);
    }
    $vars = &new Horde_Form_Vars(array('object' => $vars));
    $vars->setVar('url', $url);
    $vars->setVar('source', $source);
    $vars->setVar('key', $key);
} else {
    /* Validate the form. */
    $formobject->validate($vars);

    if ($formobject->isValid()) {
        /* Form valid, save data. */
        $formobject->getInfo($vars, $info);

        /* Update Object. */
        foreach ($info['object'] as $info_key => $info_val) {
            if ($info_key != '__key') {
                $object->setValue($info_key, $info_val);
            }
        }
        $success = $object->store();
        if (!is_a($success, 'PEAR_Error')) {
            $notification->push(sprintf(_("Entry for %s updated."), $object->getValue('name')), 'horde.success');
            $formobject->setTitle(sprintf(_("Edit entry for %s"), $object->getValue('name')));
            $editdone = true;
        } else {
            Horde::logMessage($key, __FILE__, __LINE__, PEAR_LOG_ERR);
            $notification->push(sprintf(_("There was an error updating this entry: %s."), $success->getMessage()), 'horde.error');
        }
    }
}

if ($editdone) {
    if (empty($info['url'])) {
        $uri = Horde::applicationUrl('displayobject.php', true);
        $uri = Horde::addParameter($uri, 'source', $info['source']);
        $uri = Horde::addParameter($uri, 'key', $info['key']);
    } else {
        $uri = $info['url'];
    }

    header('Location: ' . $uri);
    exit;
}

$js_onLoad = 'var i = 0; while (document.forms[0].elements[i].type == \'hidden\') i++; document.forms[0].elements[i].focus();';
require TURBA_TEMPLATES . '/common-header.inc';
Turba::menu();
$formobject->renderActive($renderer, $vars, 'editobject.php', 'post');
require TURBA_TEMPLATES . '/common-footer.inc';
