#ifndef _AL_SOURCE_H_
#define _AL_SOURCE_H_

#define AL_NUM_SOURCE_PARAMS	128

#define ALAPI __declspec(dllexport)
#define ALAPIENTRY __cdecl

#include <al\altypes.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct ALsource_struct
{
	struct 
	{
		union 
		{
			ALfloat fv3[3];
			ALfloat fv6[6];
			ALint   i;
			ALfloat f;
		} data;
		ALboolean valid;
	} param[AL_NUM_SOURCE_PARAMS];
	ALboolean	inuse;
	ALboolean	valid;
	ALboolean	play;
	ALboolean	relative;
	ALenum		state;
	ALuint		current_buffer;
	ALuint		position;
	ALuint		position_fraction;
	ALuint	    *queue;
	ALvoid		*uservalue1;
	ALvoid		*uservalue2;
	struct ALsource_struct *previous;
	struct ALsource_struct *next;
} ALsource;

ALAPI ALvoid	ALAPIENTRY alGenSources(ALsizei n,ALuint *sources);
ALAPI ALvoid	ALAPIENTRY alDeleteSources(ALsizei n,ALuint *sources);
ALAPI ALboolean	ALAPIENTRY alIsSource(ALuint source);
ALAPI ALvoid	ALAPIENTRY alSourcef(ALuint source,ALenum pname,ALfloat value);
ALAPI ALvoid	ALAPIENTRY alSourcefv(ALuint source,ALenum pname,ALfloat *values);
ALAPI ALvoid	ALAPIENTRY alSource3f(ALuint source,ALenum pname,ALfloat v1,ALfloat v2,ALfloat v3);
ALAPI ALvoid	ALAPIENTRY alSourcei(ALuint source,ALenum pname,ALint value);
ALAPI ALvoid	ALAPIENTRY alGetSourcef(ALuint source,ALenum pname,ALfloat *value);
ALAPI ALvoid	ALAPIENTRY alGetSourcefv(ALuint source,ALenum pname,ALfloat *values);
ALAPI ALvoid	ALAPIENTRY alGetSourcei(ALuint source,ALenum pname,ALint *value);
ALAPI ALvoid	ALAPIENTRY alSourcePlay(ALuint source);
ALAPI ALvoid	ALAPIENTRY alSourcePlayv(ALsizei n,ALuint *sources); 
ALAPI ALvoid	ALAPIENTRY alSourcePause(ALuint source);
ALAPI ALvoid	ALAPIENTRY alSourcePausev(ALsizei n,ALuint *sources);
ALAPI ALvoid	ALAPIENTRY alSourceStop(ALuint source);
ALAPI ALvoid	ALAPIENTRY alSourceStopv(ALsizei n,ALuint *sources);
ALAPI ALvoid	ALAPIENTRY alSourceRewind(ALuint source);
ALAPI ALvoid	ALAPIENTRY alSourceRewindv(ALsizei n,ALuint *sources);

#ifdef __cplusplus
}
#endif

#endif