﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/proton/Proton_EXPORTS.h>
#include <aws/proton/model/DeploymentStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Proton {
namespace Model {

/**
 * <p>Detailed data of an Proton service instance pipeline resource.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ServicePipeline">AWS
 * API Reference</a></p>
 */
class ServicePipeline {
 public:
  AWS_PROTON_API ServicePipeline() = default;
  AWS_PROTON_API ServicePipeline(Aws::Utils::Json::JsonView jsonValue);
  AWS_PROTON_API ServicePipeline& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PROTON_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the service pipeline.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  ServicePipeline& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time when the service pipeline was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedAt() const { return m_createdAt; }
  inline bool CreatedAtHasBeenSet() const { return m_createdAtHasBeenSet; }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  void SetCreatedAt(CreatedAtT&& value) {
    m_createdAtHasBeenSet = true;
    m_createdAt = std::forward<CreatedAtT>(value);
  }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  ServicePipeline& WithCreatedAt(CreatedAtT&& value) {
    SetCreatedAt(std::forward<CreatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The deployment status of the service pipeline.</p>
   */
  inline DeploymentStatus GetDeploymentStatus() const { return m_deploymentStatus; }
  inline bool DeploymentStatusHasBeenSet() const { return m_deploymentStatusHasBeenSet; }
  inline void SetDeploymentStatus(DeploymentStatus value) {
    m_deploymentStatusHasBeenSet = true;
    m_deploymentStatus = value;
  }
  inline ServicePipeline& WithDeploymentStatus(DeploymentStatus value) {
    SetDeploymentStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A service pipeline deployment status message.</p>
   */
  inline const Aws::String& GetDeploymentStatusMessage() const { return m_deploymentStatusMessage; }
  inline bool DeploymentStatusMessageHasBeenSet() const { return m_deploymentStatusMessageHasBeenSet; }
  template <typename DeploymentStatusMessageT = Aws::String>
  void SetDeploymentStatusMessage(DeploymentStatusMessageT&& value) {
    m_deploymentStatusMessageHasBeenSet = true;
    m_deploymentStatusMessage = std::forward<DeploymentStatusMessageT>(value);
  }
  template <typename DeploymentStatusMessageT = Aws::String>
  ServicePipeline& WithDeploymentStatusMessage(DeploymentStatusMessageT&& value) {
    SetDeploymentStatusMessage(std::forward<DeploymentStatusMessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the last attempted deployment of this service pipeline.</p>
   */
  inline const Aws::String& GetLastAttemptedDeploymentId() const { return m_lastAttemptedDeploymentId; }
  inline bool LastAttemptedDeploymentIdHasBeenSet() const { return m_lastAttemptedDeploymentIdHasBeenSet; }
  template <typename LastAttemptedDeploymentIdT = Aws::String>
  void SetLastAttemptedDeploymentId(LastAttemptedDeploymentIdT&& value) {
    m_lastAttemptedDeploymentIdHasBeenSet = true;
    m_lastAttemptedDeploymentId = std::forward<LastAttemptedDeploymentIdT>(value);
  }
  template <typename LastAttemptedDeploymentIdT = Aws::String>
  ServicePipeline& WithLastAttemptedDeploymentId(LastAttemptedDeploymentIdT&& value) {
    SetLastAttemptedDeploymentId(std::forward<LastAttemptedDeploymentIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time when a deployment of the service pipeline was last attempted.</p>
   */
  inline const Aws::Utils::DateTime& GetLastDeploymentAttemptedAt() const { return m_lastDeploymentAttemptedAt; }
  inline bool LastDeploymentAttemptedAtHasBeenSet() const { return m_lastDeploymentAttemptedAtHasBeenSet; }
  template <typename LastDeploymentAttemptedAtT = Aws::Utils::DateTime>
  void SetLastDeploymentAttemptedAt(LastDeploymentAttemptedAtT&& value) {
    m_lastDeploymentAttemptedAtHasBeenSet = true;
    m_lastDeploymentAttemptedAt = std::forward<LastDeploymentAttemptedAtT>(value);
  }
  template <typename LastDeploymentAttemptedAtT = Aws::Utils::DateTime>
  ServicePipeline& WithLastDeploymentAttemptedAt(LastDeploymentAttemptedAtT&& value) {
    SetLastDeploymentAttemptedAt(std::forward<LastDeploymentAttemptedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time when the service pipeline was last deployed successfully.</p>
   */
  inline const Aws::Utils::DateTime& GetLastDeploymentSucceededAt() const { return m_lastDeploymentSucceededAt; }
  inline bool LastDeploymentSucceededAtHasBeenSet() const { return m_lastDeploymentSucceededAtHasBeenSet; }
  template <typename LastDeploymentSucceededAtT = Aws::Utils::DateTime>
  void SetLastDeploymentSucceededAt(LastDeploymentSucceededAtT&& value) {
    m_lastDeploymentSucceededAtHasBeenSet = true;
    m_lastDeploymentSucceededAt = std::forward<LastDeploymentSucceededAtT>(value);
  }
  template <typename LastDeploymentSucceededAtT = Aws::Utils::DateTime>
  ServicePipeline& WithLastDeploymentSucceededAt(LastDeploymentSucceededAtT&& value) {
    SetLastDeploymentSucceededAt(std::forward<LastDeploymentSucceededAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the last successful deployment of this service pipeline.</p>
   */
  inline const Aws::String& GetLastSucceededDeploymentId() const { return m_lastSucceededDeploymentId; }
  inline bool LastSucceededDeploymentIdHasBeenSet() const { return m_lastSucceededDeploymentIdHasBeenSet; }
  template <typename LastSucceededDeploymentIdT = Aws::String>
  void SetLastSucceededDeploymentId(LastSucceededDeploymentIdT&& value) {
    m_lastSucceededDeploymentIdHasBeenSet = true;
    m_lastSucceededDeploymentId = std::forward<LastSucceededDeploymentIdT>(value);
  }
  template <typename LastSucceededDeploymentIdT = Aws::String>
  ServicePipeline& WithLastSucceededDeploymentId(LastSucceededDeploymentIdT&& value) {
    SetLastSucceededDeploymentId(std::forward<LastSucceededDeploymentIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The service spec that was used to create the service pipeline.</p>
   */
  inline const Aws::String& GetSpec() const { return m_spec; }
  inline bool SpecHasBeenSet() const { return m_specHasBeenSet; }
  template <typename SpecT = Aws::String>
  void SetSpec(SpecT&& value) {
    m_specHasBeenSet = true;
    m_spec = std::forward<SpecT>(value);
  }
  template <typename SpecT = Aws::String>
  ServicePipeline& WithSpec(SpecT&& value) {
    SetSpec(std::forward<SpecT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The major version of the service template that was used to create the service
   * pipeline.</p>
   */
  inline const Aws::String& GetTemplateMajorVersion() const { return m_templateMajorVersion; }
  inline bool TemplateMajorVersionHasBeenSet() const { return m_templateMajorVersionHasBeenSet; }
  template <typename TemplateMajorVersionT = Aws::String>
  void SetTemplateMajorVersion(TemplateMajorVersionT&& value) {
    m_templateMajorVersionHasBeenSet = true;
    m_templateMajorVersion = std::forward<TemplateMajorVersionT>(value);
  }
  template <typename TemplateMajorVersionT = Aws::String>
  ServicePipeline& WithTemplateMajorVersion(TemplateMajorVersionT&& value) {
    SetTemplateMajorVersion(std::forward<TemplateMajorVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The minor version of the service template that was used to create the service
   * pipeline.</p>
   */
  inline const Aws::String& GetTemplateMinorVersion() const { return m_templateMinorVersion; }
  inline bool TemplateMinorVersionHasBeenSet() const { return m_templateMinorVersionHasBeenSet; }
  template <typename TemplateMinorVersionT = Aws::String>
  void SetTemplateMinorVersion(TemplateMinorVersionT&& value) {
    m_templateMinorVersionHasBeenSet = true;
    m_templateMinorVersion = std::forward<TemplateMinorVersionT>(value);
  }
  template <typename TemplateMinorVersionT = Aws::String>
  ServicePipeline& WithTemplateMinorVersion(TemplateMinorVersionT&& value) {
    SetTemplateMinorVersion(std::forward<TemplateMinorVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the service template that was used to create the service
   * pipeline.</p>
   */
  inline const Aws::String& GetTemplateName() const { return m_templateName; }
  inline bool TemplateNameHasBeenSet() const { return m_templateNameHasBeenSet; }
  template <typename TemplateNameT = Aws::String>
  void SetTemplateName(TemplateNameT&& value) {
    m_templateNameHasBeenSet = true;
    m_templateName = std::forward<TemplateNameT>(value);
  }
  template <typename TemplateNameT = Aws::String>
  ServicePipeline& WithTemplateName(TemplateNameT&& value) {
    SetTemplateName(std::forward<TemplateNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;

  Aws::Utils::DateTime m_createdAt{};

  DeploymentStatus m_deploymentStatus{DeploymentStatus::NOT_SET};

  Aws::String m_deploymentStatusMessage;

  Aws::String m_lastAttemptedDeploymentId;

  Aws::Utils::DateTime m_lastDeploymentAttemptedAt{};

  Aws::Utils::DateTime m_lastDeploymentSucceededAt{};

  Aws::String m_lastSucceededDeploymentId;

  Aws::String m_spec;

  Aws::String m_templateMajorVersion;

  Aws::String m_templateMinorVersion;

  Aws::String m_templateName;
  bool m_arnHasBeenSet = false;
  bool m_createdAtHasBeenSet = false;
  bool m_deploymentStatusHasBeenSet = false;
  bool m_deploymentStatusMessageHasBeenSet = false;
  bool m_lastAttemptedDeploymentIdHasBeenSet = false;
  bool m_lastDeploymentAttemptedAtHasBeenSet = false;
  bool m_lastDeploymentSucceededAtHasBeenSet = false;
  bool m_lastSucceededDeploymentIdHasBeenSet = false;
  bool m_specHasBeenSet = false;
  bool m_templateMajorVersionHasBeenSet = false;
  bool m_templateMinorVersionHasBeenSet = false;
  bool m_templateNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace Proton
}  // namespace Aws
