/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.AttributeComponent;
import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;

abstract class AttributePanel
extends JPanel
implements AttributeComponent,
ContainerListener {
    private final Vector components = new Vector();

    public AttributePanel() {
        this.addContainerListener(this);
    }

    @Override
    public boolean setValue(AttributeSet a) {
        boolean result = true;
        Enumeration elements = this.components.elements();
        while (elements.hasMoreElements()) {
            AttributeComponent ac = (AttributeComponent)elements.nextElement();
            if (ac.setValue(a)) continue;
            result = false;
        }
        return result;
    }

    @Override
    public AttributeSet getValue() {
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        Enumeration elements = this.components.elements();
        while (elements.hasMoreElements()) {
            AttributeComponent ac = (AttributeComponent)elements.nextElement();
            attributes.addAttributes(ac.getValue());
        }
        return attributes;
    }

    @Override
    public AttributeSet getValue(boolean includeUnchanged) {
        if (includeUnchanged) {
            SimpleAttributeSet attributes = new SimpleAttributeSet();
            Enumeration elements = this.components.elements();
            while (elements.hasMoreElements()) {
                AttributeComponent ac = (AttributeComponent)elements.nextElement();
                attributes.addAttributes(ac.getValue(includeUnchanged));
            }
            return attributes;
        }
        return this.getValue();
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        Component component = e.getChild();
        if (component instanceof AttributeComponent) {
            this.components.add(component);
        }
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        Component component = e.getChild();
        if (component instanceof AttributeComponent) {
            this.components.remove(component);
        }
    }
}

