/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.config;

import java.util.Set;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.config.BrokerReconfigurable;
import org.apache.kafka.coordinator.transaction.TransactionLogConfig;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicProducerStateManagerConfig
implements BrokerReconfigurable {
    private final Logger log = LoggerFactory.getLogger(DynamicProducerStateManagerConfig.class);
    private final ProducerStateManagerConfig producerStateManagerConfig;

    public DynamicProducerStateManagerConfig(ProducerStateManagerConfig producerStateManagerConfig) {
        this.producerStateManagerConfig = producerStateManagerConfig;
    }

    public Set<String> reconfigurableConfigs() {
        return Set.of("producer.id.expiration.ms", "transaction.partition.verification.enable");
    }

    public void validateReconfiguration(AbstractConfig newConfig) {
        TransactionLogConfig transactionLogConfig = new TransactionLogConfig(newConfig);
        if (transactionLogConfig.producerIdExpirationMs() < 0) {
            throw new ConfigException("producer.id.expiration.mscannot be less than 0, current value is " + this.producerStateManagerConfig.producerIdExpirationMs() + ", and new value is " + transactionLogConfig.producerIdExpirationMs());
        }
    }

    public void reconfigure(AbstractConfig oldConfig, AbstractConfig newConfig) {
        TransactionLogConfig transactionLogConfig = new TransactionLogConfig(newConfig);
        if (this.producerStateManagerConfig.producerIdExpirationMs() != transactionLogConfig.producerIdExpirationMs()) {
            this.log.info("Reconfigure {} from {} to {}", new Object[]{"producer.id.expiration.ms", this.producerStateManagerConfig.producerIdExpirationMs(), transactionLogConfig.producerIdExpirationMs()});
            this.producerStateManagerConfig.setProducerIdExpirationMs(transactionLogConfig.producerIdExpirationMs());
        }
        if (this.producerStateManagerConfig.transactionVerificationEnabled() != transactionLogConfig.transactionPartitionVerificationEnable()) {
            this.log.info("Reconfigure {} from {} to {}", new Object[]{"transaction.partition.verification.enable", this.producerStateManagerConfig.transactionVerificationEnabled(), transactionLogConfig.transactionPartitionVerificationEnable()});
            this.producerStateManagerConfig.setTransactionVerificationEnabled(transactionLogConfig.transactionPartitionVerificationEnable());
        }
    }
}

