/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.spi;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.models.internal.BasicModelsContextImpl;
import org.hibernate.models.internal.ModelsLogging;
import org.hibernate.models.internal.SimpleClassLoading;
import org.hibernate.models.spi.ClassLoading;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.ModelsContextProvider;
import org.hibernate.models.spi.RegistryPrimer;

public class ModelsConfiguration {
    private final Map<Object, Object> configValues = new HashMap<Object, Object>();
    private ClassLoading classLoading = SimpleClassLoading.SIMPLE_CLASS_LOADING;
    private RegistryPrimer registryPrimer;
    private ModelsContextProvider explicitContextProvider;

    public Map<Object, Object> getConfigValues() {
        return this.configValues;
    }

    public ModelsConfiguration configValue(Object key, Object value) {
        this.setConfigValue(key, value);
        return this;
    }

    public Object setConfigValue(Object key, Object value) {
        return this.configValues.put(key, value);
    }

    public ClassLoading getClassLoading() {
        return this.classLoading;
    }

    public ModelsConfiguration setClassLoading(ClassLoading classLoading) {
        this.classLoading = classLoading;
        return this;
    }

    public RegistryPrimer getRegistryPrimer() {
        return this.registryPrimer;
    }

    public ModelsConfiguration setRegistryPrimer(RegistryPrimer registryPrimer) {
        this.registryPrimer = registryPrimer;
        return this;
    }

    public ModelsContextProvider getExplicitContextProvider() {
        return this.explicitContextProvider;
    }

    public ModelsConfiguration setExplicitContextProvider(ModelsContextProvider explicitContextProvider) {
        this.explicitContextProvider = explicitContextProvider;
        return this;
    }

    public ModelsContext bootstrap() {
        Collection<ModelsContextProvider> discoveredProviders;
        if (this.explicitContextProvider != null) {
            ModelsContext context = this.explicitContextProvider.produceContext(this.classLoading, this.registryPrimer, this.configValues);
            if (context != null) {
                return context;
            }
            ModelsLogging.MODELS_LOGGER.debugf("Explicit ModelsContext returned null", new Object[0]);
        }
        if ((discoveredProviders = this.classLoading.loadJavaServices(ModelsContextProvider.class)).size() > 1) {
            ModelsLogging.MODELS_LOGGER.debugf("Multiple ModelsContextProvider implementations found", new Object[0]);
        }
        for (ModelsContextProvider provider : discoveredProviders) {
            ModelsContext context = provider.produceContext(this.classLoading, this.registryPrimer, this.configValues);
            if (context == null) continue;
            return context;
        }
        return new BasicModelsContextImpl(this.classLoading, this.shouldTrackImplementors(), this.registryPrimer);
    }

    private boolean shouldTrackImplementors() {
        return ModelsConfiguration.shouldTrackImplementors(this.configValues);
    }

    public static boolean shouldTrackImplementors(Map<Object, Object> configValues) {
        Object value = configValues.get("hibernate.models.trackImplementors");
        if (value != null) {
            boolean bl;
            if (value instanceof Boolean) {
                Boolean bool = (Boolean)value;
                bl = bool;
            } else {
                bl = Boolean.parseBoolean(value.toString());
            }
            return bl;
        }
        return false;
    }
}

