/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.DecoderException;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.operations.NeutralVersionHotRodOperation;
import org.infinispan.client.hotrod.impl.operations.PingResponse;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelOperation;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

@Immutable
public class PingOperation
extends NeutralVersionHotRodOperation<PingResponse>
implements ChannelOperation {
    private static final Log log = LogFactory.getLog(PingOperation.class);
    private final boolean releaseChannel;
    private final PingResponse.Decoder responseBuilder;

    public PingOperation(Codec codec, AtomicReference<ClientTopology> clientTopology, Configuration cfg, byte[] cacheName, ChannelFactory channelFactory, boolean releaseChannel) {
        this(23, 24, codec, clientTopology, cfg, cacheName, channelFactory, releaseChannel);
    }

    protected PingOperation(short requestCode, short responseCode, Codec codec, AtomicReference<ClientTopology> clientTopology, Configuration cfg, byte[] cacheName, ChannelFactory channelFactory, boolean releaseChannel) {
        super(requestCode, responseCode, codec, 0, cfg, cacheName, clientTopology, channelFactory);
        this.releaseChannel = releaseChannel;
        this.responseBuilder = new PingResponse.Decoder(cfg.version());
    }

    @Override
    public void invoke(Channel channel) {
        this.sendHeaderAndRead(channel);
        if (this.releaseChannel) {
            this.releaseChannel(channel);
        }
    }

    @Override
    public void cancel(SocketAddress address, Throwable cause) {
        this.completeExceptionally(cause);
    }

    @Override
    public CompletableFuture<PingResponse> execute() {
        throw new UnsupportedOperationException("Cannot execute directly");
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        PingResponse pingResponse;
        this.responseBuilder.processResponse(this.codec, buf, decoder);
        if (HotRodConstants.isSuccess(status)) {
            pingResponse = this.responseBuilder.build(status);
            if (pingResponse.getVersion() != null && this.cfg.version() == ProtocolVersion.PROTOCOL_VERSION_AUTO) {
                this.channelFactory.setNegotiatedCodec(pingResponse.getVersion().getCodec());
            }
        } else {
            String hexStatus = Integer.toHexString(status);
            if (log.isTraceEnabled()) {
                log.tracef("Unknown response status: %s", hexStatus);
            }
            throw new InvalidResponseException("Unexpected response status: " + hexStatus);
        }
        this.complete(pingResponse);
    }

    @Override
    public void exceptionCaught(Channel channel, Throwable cause) {
        while (cause instanceof DecoderException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        PingResponse pingResponse = new PingResponse(cause);
        if (pingResponse.isCacheNotFound()) {
            this.complete(pingResponse);
        } else {
            super.exceptionCaught(channel, cause);
        }
    }
}

