/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.client;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.ClientAuthenticationFlowContext;
import org.keycloak.authentication.ConfigurableAuthenticatorFactory;
import org.keycloak.authentication.authenticators.client.AbstractClientAuthenticator;
import org.keycloak.authentication.authenticators.client.ClientAssertionState;
import org.keycloak.authentication.authenticators.client.DefaultClientAssertionStrategy;
import org.keycloak.broker.provider.ClientAssertionIdentityProvider;
import org.keycloak.broker.provider.ClientAssertionIdentityProviderFactory;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.common.Profile;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.resources.IdentityBrokerService;

public class FederatedJWTClientAuthenticator
extends AbstractClientAuthenticator
implements EnvironmentDependentProviderFactory {
    private static final Logger LOGGER = Logger.getLogger(FederatedJWTClientAuthenticator.class);
    public static final String PROVIDER_ID = "federated-jwt";
    public static final String JWT_CREDENTIAL_ISSUER_KEY = "jwt.credential.issuer";
    public static final String JWT_CREDENTIAL_SUBJECT_KEY = "jwt.credential.sub";
    private static final List<ProviderConfigProperty> CLIENT_CONFIG = ProviderConfigurationBuilder.create().property().name("jwt.credential.issuer").label("Identity provider").helpText("Issuer of the client assertion. Use the alias of an identity provider set up in this realm.").type("String").required(true).add().property().name("jwt.credential.sub").label("Federated subject").helpText("External clientId (subject) as provided by the identity provider.").type("String").required(true).add().build();
    private final List<ClientAssertionIdentityProviderFactory.ClientAssertionStrategy> strategies = new LinkedList<ClientAssertionIdentityProviderFactory.ClientAssertionStrategy>();

    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public void postInit(KeycloakSessionFactory factory) {
        factory.getProviderFactoriesStream(IdentityProvider.class).filter(ClientAssertionIdentityProviderFactory.class::isInstance).map(ClientAssertionIdentityProviderFactory.class::cast).map(ClientAssertionIdentityProviderFactory::getClientAssertionStrategy).filter(Objects::nonNull).forEach(this.strategies::add);
        this.strategies.add(new DefaultClientAssertionStrategy());
    }

    public void authenticateClient(ClientAuthenticationFlowContext context) {
        try {
            context.attempted();
            ClientAssertionState clientAssertionState = (ClientAssertionState)context.getState(ClientAssertionState.class, ClientAssertionState.supplier());
            if (clientAssertionState == null || clientAssertionState.getClientAssertionType() == null) {
                return;
            }
            JsonWebToken jwt = clientAssertionState.getToken();
            if (jwt != null && Objects.equals(jwt.getIssuer(), jwt.getSubject())) {
                return;
            }
            ClientAssertionIdentityProviderFactory.ClientAssertionStrategy strategy = this.findStrategy(clientAssertionState.getClientAssertionType());
            if (strategy == null) {
                return;
            }
            ClientAssertionIdentityProviderFactory.LookupResult lookup = strategy.lookup(context);
            if (lookup == null || lookup.identityProviderModel() == null || !lookup.identityProviderModel().isEnabled() || lookup.clientModel() == null) {
                return;
            }
            ClientAssertionIdentityProvider<?> identityProvider = this.getClientAssertionIdentityProvider(context.getSession(), lookup.identityProviderModel());
            ClientModel client = lookup.clientModel();
            clientAssertionState.setClient(client);
            if (!PROVIDER_ID.equals(client.getClientAuthenticatorType())) {
                return;
            }
            if (identityProvider.verifyClientAssertion(context)) {
                context.success();
            } else {
                context.failure(AuthenticationFlowError.INVALID_CLIENT_CREDENTIALS);
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Authentication failed", (Throwable)e);
            context.failure(AuthenticationFlowError.INVALID_CLIENT_CREDENTIALS);
        }
    }

    private ClientAssertionIdentityProviderFactory.ClientAssertionStrategy findStrategy(String assertionType) {
        return this.strategies.stream().filter(c -> c.isSupportedAssertionType(assertionType)).findFirst().orElse(null);
    }

    private ClientAssertionIdentityProvider<?> getClientAssertionIdentityProvider(KeycloakSession session, IdentityProviderModel identityProviderModel) {
        if (identityProviderModel == null) {
            return null;
        }
        return IdentityBrokerService.getIdentityProvider(session, identityProviderModel, ClientAssertionIdentityProvider.class);
    }

    public String getDisplayType() {
        return "Signed JWT - Federated";
    }

    public String getHelpText() {
        return "Validates client based on signed JWT issued and signed by an external identity provider";
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return ConfigurableAuthenticatorFactory.REQUIREMENT_CHOICES;
    }

    public boolean isConfigurable() {
        return false;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return Collections.emptyList();
    }

    public List<ProviderConfigProperty> getConfigPropertiesPerClient() {
        return CLIENT_CONFIG;
    }

    public Map<String, Object> getAdapterConfiguration(ClientModel client) {
        return Collections.emptyMap();
    }

    public Set<String> getProtocolAuthenticatorMethods(String loginProtocol) {
        return Collections.emptySet();
    }

    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.CLIENT_AUTH_FEDERATED);
    }
}

