/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.Closure;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRichFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrRichPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0002'(BA\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\f\u0010\rB9\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\u000eB/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\f\u0010\u000fJ\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\bH\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u001d\u001a\u00020\b*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0018\u0010\u001d\u001a\u00020\b*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 R\u001a\u0010\"\u001a\u0004\u0018\u00010\b*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\u0004\u0018\u00010\b*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010$\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator;", "", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "closureBuilders", "", "Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "scriptingMode", "", "closestParent", "<init>", "(Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;Ljava/util/Map;ZLorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "(Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;Ljava/util/Map;Z)V", "(Lorg/jetbrains/kotlin/ir/IrElement;Ljava/util/Map;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "rootClosureBuilder", "rootClosure", "Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "getRootClosure", "()Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "getFunctionClosure", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getClassClosure", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getClosure", "includeInParent", "", "builder", "closureBuilder", "getClosureBuilder", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "collectPotentiallyCapturedTypeParameters", "parentClosureBuilder", "getParentClosureBuilder", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "closureBuilderOrNull", "getClosureBuilderOrNull", "ClosureBuilder", "ClosureCollectorVisitor", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nClosureAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClosureAnnotator.kt\norg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,371:1\n1#2:372\n383#3,3:373\n386#3,4:380\n383#3,3:384\n386#3,4:389\n296#4,2:376\n1915#4,2:378\n1915#4,2:387\n*S KotlinDebug\n*F\n+ 1 ClosureAnnotator.kt\norg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator\n*L\n195#1:373,3\n195#1:380,4\n220#1:384,3\n220#1:389,4\n211#1:376,2\n213#1:378,2\n225#1:387,2\n*E\n"})
public final class ClosureAnnotator {
    @NotNull
    private final Map<IrDeclaration, ClosureBuilder> closureBuilders;
    private final boolean scriptingMode;
    @Nullable
    private final IrDeclaration closestParent;
    @NotNull
    private final ClosureBuilder rootClosureBuilder;

    /*
     * WARNING - void declaration
     */
    private ClosureAnnotator(IrElement irElement, IrDeclaration declaration, Map<IrDeclaration, ClosureBuilder> closureBuilders, boolean scriptingMode, IrDeclaration closestParent) {
        this.closureBuilders = closureBuilders;
        this.scriptingMode = scriptingMode;
        this.closestParent = closestParent;
        ClosureAnnotator closureAnnotator = this;
        Object object = declaration;
        if (object == null || (object = this.getClosureBuilderOrNull((IrDeclaration)object)) == null) {
            IrDeclaration irDeclaration = declaration;
            object = irDeclaration != null ? this.getParentClosureBuilder(irDeclaration) : null;
            if (object == null) {
                void $this$rootClosureBuilder_u24lambda_u240;
                ClosureBuilder closureBuilder;
                ClosureBuilder closureBuilder2 = closureBuilder = new ClosureBuilder(null);
                ClosureAnnotator closureAnnotator2 = closureAnnotator;
                boolean bl = false;
                this.collectPotentiallyCapturedTypeParameters((ClosureBuilder)$this$rootClosureBuilder_u24lambda_u240);
                closureAnnotator = closureAnnotator2;
                object = closureBuilder;
            }
        }
        closureAnnotator.rootClosureBuilder = object;
        irElement.accept(new ClosureCollectorVisitor(), this.rootClosureBuilder);
    }

    public ClosureAnnotator(@NotNull IrElement irElement, @NotNull IrDeclaration declaration, @NotNull Map<IrDeclaration, ClosureBuilder> closureBuilders, boolean scriptingMode) {
        Intrinsics.checkNotNullParameter(irElement, "irElement");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(closureBuilders, "closureBuilders");
        this(irElement, declaration, closureBuilders, scriptingMode, null);
    }

    public /* synthetic */ ClosureAnnotator(IrElement irElement, IrDeclaration irDeclaration, Map map, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            map = new LinkedHashMap();
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        this(irElement, irDeclaration, map, bl);
    }

    public ClosureAnnotator(@NotNull IrElement irElement, @NotNull Map<IrDeclaration, ClosureBuilder> closureBuilders, @Nullable IrDeclaration closestParent) {
        Intrinsics.checkNotNullParameter(irElement, "irElement");
        Intrinsics.checkNotNullParameter(closureBuilders, "closureBuilders");
        this(irElement, null, closureBuilders, false, closestParent);
    }

    @NotNull
    public final Closure getRootClosure() {
        return this.rootClosureBuilder.buildClosure();
    }

    @NotNull
    public final Closure getFunctionClosure(@NotNull IrFunction declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        return this.getClosure(declaration);
    }

    @NotNull
    public final Closure getClassClosure(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        return this.getClosure(declaration);
    }

    @NotNull
    public final Closure getClosure(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        ClosureBuilder closureBuilder = this.closureBuilders.get(declaration);
        if (closureBuilder == null) {
            boolean bl = false;
            throw new AssertionError((Object)("No closure builder for passed declaration " + IrUtilsKt.ir2string(declaration) + '.'));
        }
        return closureBuilder.buildClosure();
    }

    private final void includeInParent(ClosureBuilder builder) {
        ClosureBuilder parentBuilder;
        IrDeclaration irDeclaration = builder.getOwner();
        ClosureBuilder closureBuilder = parentBuilder = irDeclaration != null ? this.getParentClosureBuilder(irDeclaration) : null;
        if (parentBuilder != null && !(parentBuilder.getOwner() instanceof IrFunction)) {
            parentBuilder.include(builder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ClosureBuilder getClosureBuilder(IrClass $this$closureBuilder) {
        Object object;
        void $this$getOrPut$iv;
        Map<IrDeclaration, ClosureBuilder> map = this.closureBuilders;
        IrClass key$iv = $this$closureBuilder;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            Object v1;
            ClosureBuilder closureBuilder;
            block10: {
                boolean bl = false;
                closureBuilder = new ClosureBuilder($this$closureBuilder);
                this.collectPotentiallyCapturedTypeParameters(closureBuilder);
                closureBuilder.declareVariable($this$closureBuilder.getThisReceiver());
                if ($this$closureBuilder.isInner()) {
                    IrValueParameter irValueParameter;
                    IrDeclarationParent parent2 = $this$closureBuilder.getParent();
                    if (parent2 instanceof IrClass) {
                        irValueParameter = ((IrClass)parent2).getThisReceiver();
                    } else if (parent2 instanceof IrScript) {
                        irValueParameter = ((IrScript)parent2).getThisReceiver();
                    } else {
                        throw new IllegalStateException(("unexpected parent " + parent2).toString());
                    }
                    IrValueParameter receiver = irValueParameter;
                    closureBuilder.declareVariable(receiver);
                    this.includeInParent(closureBuilder);
                }
                Iterable $this$firstOrNull$iv = $this$closureBuilder.getDeclarations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    IrDeclaration it = (IrDeclaration)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof IrConstructor && ((IrConstructor)it).isPrimary())) continue;
                    v1 = element$iv;
                    break block10;
                }
                v1 = null;
            }
            IrDeclaration irDeclaration = v1;
            if (irDeclaration != null) {
                IrDeclaration it = irDeclaration;
                boolean bl = false;
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrConstructor");
                IrConstructor constructor = (IrConstructor)it;
                Iterable $this$forEach$iv = IrUtilsKt.getNonDispatchParameters(constructor);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrValueParameter v2 = (IrValueParameter)element$iv;
                    boolean bl3 = false;
                    closureBuilder.declareVariable(v2);
                }
            }
            ClosureBuilder answer$iv = closureBuilder;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (ClosureBuilder)object;
    }

    /*
     * WARNING - void declaration
     */
    private final ClosureBuilder getClosureBuilder(IrFunction $this$closureBuilder) {
        Object object;
        void $this$getOrPut$iv;
        Map<IrDeclaration, ClosureBuilder> map = this.closureBuilders;
        IrFunction key$iv = $this$closureBuilder;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            ClosureBuilder closureBuilder = new ClosureBuilder($this$closureBuilder);
            this.collectPotentiallyCapturedTypeParameters(closureBuilder);
            Iterable $this$forEach$iv = $this$closureBuilder.getParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl2 = false;
                closureBuilder.declareVariable(it);
            }
            closureBuilder.seeType($this$closureBuilder.getReturnType());
            if ($this$closureBuilder instanceof IrConstructor) {
                IrDeclarationParent irDeclarationParent = $this$closureBuilder.getParent();
                Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                IrClass constructedClass = (IrClass)irDeclarationParent;
                closureBuilder.declareVariable(constructedClass.getThisReceiver());
                ClosureBuilder classBuilder = this.getClosureBuilder(constructedClass);
                closureBuilder.include(classBuilder);
            }
            ClosureBuilder answer$iv = closureBuilder;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (ClosureBuilder)object;
    }

    private final void collectPotentiallyCapturedTypeParameters(ClosureBuilder closureBuilder) {
        ClosureBuilder current;
        IrDeclaration irDeclaration = closureBuilder.getOwner();
        if (irDeclaration == null) {
            irDeclaration = this.closestParent;
        }
        ClosureBuilder closureBuilder2 = current = irDeclaration != null ? this.getParentClosureBuilder(irDeclaration) : null;
        while (current != null) {
            IrDeclaration container = current.getOwner();
            if (container instanceof IrTypeParametersContainer) {
                for (IrTypeParameter typeParameter : ((IrTypeParametersContainer)container).getTypeParameters()) {
                    closureBuilder.addPotentiallyCapturedTypeParameter(typeParameter);
                }
            }
            IrDeclaration irDeclaration2 = container;
            current = irDeclaration2 != null ? this.getParentClosureBuilder(irDeclaration2) : null;
        }
    }

    private final ClosureBuilder getParentClosureBuilder(IrDeclaration $this$parentClosureBuilder) {
        IrDeclarationParent p2 = $this$parentClosureBuilder.getParent();
        return p2 instanceof IrClass ? this.getClosureBuilder((IrClass)p2) : (p2 instanceof IrFunction ? this.getClosureBuilder((IrFunction)p2) : (p2 instanceof IrDeclaration ? this.getParentClosureBuilder((IrDeclaration)((Object)p2)) : null));
    }

    private final ClosureBuilder getClosureBuilderOrNull(IrDeclaration $this$closureBuilderOrNull) {
        IrDeclaration irDeclaration = $this$closureBuilderOrNull;
        return irDeclaration instanceof IrClass ? this.getClosureBuilder((IrClass)$this$closureBuilderOrNull) : (irDeclaration instanceof IrFunction ? this.getClosureBuilder((IrFunction)$this$closureBuilderOrNull) : null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00000\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0000J\u0010\u0010\u001b\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\fJ\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\nJ\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\fJ\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000fJ\u000e\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u000fJ\u000e\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "", "owner", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "getOwner", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "capturedValues", "", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "declaredValues", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "includes", "potentiallyCapturedTypeParameters", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "capturedTypeParameters", "closure", "Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "buildClosure", "collectConnectedClosures", "", "updateFromIncluded", "", "include", "", "includingBuilder", "declareVariable", "valueDeclaration", "seeVariable", "value", "isExternal", "typeParameter", "addPotentiallyCapturedTypeParameter", "param", "seeType", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nClosureAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClosureAnnotator.kt\norg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,371:1\n1#2:372\n873#3,2:373\n873#3,2:375\n1915#3,2:377\n1915#3,2:379\n*S KotlinDebug\n*F\n+ 1 ClosureAnnotator.kt\norg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder\n*L\n136#1:373,2\n137#1:375,2\n178#1:377,2\n179#1:379,2\n*E\n"})
    public static final class ClosureBuilder {
        @Nullable
        private final IrDeclaration owner;
        @NotNull
        private final Set<IrValueSymbol> capturedValues;
        @NotNull
        private final Set<IrValueDeclaration> declaredValues;
        @NotNull
        private final Set<ClosureBuilder> includes;
        @NotNull
        private final Set<IrTypeParameter> potentiallyCapturedTypeParameters;
        @NotNull
        private final Set<IrTypeParameter> capturedTypeParameters;
        @Nullable
        private Closure closure;

        public ClosureBuilder(@Nullable IrDeclaration owner) {
            this.owner = owner;
            this.capturedValues = new LinkedHashSet();
            this.declaredValues = new LinkedHashSet();
            this.includes = new LinkedHashSet();
            this.potentiallyCapturedTypeParameters = new LinkedHashSet();
            this.capturedTypeParameters = new LinkedHashSet();
        }

        @Nullable
        public final IrDeclaration getOwner() {
            return this.owner;
        }

        @NotNull
        public final Closure buildClosure() {
            boolean changes;
            Closure closure = this.closure;
            if (closure != null) {
                Closure it = closure;
                boolean bl = false;
                return it;
            }
            List<ClosureBuilder> work = this.collectConnectedClosures();
            do {
                changes = false;
                for (ClosureBuilder c2 : work) {
                    if (!c2.updateFromIncluded()) continue;
                    changes = true;
                }
            } while (changes);
            for (ClosureBuilder c3 : work) {
                c3.closure = new Closure(CollectionsKt.toList((Iterable)c3.capturedValues), CollectionsKt.toList((Iterable)c3.capturedTypeParameters));
            }
            Closure closure2 = this.closure;
            if (closure2 == null) {
                StringBuilder stringBuilder = new StringBuilder().append("Closure should have been built for ");
                Object object = this.owner;
                if (object == null || (object = RenderIrElementKt.render$default((IrElement)object, null, 1, null)) == null) {
                    object = "ROOT builder";
                }
                String string = stringBuilder.append((String)object).toString();
                throw new IllegalStateException(string.toString());
            }
            return closure2;
        }

        private final List<ClosureBuilder> collectConnectedClosures() {
            LinkedHashSet<ClosureBuilder> connected = new LinkedHashSet<ClosureBuilder>();
            connected.add(this);
            ClosureBuilder.collectConnectedClosures$collectRec(connected, this);
            return CollectionsKt.asReversed(CollectionsKt.toList((Iterable)connected));
        }

        private final boolean updateFromIncluded() {
            if (!(this.closure == null)) {
                boolean $i$a$-require-ClosureAnnotator$ClosureBuilder$updateFromIncluded$22 = false;
                StringBuilder stringBuilder = new StringBuilder().append("Closure has already been built for ");
                Object object = this.owner;
                if (object == null || (object = RenderIrElementKt.render$default((IrElement)object, null, 1, null)) == null) {
                    object = "ROOT builder";
                }
                String $i$a$-require-ClosureAnnotator$ClosureBuilder$updateFromIncluded$22 = stringBuilder.append((String)object).toString();
                throw new IllegalArgumentException($i$a$-require-ClosureAnnotator$ClosureBuilder$updateFromIncluded$22.toString());
            }
            int capturedValuesBefore = this.capturedValues.size();
            int capturedTypeParametersBefore = this.capturedTypeParameters.size();
            for (ClosureBuilder subClosure : this.includes) {
                Object it;
                Iterable $this$filterTo$iv;
                Iterable iterable = subClosure.capturedValues;
                Collection destination$iv = this.capturedValues;
                boolean $i$f$filterTo = false;
                for (Object element$iv : $this$filterTo$iv) {
                    it = (IrValueSymbol)element$iv;
                    boolean bl = false;
                    if (!this.isExternal(it.getOwner())) continue;
                    destination$iv.add(element$iv);
                }
                $this$filterTo$iv = subClosure.capturedTypeParameters;
                destination$iv = this.capturedTypeParameters;
                $i$f$filterTo = false;
                for (Object element$iv : $this$filterTo$iv) {
                    it = (IrTypeParameter)element$iv;
                    boolean bl = false;
                    if (!this.isExternal((IrTypeParameter)it)) continue;
                    destination$iv.add(element$iv);
                }
            }
            return this.capturedValues.size() != capturedValuesBefore || this.capturedTypeParameters.size() != capturedTypeParametersBefore;
        }

        public final void include(@NotNull ClosureBuilder includingBuilder) {
            Intrinsics.checkNotNullParameter(includingBuilder, "includingBuilder");
            this.includes.add(includingBuilder);
        }

        public final void declareVariable(@Nullable IrValueDeclaration valueDeclaration) {
            if (valueDeclaration != null) {
                this.declaredValues.add(valueDeclaration);
                this.seeType(valueDeclaration.getType());
            }
        }

        public final void seeVariable(@NotNull IrValueSymbol value2) {
            Intrinsics.checkNotNullParameter(value2, "value");
            if (this.isExternal(value2.getOwner())) {
                this.capturedValues.add(value2);
            }
        }

        public final boolean isExternal(@NotNull IrValueDeclaration valueDeclaration) {
            Intrinsics.checkNotNullParameter(valueDeclaration, "valueDeclaration");
            return !this.declaredValues.contains(valueDeclaration);
        }

        public final boolean isExternal(@NotNull IrTypeParameter typeParameter) {
            Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
            return this.potentiallyCapturedTypeParameters.contains(typeParameter);
        }

        public final void addPotentiallyCapturedTypeParameter(@NotNull IrTypeParameter param) {
            Intrinsics.checkNotNullParameter(param, "param");
            this.potentiallyCapturedTypeParameters.add(param);
        }

        public final void seeType(@NotNull IrType type) {
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            Intrinsics.checkNotNullParameter(type, "type");
            if (!(type instanceof IrSimpleType)) {
                return;
            }
            IrClassifierSymbol classifier = ((IrSimpleType)type).getClassifier();
            if (classifier instanceof IrTypeParameterSymbol && this.isExternal((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()) && this.capturedTypeParameters.add((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner())) {
                $this$forEach$iv = ((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()).getSuperTypes();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrType p0 = (IrType)element$iv;
                    boolean bl = false;
                    this.seeType(p0);
                }
            }
            $this$forEach$iv = ((IrSimpleType)type).getArguments();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrTypeArgument it = (IrTypeArgument)element$iv;
                boolean bl = false;
                IrTypeProjection irTypeProjection = it instanceof IrTypeProjection ? (IrTypeProjection)it : null;
                if (irTypeProjection == null || (irTypeProjection = irTypeProjection.getType()) == null) continue;
                IrTypeProjection p0 = irTypeProjection;
                boolean bl2 = false;
                this.seeType((IrType)p0);
            }
        }

        private static final void collectConnectedClosures$collectRec(LinkedHashSet<ClosureBuilder> connected, ClosureBuilder current) {
            for (ClosureBuilder included : current.includes) {
                if (included.closure != null || !connected.add(included)) continue;
                ClosureBuilder.collectConnectedClosures$collectRec(connected, included);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\r\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010 \u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020!2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\"\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020#2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010$\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0018\u0010%\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0003H\u0002\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureCollectorVisitor;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitor;", "", "Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator;)V", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "data", "visitClass", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitTypeParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "visitValueAccess", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrValueAccessExpression;", "visitVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "visitRichFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrRichFunctionReference;", "visitRichPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrRichPropertyReference;", "visitPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "visitExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "processScriptCapturing", "processMemberAccess", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "parentClosure", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nClosureAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClosureAnnotator.kt\norg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureCollectorVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,371:1\n1#2:372\n*E\n"})
    private final class ClosureCollectorVisitor
    extends IrVisitor<Unit, ClosureBuilder> {
        @Override
        public void visitElement(@NotNull IrElement element, @NotNull ClosureBuilder data) {
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(data, "data");
            element.acceptChildren(this, data);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration, @NotNull ClosureBuilder data) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            declaration.acceptChildren(this, ClosureAnnotator.this.getClosureBuilder(declaration));
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration, @NotNull ClosureBuilder data) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            ClosureBuilder closureBuilder = ClosureAnnotator.this.getClosureBuilder(declaration);
            declaration.acceptChildren(this, closureBuilder);
            ClosureAnnotator.this.includeInParent(closureBuilder);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull ClosureBuilder data) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            for (IrType superType : declaration.getSuperTypes()) {
                data.seeType(superType);
            }
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull ClosureBuilder data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            data.seeVariable(expression2.getSymbol());
            super.visitValueAccess(expression2, data);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration, @NotNull ClosureBuilder data) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            data.declareVariable(declaration);
            super.visitVariable(declaration, data);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull ClosureBuilder data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            super.visitFunctionAccess(expression2, data);
            this.processScriptCapturing(expression2, data);
            this.processMemberAccess(((IrFunctionSymbol)expression2.getSymbol()).getOwner(), data);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull ClosureBuilder data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            super.visitFunctionReference(expression2, data);
            this.processMemberAccess(((IrFunctionSymbol)expression2.getSymbol()).getOwner(), data);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull ClosureBuilder data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            super.visitFunctionExpression(expression2, data);
            this.processMemberAccess(expression2.getFunction(), data);
        }

        @Override
        public void visitRichFunctionReference(@NotNull IrRichFunctionReference expression2, @NotNull ClosureBuilder data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            super.visitRichFunctionReference(expression2, data);
            this.processMemberAccess(expression2.getInvokeFunction(), data);
        }

        @Override
        public void visitRichPropertyReference(@NotNull IrRichPropertyReference expression2, @NotNull ClosureBuilder data) {
            block0: {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                Intrinsics.checkNotNullParameter(data, "data");
                super.visitRichPropertyReference(expression2, data);
                this.processMemberAccess(expression2.getGetterFunction(), data);
                IrSimpleFunction irSimpleFunction = expression2.getSetterFunction();
                if (irSimpleFunction == null) break block0;
                IrSimpleFunction it = irSimpleFunction;
                boolean bl = false;
                this.processMemberAccess(it, data);
            }
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull ClosureBuilder data) {
            block1: {
                IrSimpleFunctionSymbol it;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                Intrinsics.checkNotNullParameter(data, "data");
                super.visitPropertyReference(expression2, data);
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getGetter();
                if (irSimpleFunctionSymbol != null) {
                    it = irSimpleFunctionSymbol;
                    boolean bl = false;
                    this.processMemberAccess((IrDeclaration)it.getOwner(), data);
                }
                IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = expression2.getSetter();
                if (irSimpleFunctionSymbol2 == null) break block1;
                it = irSimpleFunctionSymbol2;
                boolean bl = false;
                this.processMemberAccess((IrDeclaration)it.getOwner(), data);
            }
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2, @NotNull ClosureBuilder data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            super.visitExpression(expression2, data);
            Object object = data.getOwner();
            IrConstructor irConstructor = object instanceof IrConstructor ? (IrConstructor)object : null;
            ClosureBuilder typeParameterContainerScopeBuilder = irConstructor != null && (object = ClosureAnnotator.this.getClosureBuilder(irConstructor)) != null ? object : data;
            typeParameterContainerScopeBuilder.seeType(expression2.getType());
        }

        private final void processScriptCapturing(IrFunctionAccessExpression expression2, ClosureBuilder data) {
            IrFunction declaration = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
            if (ClosureAnnotator.this.scriptingMode && (declaration.getDispatchReceiverParameter() == null || expression2.getArguments().size() < declaration.getParameters().size())) {
                IrDeclarationParent parent2 = declaration.getParent();
                if (parent2 instanceof IrScript) {
                    IrValueParameter irValueParameter = ((IrScript)parent2).getThisReceiver();
                    Intrinsics.checkNotNull(irValueParameter);
                    data.seeVariable(irValueParameter.getSymbol());
                } else if (parent2 instanceof IrClass && (Intrinsics.areEqual(((IrClass)parent2).getOrigin(), IrDeclarationOrigin.Companion.getSCRIPT_CLASS()) || Intrinsics.areEqual(((IrClass)parent2).getOrigin(), IrDeclarationOrigin.Companion.getREPL_FROM_OTHER_SNIPPET()))) {
                    IrValueParameter irValueParameter = ((IrClass)parent2).getThisReceiver();
                    Intrinsics.checkNotNull(irValueParameter);
                    data.seeVariable(irValueParameter.getSymbol());
                }
            }
        }

        private final void processMemberAccess(IrDeclaration declaration, ClosureBuilder parentClosure) {
            block2: {
                ClosureBuilder builder;
                if (!AdditionalIrUtilsKt.isLocal(declaration)) break block2;
                if (declaration instanceof IrSimpleFunction && !Intrinsics.areEqual(((IrSimpleFunction)declaration).getVisibility(), DescriptorVisibilities.LOCAL)) {
                    return;
                }
                ClosureBuilder closureBuilder = builder = ClosureAnnotator.this.getClosureBuilderOrNull(declaration);
                if (closureBuilder != null) {
                    ClosureBuilder it = closureBuilder;
                    boolean bl = false;
                    parentClosure.include(builder);
                }
            }
        }
    }
}

