/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.jvm.JvmConstants;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002J(\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmSimpleNameBacktickChecker;", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "<init>", "()V", "DANGEROUS_CHARS", "", "", "checkIdentifier", "", "simpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "checkDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "checkNamed", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "reportIfNeeded", "name", "", "reportOn", "Lkotlin/Function0;", "Lcom/intellij/psi/PsiElement;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nJvmSimpleNameBacktickChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmSimpleNameBacktickChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmSimpleNameBacktickChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,78:1\n1915#2,2:79\n1915#2,2:81\n1915#2,2:83\n1107#3,2:85\n1107#3,2:87\n*S KotlinDebug\n*F\n+ 1 JvmSimpleNameBacktickChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmSimpleNameBacktickChecker\n*L\n37#1:79,2\n40#1:81,2\n43#1:83,2\n62#1:85,2\n70#1:87,2\n*E\n"})
public final class JvmSimpleNameBacktickChecker
implements IdentifierChecker {
    @NotNull
    public static final JvmSimpleNameBacktickChecker INSTANCE = new JvmSimpleNameBacktickChecker();
    @NotNull
    private static final Set<Character> DANGEROUS_CHARS;

    private JvmSimpleNameBacktickChecker() {
    }

    @Override
    public void checkIdentifier(@NotNull KtSimpleNameExpression simpleNameExpression, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkNotNullParameter(simpleNameExpression, "simpleNameExpression");
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
        this.reportIfNeeded(simpleNameExpression.getReferencedName(), () -> JvmSimpleNameBacktickChecker.checkIdentifier$lambda$0(simpleNameExpression), diagnosticHolder);
    }

    @Override
    public void checkDeclaration(@NotNull KtDeclaration declaration, @NotNull DiagnosticSink diagnosticHolder) {
        ASTDelegatePsiElement it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
        if (declaration instanceof KtDestructuringDeclaration) {
            List<KtDestructuringDeclarationEntry> list = ((KtDestructuringDeclaration)declaration).getEntries();
            Intrinsics.checkNotNullExpressionValue(list, "getEntries(...)");
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KtDestructuringDeclarationEntry)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                INSTANCE.checkNamed((KtNamedDeclaration)((Object)it), diagnosticHolder);
            }
        }
        if (declaration instanceof KtCallableDeclaration) {
            List<KtParameter> list = ((KtCallableDeclaration)declaration).getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KtParameter)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                INSTANCE.checkNamed((KtNamedDeclaration)((Object)it), diagnosticHolder);
            }
        }
        if (declaration instanceof KtTypeParameterListOwner) {
            List<KtTypeParameter> list = ((KtTypeParameterListOwner)declaration).getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list, "getTypeParameters(...)");
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KtTypeParameter)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                INSTANCE.checkNamed((KtNamedDeclaration)((Object)it), diagnosticHolder);
            }
        }
        if (declaration instanceof KtNamedDeclaration) {
            this.checkNamed((KtNamedDeclaration)declaration, diagnosticHolder);
        }
    }

    private final void checkNamed(KtNamedDeclaration declaration, DiagnosticSink diagnosticHolder) {
        String string = declaration.getName();
        if (string == null) {
            return;
        }
        String name2 = string;
        this.reportIfNeeded(name2, () -> JvmSimpleNameBacktickChecker.checkNamed$lambda$0(declaration), diagnosticHolder);
    }

    private final void reportIfNeeded(String name2, Function0<? extends PsiElement> reportOn, DiagnosticSink diagnosticHolder) {
        String string = KtPsiUtil.unquoteIdentifier(name2);
        Intrinsics.checkNotNullExpressionValue(string, "unquoteIdentifier(...)");
        String text = string;
        if (((CharSequence)text).length() == 0) {
            PsiElement psiElement = reportOn.invoke();
            if (psiElement == null) {
                return;
            }
            diagnosticHolder.report(Errors.INVALID_CHARACTERS.on(psiElement, "should not be empty"));
        } else {
            boolean bl;
            char it;
            char element$iv;
            int n2;
            boolean $i$f$any;
            CharSequence $this$any$iv;
            block10: {
                $this$any$iv = text;
                $i$f$any = false;
                for (n2 = 0; n2 < $this$any$iv.length(); ++n2) {
                    it = element$iv = $this$any$iv.charAt(n2);
                    boolean bl2 = false;
                    if (!JvmConstants.INSTANCE.getINVALID_CHARS().contains(Character.valueOf(it))) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
            if (bl) {
                PsiElement psiElement = reportOn.invoke();
                if (psiElement == null) {
                    return;
                }
                diagnosticHolder.report(Errors.INVALID_CHARACTERS.on(psiElement, "contains illegal characters: " + CollectionsKt.joinToString$default(CollectionsKt.intersect((Iterable)JvmConstants.INSTANCE.getINVALID_CHARS(), (Iterable)StringsKt.toSet(text)), "", null, null, 0, null, null, 62, null)));
            } else {
                boolean bl3;
                block11: {
                    $this$any$iv = text;
                    $i$f$any = false;
                    for (n2 = 0; n2 < $this$any$iv.length(); ++n2) {
                        it = element$iv = $this$any$iv.charAt(n2);
                        boolean bl4 = false;
                        if (!DANGEROUS_CHARS.contains(Character.valueOf(it))) continue;
                        bl3 = true;
                        break block11;
                    }
                    bl3 = false;
                }
                if (bl3) {
                    PsiElement psiElement = reportOn.invoke();
                    if (psiElement == null) {
                        return;
                    }
                    diagnosticHolder.report(ErrorsJvm.DANGEROUS_CHARACTERS.on(psiElement, CollectionsKt.joinToString$default(CollectionsKt.intersect((Iterable)DANGEROUS_CHARS, (Iterable)StringsKt.toSet(text)), "", null, null, 0, null, null, 62, null)));
                }
            }
        }
    }

    private static final PsiElement checkIdentifier$lambda$0(KtSimpleNameExpression $simpleNameExpression) {
        return $simpleNameExpression.getIdentifier();
    }

    private static final PsiElement checkNamed$lambda$0(KtNamedDeclaration $declaration) {
        PsiElement psiElement = $declaration.getNameIdentifier();
        if (psiElement == null) {
            psiElement = $declaration;
        }
        return psiElement;
    }

    static {
        Character[] characterArray = new Character[]{Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('\"'), Character.valueOf('|'), Character.valueOf('%')};
        DANGEROUS_CHARS = SetsKt.setOf(characterArray);
    }
}

