/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;

public class Segment {
    private LineSegment ls;
    private Object data = null;

    public Segment(double x1, double y1, double z1, double x2, double y2, double z2) {
        this(new Coordinate(x1, y1, z1), new Coordinate(x2, y2, z2));
    }

    public Segment(double x1, double y1, double z1, double x2, double y2, double z2, Object data) {
        this(new Coordinate(x1, y1, z1), new Coordinate(x2, y2, z2), data);
    }

    public Segment(Coordinate p0, Coordinate p1, Object data) {
        this.ls = new LineSegment(p0, p1);
        this.data = data;
    }

    public Segment(Coordinate p0, Coordinate p1) {
        this.ls = new LineSegment(p0, p1);
    }

    public Coordinate getStart() {
        return this.ls.getCoordinate(0);
    }

    public Coordinate getEnd() {
        return this.ls.getCoordinate(1);
    }

    public double getStartX() {
        Coordinate p = this.ls.getCoordinate(0);
        return p.x;
    }

    public double getStartY() {
        Coordinate p = this.ls.getCoordinate(0);
        return p.y;
    }

    public double getStartZ() {
        Coordinate p = this.ls.getCoordinate(0);
        return p.z;
    }

    public double getEndX() {
        Coordinate p = this.ls.getCoordinate(1);
        return p.x;
    }

    public double getEndY() {
        Coordinate p = this.ls.getCoordinate(1);
        return p.y;
    }

    public double getEndZ() {
        Coordinate p = this.ls.getCoordinate(1);
        return p.z;
    }

    public LineSegment getLineSegment() {
        return this.ls;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean equalsTopo(Segment s) {
        return this.ls.equalsTopo(s.getLineSegment());
    }

    public Coordinate intersection(Segment s) {
        return this.ls.intersection(s.getLineSegment());
    }

    public String toString() {
        return this.ls.toString();
    }
}

