/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store;

import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.IndexSettings;

@PublicApi(since="2.19.0")
public interface IndexStoreListener {
    public static final IndexStoreListener EMPTY = new IndexStoreListener(){};

    default public void beforeShardPathDeleted(ShardId shardId, IndexSettings indexSettings, NodeEnvironment env) {
    }

    default public void beforeIndexPathDeleted(Index index, IndexSettings indexSettings, NodeEnvironment env) {
    }

    @PublicApi(since="2.19.0")
    public static final class CompositeIndexStoreListener
    implements IndexStoreListener {
        private final List<IndexStoreListener> listeners;
        private static final Logger logger = LogManager.getLogger(CompositeIndexStoreListener.class);

        public CompositeIndexStoreListener(List<IndexStoreListener> listeners) {
            this.listeners = Collections.unmodifiableList(listeners);
        }

        @Override
        public void beforeShardPathDeleted(ShardId shardId, IndexSettings indexSettings, NodeEnvironment env) {
            for (IndexStoreListener listener : this.listeners) {
                try {
                    listener.beforeShardPathDeleted(shardId, indexSettings, env);
                }
                catch (Exception e) {
                    logger.warn(() -> new ParameterizedMessage("beforeShardPathDeleted listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void beforeIndexPathDeleted(Index index, IndexSettings indexSettings, NodeEnvironment env) {
            for (IndexStoreListener listener : this.listeners) {
                try {
                    listener.beforeIndexPathDeleted(index, indexSettings, env);
                }
                catch (Exception e) {
                    logger.warn(() -> new ParameterizedMessage("beforeIndexPathDeleted listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }
    }
}

