/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.rewriter.nestedfield;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNotExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlSelectGroupByExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import java.util.List;
import org.opensearch.sql.legacy.rewriter.nestedfield.Scope;
import org.opensearch.sql.legacy.utils.Util;

abstract class SQLClause<T> {
    protected final T expr;

    SQLClause(T expr) {
        this.expr = expr;
    }

    abstract void rewrite(Scope var1);

    SQLMethodInvokeExpr replaceByNestedFunction(SQLExpr expr, String nestedPath) {
        boolean nestedPathIndex = true;
        SQLMethodInvokeExpr nestedFunc = this.replaceByNestedFunction(expr);
        nestedFunc.getParameters().add(1, new SQLCharExpr(nestedPath));
        return nestedFunc;
    }

    SQLMethodInvokeExpr replaceByNestedFunction(SQLExpr expr) {
        SQLObject parent = expr.getParent();
        SQLMethodInvokeExpr nestedFunc = this.wrapNestedFunction(expr);
        if (parent instanceof SQLAggregateExpr) {
            List args = ((SQLAggregateExpr)parent).getArguments();
            args.set(args.indexOf(expr), nestedFunc);
        } else if (parent instanceof SQLSelectItem) {
            ((SQLSelectItem)parent).setExpr((SQLExpr)nestedFunc);
        } else if (parent instanceof MySqlSelectGroupByExpr) {
            ((MySqlSelectGroupByExpr)parent).setExpr((SQLExpr)nestedFunc);
        } else if (parent instanceof SQLSelectOrderByItem) {
            ((SQLSelectOrderByItem)parent).setExpr((SQLExpr)nestedFunc);
        } else if (parent instanceof SQLInSubQueryExpr) {
            ((SQLInSubQueryExpr)parent).setExpr((SQLExpr)nestedFunc);
        } else if (parent instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr parentOp = (SQLBinaryOpExpr)parent;
            if (parentOp.getLeft() == expr) {
                parentOp.setLeft((SQLExpr)nestedFunc);
            } else {
                parentOp.setRight((SQLExpr)nestedFunc);
            }
        } else if (parent instanceof MySqlSelectQueryBlock) {
            ((MySqlSelectQueryBlock)parent).setWhere((SQLExpr)nestedFunc);
        } else if (parent instanceof SQLNotExpr) {
            ((SQLNotExpr)parent).setExpr((SQLExpr)nestedFunc);
        } else {
            throw new IllegalStateException("Unsupported place to use nested field under parent: " + String.valueOf(parent));
        }
        return nestedFunc;
    }

    private SQLMethodInvokeExpr wrapNestedFunction(SQLExpr expr) {
        SQLMethodInvokeExpr nestedFunc = new SQLMethodInvokeExpr("nested");
        nestedFunc.setParent(expr.getParent());
        nestedFunc.addParameter(expr);
        return nestedFunc;
    }

    String pathFromIdentifier(SQLExpr identifier) {
        String field = Util.extendedToString(identifier);
        int lastDot = field.lastIndexOf(".");
        return lastDot == -1 ? field : field.substring(0, lastDot);
    }
}

