/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.asynchronous.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensearch.common.Nullable;
import org.opensearch.commons.authuser.User;

public class UserAuthUtils {
    public static User parseUser(Map<String, Object> userDetails) throws IOException {
        if (userDetails == null) {
            return null;
        }
        String name = "";
        List backendRoles = new ArrayList();
        List roles = new ArrayList();
        List customAttNames = new ArrayList();
        for (Map.Entry<String, Object> userDetail : userDetails.entrySet()) {
            String fieldName;
            switch (fieldName = userDetail.getKey()) {
                case "name": {
                    name = (String)userDetail.getValue();
                    break;
                }
                case "backend_roles": {
                    if (userDetail.getValue() == null) break;
                    backendRoles = (List)userDetail.getValue();
                    break;
                }
                case "roles": {
                    if (userDetail.getValue() == null) break;
                    roles = (List)userDetail.getValue();
                    break;
                }
                case "custom_attribute_names": {
                    if (userDetail.getValue() == null) break;
                    customAttNames = (List)userDetail.getValue();
                    break;
                }
            }
        }
        return new User(name, backendRoles, roles, customAttNames);
    }

    public static boolean isUserValid(@Nullable User currentUser, @Nullable User originalUser) {
        if (originalUser == null || currentUser == null) {
            return true;
        }
        if (currentUser.getBackendRoles() == null) {
            return originalUser.getBackendRoles() == null;
        }
        return currentUser.getBackendRoles().containsAll(originalUser.getBackendRoles());
    }
}

