/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.notifications.model;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.notifications.model.BaseModel;
import org.opensearch.commons.notifications.model.SeverityType;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.commons.utils.XContentHelpersKt;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B/\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u00c6\u0003J7\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0006H\u00d6\u0001J\u001c\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006*"}, d2={"Lorg/opensearch/commons/notifications/model/EventSource;", "Lorg/opensearch/commons/notifications/model/BaseModel;", "input", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "title", "", "referenceId", "severity", "Lorg/opensearch/commons/notifications/model/SeverityType;", "tags", "", "(Ljava/lang/String;Ljava/lang/String;Lorg/opensearch/commons/notifications/model/SeverityType;Ljava/util/List;)V", "getReferenceId", "()Ljava/lang/String;", "getSeverity", "()Lorg/opensearch/commons/notifications/model/SeverityType;", "getTags", "()Ljava/util/List;", "getTitle", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "output", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "common-utils"})
@SourceDebugExtension(value={"SMAP\nEventSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventSource.kt\norg/opensearch/commons/notifications/model/EventSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public final class EventSource
implements BaseModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String title;
    @NotNull
    private final String referenceId;
    @NotNull
    private final SeverityType severity;
    @NotNull
    private final List<String> tags;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(EventSource.class);
    @NotNull
    private static final Writeable.Reader<EventSource> reader = EventSource::reader$lambda$1;

    public EventSource(@NotNull String title, @NotNull String referenceId, @NotNull SeverityType severity, @NotNull List<String> tags) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        this.title = title;
        this.referenceId = referenceId;
        this.severity = severity;
        this.tags = tags;
        if (!(!Strings.isNullOrEmpty((String)this.title))) {
            boolean bl = false;
            String string = "name is null or empty";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ EventSource(String string, String string2, SeverityType severityType, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            severityType = SeverityType.INFO;
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, string2, severityType, list);
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final String getReferenceId() {
        return this.referenceId;
    }

    @NotNull
    public final SeverityType getSeverity() {
        return this.severity;
    }

    @NotNull
    public final List<String> getTags() {
        return this.tags;
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNull((Object)builder);
        XContentBuilder xContentBuilder = builder.startObject().field("title", this.title).field("reference_id", this.referenceId).field("severity", this.severity.getTag()).field("tags", (Iterable)this.tags).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"endObject(...)");
        return xContentBuilder;
    }

    public EventSource(@NotNull StreamInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String string = input.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        String string2 = input.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
        Enum enum_ = input.readEnum(SeverityType.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"readEnum(...)");
        SeverityType severityType = (SeverityType)enum_;
        List list = input.readStringList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readStringList(...)");
        this(string, string2, severityType, list);
    }

    public void writeTo(@NotNull StreamOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeString(this.title);
        output.writeString(this.referenceId);
        output.writeEnum((Enum)this.severity);
        output.writeStringCollection((Collection)this.tags);
    }

    @NotNull
    public final String component1() {
        return this.title;
    }

    @NotNull
    public final String component2() {
        return this.referenceId;
    }

    @NotNull
    public final SeverityType component3() {
        return this.severity;
    }

    @NotNull
    public final List<String> component4() {
        return this.tags;
    }

    @NotNull
    public final EventSource copy(@NotNull String title, @NotNull String referenceId, @NotNull SeverityType severity, @NotNull List<String> tags) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        return new EventSource(title, referenceId, severity, tags);
    }

    public static /* synthetic */ EventSource copy$default(EventSource eventSource, String string, String string2, SeverityType severityType, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = eventSource.title;
        }
        if ((n & 2) != 0) {
            string2 = eventSource.referenceId;
        }
        if ((n & 4) != 0) {
            severityType = eventSource.severity;
        }
        if ((n & 8) != 0) {
            list = eventSource.tags;
        }
        return eventSource.copy(string, string2, severityType, list);
    }

    @NotNull
    public String toString() {
        return "EventSource(title=" + this.title + ", referenceId=" + this.referenceId + ", severity=" + this.severity + ", tags=" + this.tags + ")";
    }

    public int hashCode() {
        int result = this.title.hashCode();
        result = result * 31 + this.referenceId.hashCode();
        result = result * 31 + this.severity.hashCode();
        result = result * 31 + ((Object)this.tags).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EventSource)) {
            return false;
        }
        EventSource eventSource = (EventSource)other;
        if (!Intrinsics.areEqual((Object)this.title, (Object)eventSource.title)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.referenceId, (Object)eventSource.referenceId)) {
            return false;
        }
        if (this.severity != eventSource.severity) {
            return false;
        }
        return Intrinsics.areEqual(this.tags, eventSource.tags);
    }

    private static final EventSource reader$lambda$1(StreamInput it) {
        Intrinsics.checkNotNull((Object)it);
        return new EventSource(it);
    }

    @JvmStatic
    @NotNull
    public static final EventSource parse(@NotNull XContentParser parser) throws IOException {
        return Companion.parse(parser);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001f\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/commons/notifications/model/EventSource$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "reader", "Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "Lorg/opensearch/commons/notifications/model/EventSource;", "kotlin.jvm.PlatformType", "getReader", "()Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "parse", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final Writeable.Reader<EventSource> getReader() {
            return reader;
        }

        @JvmStatic
        @NotNull
        public final EventSource parse(@NotNull XContentParser parser) throws IOException {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            String title = null;
            String referenceId = null;
            SeverityType severity = SeverityType.INFO;
            List<String> tags = CollectionsKt.emptyList();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block19: {
                    fieldName = parser.currentName();
                    parser.nextToken();
                    String string = fieldName;
                    if (string == null) break block19;
                    int n = -1;
                    switch (string.hashCode()) {
                        case 1478300413: {
                            if (string.equals("severity")) {
                                n = 1;
                            }
                            break;
                        }
                        case -502535537: {
                            if (string.equals("reference_id")) {
                                n = 2;
                            }
                            break;
                        }
                        case 110371416: {
                            if (string.equals("title")) {
                                n = 3;
                            }
                            break;
                        }
                        case 3552281: {
                            if (string.equals("tags")) {
                                n = 4;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 3: {
                            title = parser.text();
                            continue block12;
                        }
                        case 2: {
                            referenceId = parser.text();
                            continue block12;
                        }
                        case 1: {
                            String string2 = parser.text();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text(...)");
                            severity = SeverityType.Companion.fromTagOrDefault(string2);
                            continue block12;
                        }
                        case 4: {
                            tags = XContentHelpersKt.stringList(parser);
                            continue block12;
                        }
                    }
                }
                parser.skipChildren();
                this.getLog().info("Unexpected field: " + fieldName + ", while parsing EventSource");
            }
            if (title == null) {
                throw new IllegalArgumentException("title field absent");
            }
            if (referenceId == null) {
                throw new IllegalArgumentException("reference_id field absent");
            }
            return new EventSource(title, referenceId, severity, tags);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

