/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NestedAggregation
extends BucketAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, NestedAggregation> {
    @Nullable
    private final String path;
    public static final JsonpDeserializer<NestedAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NestedAggregation::setupNestedAggregationDeserializer);

    private NestedAggregation(Builder builder) {
        super(builder);
        this.path = builder.path;
    }

    public static NestedAggregation of(Function<Builder, ObjectBuilder<NestedAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Nested;
    }

    @Nullable
    public final String path() {
        return this.path;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.path != null) {
            generator.writeKey("path");
            generator.write(this.path);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNestedAggregationDeserializer(ObjectDeserializer<Builder> op) {
        NestedAggregation.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.path);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedAggregation other = (NestedAggregation)o;
        return Objects.equals(this.path, other.path);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, NestedAggregation> {
        @Nullable
        private String path;

        public Builder() {
        }

        private Builder(NestedAggregation o) {
            super(o);
            this.path = o.path;
        }

        private Builder(Builder o) {
            super(o);
            this.path = o.path;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder path(@Nullable String value) {
            this.path = value;
            return this;
        }

        @Override
        @Nonnull
        public NestedAggregation build() {
            this._checkSingleUse();
            return new NestedAggregation(this);
        }
    }
}

