/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.Time;

class V2TBSCertListGenerator {
    private ASN1Integer version = new ASN1Integer(1L);
    private AlgorithmIdentifier signature;
    private X500Name issuer;
    private Time thisUpdate;
    private Time nextUpdate = null;
    private Extensions extensions = null;
    private ASN1EncodableVector crlentries = new ASN1EncodableVector();
    private static final ASN1Sequence[] reasons = new ASN1Sequence[11];

    public void setSignature(AlgorithmIdentifier algorithmIdentifier) {
        this.signature = algorithmIdentifier;
    }

    public void setIssuer(X500Name x500Name) {
        this.issuer = x500Name;
    }

    public void setThisUpdate(ASN1UTCTime aSN1UTCTime) {
        this.thisUpdate = new Time((ASN1Primitive)aSN1UTCTime);
    }

    public void setNextUpdate(ASN1UTCTime aSN1UTCTime) {
        this.nextUpdate = new Time((ASN1Primitive)aSN1UTCTime);
    }

    public void setThisUpdate(Time time) {
        this.thisUpdate = time;
    }

    public void setNextUpdate(Time time) {
        this.nextUpdate = time;
    }

    public void addCRLEntry(ASN1Sequence aSN1Sequence) {
        this.crlentries.add((ASN1Encodable)aSN1Sequence);
    }

    public void addCRLEntry(ASN1Integer aSN1Integer, ASN1UTCTime aSN1UTCTime, int n) {
        this.addCRLEntry(aSN1Integer, new Time((ASN1Primitive)aSN1UTCTime), n);
    }

    public void addCRLEntry(ASN1Integer aSN1Integer, Time time, int n) {
        this.addCRLEntry(aSN1Integer, time, n, null);
    }

    public void addCRLEntry(ASN1Integer aSN1Integer, Time time, int n, ASN1GeneralizedTime aSN1GeneralizedTime) {
        if (n != 0) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
            if (n < reasons.length) {
                if (n < 0) {
                    throw new IllegalArgumentException("invalid reason value: " + n);
                }
                aSN1EncodableVector.add((ASN1Encodable)reasons[n]);
            } else {
                aSN1EncodableVector.add((ASN1Encodable)V2TBSCertListGenerator.createReasonExtension(n));
            }
            if (aSN1GeneralizedTime != null) {
                aSN1EncodableVector.add((ASN1Encodable)V2TBSCertListGenerator.createInvalidityDateExtension(aSN1GeneralizedTime));
            }
            this.internalAddCRLEntry(aSN1Integer, time, (ASN1Sequence)new DERSequence(aSN1EncodableVector));
        } else if (aSN1GeneralizedTime != null) {
            this.internalAddCRLEntry(aSN1Integer, time, (ASN1Sequence)new DERSequence((ASN1Encodable)V2TBSCertListGenerator.createInvalidityDateExtension(aSN1GeneralizedTime)));
        } else {
            this.addCRLEntry(aSN1Integer, time, null);
        }
    }

    private void internalAddCRLEntry(ASN1Integer aSN1Integer, Time time, ASN1Sequence aSN1Sequence) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        aSN1EncodableVector.add((ASN1Encodable)aSN1Integer);
        aSN1EncodableVector.add((ASN1Encodable)time);
        if (aSN1Sequence != null) {
            aSN1EncodableVector.add((ASN1Encodable)aSN1Sequence);
        }
        this.addCRLEntry((ASN1Sequence)new DERSequence(aSN1EncodableVector));
    }

    public void addCRLEntry(ASN1Integer aSN1Integer, Time time, Extensions extensions) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        aSN1EncodableVector.add((ASN1Encodable)aSN1Integer);
        aSN1EncodableVector.add((ASN1Encodable)time);
        if (extensions != null) {
            aSN1EncodableVector.add((ASN1Encodable)extensions);
        }
        this.addCRLEntry((ASN1Sequence)new DERSequence(aSN1EncodableVector));
    }

    public void setExtensions(Extensions extensions) {
        this.extensions = extensions;
    }

    public TBSCertList generateTBSCertList() {
        if (this.signature == null || this.issuer == null || this.thisUpdate == null) {
            throw new IllegalStateException("not all mandatory fields set in V2 TBSCertList generator");
        }
        return new TBSCertList(this.generateTBSCertStructure());
    }

    public ASN1Sequence generatePreTBSCertList() {
        if (this.signature != null) {
            throw new IllegalStateException("signature should not be set in PreTBSCertList generator");
        }
        if (this.issuer == null || this.thisUpdate == null) {
            throw new IllegalStateException("not all mandatory fields set in V2 PreTBSCertList generator");
        }
        return this.generateTBSCertStructure();
    }

    private ASN1Sequence generateTBSCertStructure() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(7);
        aSN1EncodableVector.add((ASN1Encodable)this.version);
        if (this.signature != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.signature);
        }
        aSN1EncodableVector.add((ASN1Encodable)this.issuer);
        aSN1EncodableVector.add((ASN1Encodable)this.thisUpdate);
        if (this.nextUpdate != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.nextUpdate);
        }
        if (this.crlentries.size() != 0) {
            aSN1EncodableVector.add((ASN1Encodable)new DERSequence(this.crlentries));
        }
        if (this.extensions != null) {
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(0, (ASN1Encodable)this.extensions));
        }
        return new DERSequence(aSN1EncodableVector);
    }

    private static ASN1Sequence createReasonExtension(int n) {
        CRLReason cRLReason = CRLReason.lookup((int)n);
        try {
            return new DERSequence(new ASN1Encodable[]{Extension.reasonCode, new DEROctetString(cRLReason.getEncoded())});
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("error encoding reason: " + iOException);
        }
    }

    private static ASN1Sequence createInvalidityDateExtension(ASN1GeneralizedTime aSN1GeneralizedTime) {
        try {
            return new DERSequence(new ASN1Encodable[]{Extension.invalidityDate, new DEROctetString(aSN1GeneralizedTime.getEncoded())});
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("error encoding reason: " + iOException);
        }
    }

    static {
        V2TBSCertListGenerator.reasons[0] = V2TBSCertListGenerator.createReasonExtension(0);
        V2TBSCertListGenerator.reasons[1] = V2TBSCertListGenerator.createReasonExtension(1);
        V2TBSCertListGenerator.reasons[2] = V2TBSCertListGenerator.createReasonExtension(2);
        V2TBSCertListGenerator.reasons[3] = V2TBSCertListGenerator.createReasonExtension(3);
        V2TBSCertListGenerator.reasons[4] = V2TBSCertListGenerator.createReasonExtension(4);
        V2TBSCertListGenerator.reasons[5] = V2TBSCertListGenerator.createReasonExtension(5);
        V2TBSCertListGenerator.reasons[6] = V2TBSCertListGenerator.createReasonExtension(6);
        V2TBSCertListGenerator.reasons[7] = V2TBSCertListGenerator.createReasonExtension(7);
        V2TBSCertListGenerator.reasons[8] = V2TBSCertListGenerator.createReasonExtension(8);
        V2TBSCertListGenerator.reasons[9] = V2TBSCertListGenerator.createReasonExtension(9);
        V2TBSCertListGenerator.reasons[10] = V2TBSCertListGenerator.createReasonExtension(10);
    }
}

