/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auditlog.sink;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.admin.indices.datastream.CreateDataStreamAction;
import org.opensearch.action.admin.indices.template.put.PutComposableIndexTemplateAction;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.metadata.ComposableIndexTemplate;
import org.opensearch.cluster.metadata.DataStream;
import org.opensearch.cluster.metadata.Template;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.auditlog.impl.AuditMessage;
import org.opensearch.security.auditlog.sink.AbstractInternalOpenSearchSink;
import org.opensearch.security.auditlog.sink.AuditLogSink;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.client.Client;

public final class InternalOpenSearchDataStreamSink
extends AbstractInternalOpenSearchSink {
    String dataStreamName;
    private boolean dataStreamInitialized = false;

    public InternalOpenSearchDataStreamSink(String name, Settings settings, String settingsPrefix, Path configPath, Client clientProvider, ThreadPool threadPool, AuditLogSink fallbackSink, ClusterService clusterService) {
        super(name, settings, settingsPrefix, clientProvider, threadPool, fallbackSink, DocWriteRequest.OpType.CREATE, clusterService);
        Settings sinkSettings = this.getSinkSettings(settingsPrefix);
        this.dataStreamName = sinkSettings.get("data_stream.name", "opensearch-security-auditlog");
    }

    private boolean initDataStream() {
        if (this.dataStreamInitialized) {
            return true;
        }
        Settings sinkSettings = this.getSinkSettings(this.settingsPrefix);
        boolean templateManage = sinkSettings.getAsBoolean("data_stream.template.manage", Boolean.valueOf(true));
        if (templateManage) {
            String templateName = sinkSettings.get("data_stream.template.name", "opensearch-security-auditlog");
            Integer numberOfReplicas = sinkSettings.getAsInt("data_stream.template.number_of_replicas", Integer.valueOf(0));
            Integer numberOfShards = sinkSettings.getAsInt("data_stream.template.number_of_shards", Integer.valueOf(1));
            ComposableIndexTemplate template = new ComposableIndexTemplate(List.of(this.dataStreamName), new Template(Settings.builder().put("number_of_shards", numberOfShards.intValue()).put("number_of_replicas", numberOfReplicas.intValue()).build(), null, null), null, null, null, null, new ComposableIndexTemplate.DataStreamTemplate(new DataStream.TimestampField("@timestamp")));
            try {
                PutComposableIndexTemplateAction.Request request = new PutComposableIndexTemplateAction.Request(templateName);
                request.indexTemplate(template);
                AcknowledgedResponse response = (AcknowledgedResponse)this.clientProvider.execute((ActionType)PutComposableIndexTemplateAction.INSTANCE, (ActionRequest)request).get();
                if (!response.isAcknowledged()) {
                    this.log.error("Failed to create index template {}", (Object)templateName);
                    return false;
                }
            }
            catch (Exception e) {
                this.log.error("Cannot create index template {} due to", (Object)templateName, (Object)e);
                return false;
            }
        }
        CreateDataStreamAction.Request createDataStreamRequest = new CreateDataStreamAction.Request(this.dataStreamName);
        try {
            AcknowledgedResponse response = (AcknowledgedResponse)this.clientProvider.admin().indices().createDataStream(createDataStreamRequest).get();
            if (!response.isAcknowledged()) {
                this.log.error("Failed to create datastream {}", (Object)this.dataStreamName);
            }
            this.dataStreamInitialized = true;
        }
        catch (Exception e) {
            if (e.getCause() instanceof ResourceAlreadyExistsException || e.getCause() instanceof RemoteTransportException && e.getCause().getCause() instanceof ResourceAlreadyExistsException) {
                this.log.trace("Datastream {} already exists", (Object)this.dataStreamName);
                this.dataStreamInitialized = true;
            }
            this.log.error("Cannot create datastream {} due to", (Object)this.dataStreamName, (Object)e);
            return false;
        }
        return this.dataStreamInitialized;
    }

    @Override
    public boolean createIndexIfAbsent(String indexName) {
        return true;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean doStore(AuditMessage msg) {
        if (!this.initDataStream()) {
            this.log.error("Datastream initializaten failed. Cannot write to auditlog");
            return false;
        }
        return super.doStore(msg, this.dataStreamName);
    }
}

