/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.ArrayType;
import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.CommonTypeReferences;
import com.strobel.assembler.metadata.DefaultTypeVisitor;
import com.strobel.assembler.metadata.GenericParameter;
import com.strobel.assembler.metadata.IGenericInstance;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MetadataResolver;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.PrimitiveType;
import com.strobel.assembler.metadata.RawType;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.TypeSubstitutionVisitor;
import com.strobel.assembler.metadata.WildcardType;
import com.strobel.core.VerifyArgument;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MethodBinder {
    public static BindResult selectMethod(List<? extends MethodReference> matches, List<TypeReference> types) {
        int i;
        VerifyArgument.notNull(matches, "matches");
        VerifyArgument.notNull(types, "types");
        if (types.isEmpty()) {
            return null;
        }
        int argumentCount = types.size();
        MethodReference[] candidates = matches.toArray(new MethodReference[matches.size()]);
        for (int i2 = 0; i2 < candidates.length; ++i2) {
            MethodReference candidate = candidates[i2];
            if (!candidate.isGenericMethod()) continue;
            HashMap<TypeReference, TypeReference> mappings = new HashMap<TypeReference, TypeReference>();
            List<ParameterDefinition> parameters = candidate.getParameters();
            int n = Math.min(argumentCount, parameters.size());
            for (int j = 0; j < n; ++j) {
                ParameterDefinition p = parameters.get(j);
                TypeReference pType = p.getParameterType();
                if (!pType.containsGenericParameters()) continue;
                new AddMappingsForArgumentVisitor(types.get(j)).visit(pType, (Map<TypeReference, TypeReference>)mappings);
            }
            candidates[i2] = TypeSubstitutionVisitor.instance().visitMethod(candidate, (Map<TypeReference, TypeReference>)mappings);
        }
        int currentIndex = 0;
        int n = candidates.length;
        for (int i3 = 0; i3 < n; ++i3) {
            TypeReference parameterType;
            int stop;
            boolean isVarArgs;
            MethodReference candidate = candidates[i3];
            MethodDefinition resolved = candidate.resolve();
            List<ParameterDefinition> parameters = candidate.getParameters();
            int parameterCount = parameters.size();
            boolean bl = isVarArgs = resolved != null && resolved.isVarArgs();
            if (parameterCount != types.size() && !isVarArgs) continue;
            for (stop = 0; stop < Math.min(parameterCount, types.size()) && (MetadataHelper.isSameType(parameterType = parameters.get(stop).getParameterType(), types.get(stop), false) || MetadataHelper.isSameType(parameterType, BuiltinTypes.Object, false) || MetadataHelper.isAssignableFrom(parameterType, types.get(stop)) || isVarArgs && stop == parameterCount - 1 && MetadataHelper.isAssignableFrom(parameterType.getElementType(), types.get(stop))); ++stop) {
            }
            if (stop != parameterCount && (stop != parameterCount - 1 || !isVarArgs)) continue;
            candidates[currentIndex++] = candidate;
        }
        if (currentIndex == 0) {
            return BindResult.FAILURE;
        }
        if (currentIndex == 1) {
            return new BindResult(false, candidates[0]);
        }
        int currentMin = 0;
        boolean ambiguous = false;
        int[] parameterOrder = new int[types.size()];
        int n2 = types.size();
        for (i = 0; i < n2; ++i) {
            parameterOrder[i] = i;
        }
        for (i = 1; i < currentIndex; ++i) {
            TypeReference varArgType2;
            TypeReference varArgType1;
            MethodReference m1 = candidates[currentMin];
            MethodReference m2 = candidates[i];
            MethodDefinition r1 = m1.resolve();
            MethodDefinition r2 = m2.resolve();
            if (r1 != null && r1.isVarArgs()) {
                List<ParameterDefinition> p1 = m1.getParameters();
                varArgType1 = p1.get(p1.size() - 1).getParameterType().getElementType();
            } else {
                varArgType1 = null;
            }
            if (r2 != null && r2.isVarArgs()) {
                List<ParameterDefinition> p2 = m2.getParameters();
                varArgType2 = p2.get(p2.size() - 1).getParameterType().getElementType();
            } else {
                varArgType2 = null;
            }
            int newMin = MethodBinder.findMostSpecificMethod(m1, parameterOrder, varArgType1, candidates[i], parameterOrder, varArgType2, types, null);
            if (newMin == 0) {
                ambiguous = true;
                continue;
            }
            if (newMin != 2) continue;
            ambiguous = false;
            currentMin = i;
        }
        if (ambiguous) {
            return new BindResult(true, candidates[currentMin]);
        }
        return new BindResult(false, candidates[currentMin]);
    }

    private static int findMostSpecificMethod(MethodReference m1, int[] varArgOrder1, TypeReference varArgArrayType1, MethodReference m2, int[] varArgOrder2, TypeReference varArgArrayType2, List<TypeReference> types, Object[] args) {
        int result = MethodBinder.findMostSpecific(m1.getParameters(), varArgOrder1, null, m2.getParameters(), varArgOrder2, null, types, args, false);
        if (result == 0) {
            result = MethodBinder.findMostSpecific(m1.getParameters(), varArgOrder1, null, m2.getParameters(), varArgOrder2, null, types, args, true);
        }
        if (result == 0) {
            result = MethodBinder.findMostSpecific(m1.getParameters(), varArgOrder1, varArgArrayType1, m2.getParameters(), varArgOrder2, varArgArrayType2, types, args, true);
        }
        if (result != 0) {
            return result;
        }
        if (MethodBinder.compareMethodSignatureAndName(m1, m2)) {
            int hierarchyDepth2;
            int hierarchyDepth1 = MethodBinder.getHierarchyDepth(m1.getDeclaringType());
            if (hierarchyDepth1 == (hierarchyDepth2 = MethodBinder.getHierarchyDepth(m2.getDeclaringType()))) {
                return 0;
            }
            if (hierarchyDepth1 < hierarchyDepth2) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private static int findMostSpecific(List<ParameterDefinition> p1, int[] varArgOrder1, TypeReference varArgArrayType1, List<ParameterDefinition> p2, int[] varArgOrder2, TypeReference varArgArrayType2, List<TypeReference> types, Object[] args, boolean allowAutoBoxing) {
        if (varArgArrayType1 != null && varArgArrayType2 == null && types.size() != p1.size()) {
            return 2;
        }
        if (varArgArrayType2 != null && varArgArrayType1 == null && types.size() != p2.size()) {
            return 1;
        }
        boolean p1Less = false;
        boolean p2Less = false;
        int max = varArgArrayType1 != null ? types.size() : Math.min(p1.size(), p2.size());
        block4: for (int i = 0; i < max; ++i) {
            TypeReference c2;
            TypeReference c1;
            if (args != null || (c1 = varArgArrayType1 != null && varArgOrder1[i] >= p1.size() - 1 ? varArgArrayType1 : p1.get(varArgOrder1[i]).getParameterType()) == (c2 = varArgArrayType2 != null && varArgOrder2[i] >= p2.size() - 1 ? varArgArrayType2 : p2.get(varArgOrder2[i]).getParameterType())) continue;
            switch (MethodBinder.findMostSpecificType(c1, c2, types.get(i), allowAutoBoxing)) {
                case 1: {
                    p1Less = true;
                    continue block4;
                }
                case 2: {
                    p2Less = true;
                }
            }
        }
        if (p1Less == p2Less) {
            if (!p1Less && args != null) {
                if (p1.size() > p2.size()) {
                    return 1;
                }
                if (p2.size() > p1.size()) {
                    return 2;
                }
            }
            return 0;
        }
        return p1Less ? 1 : 2;
    }

    private static int findMostSpecificType(TypeReference c1, TypeReference c2, TypeReference t, boolean allowAutoBoxing) {
        boolean c2FromC1;
        boolean c1FromC2;
        boolean c2FromT;
        if (MetadataHelper.isSameType(c1, c2, false)) {
            return 0;
        }
        if (MetadataHelper.isSameType(c1, t, false)) {
            return 1;
        }
        if (MetadataHelper.isSameType(c2, t, false)) {
            return 2;
        }
        boolean c1FromT = (allowAutoBoxing || c1.isPrimitive() == t.isPrimitive()) && MetadataHelper.isAssignableFrom(c1, t);
        boolean bl = c2FromT = (allowAutoBoxing || c2.isPrimitive() == t.isPrimitive()) && MetadataHelper.isAssignableFrom(c2, t);
        if (c1FromT != c2FromT) {
            return c1FromT ? 1 : 2;
        }
        if (allowAutoBoxing || c1.isPrimitive() == c2.isPrimitive()) {
            c1FromC2 = MetadataHelper.isAssignableFrom(c1, c2);
            c2FromC1 = MetadataHelper.isAssignableFrom(c2, c1);
        } else {
            c1FromC2 = false;
            c2FromC1 = false;
        }
        if (c1FromC2 == c2FromC1) {
            if (!t.isPrimitive() && c1.isPrimitive() != c2.isPrimitive()) {
                return c1.isPrimitive() ? 2 : 1;
            }
            return 0;
        }
        return c1FromC2 ? 2 : 1;
    }

    private static boolean compareMethodSignatureAndName(MethodReference m1, MethodReference m2) {
        List<ParameterDefinition> p1 = m1.getParameters();
        List<ParameterDefinition> p2 = m2.getParameters();
        if (p1.size() != p2.size()) {
            return false;
        }
        int n = p1.size();
        for (int i = 0; i < n; ++i) {
            if (MetadataHelper.isSameType(p1.get(i).getParameterType(), p2.get(i).getParameterType(), false)) continue;
            return false;
        }
        return true;
    }

    private static int getHierarchyDepth(TypeReference t) {
        int depth = 0;
        TypeReference currentType = t;
        do {
            ++depth;
        } while ((currentType = MetadataHelper.getBaseType(currentType)) != null);
        return depth;
    }

    private static final class AddMappingsForArgumentVisitor
    extends DefaultTypeVisitor<Map<TypeReference, TypeReference>, Void> {
        private TypeReference argumentType;

        AddMappingsForArgumentVisitor(TypeReference argumentType) {
            this.argumentType = VerifyArgument.notNull(argumentType, "argumentType");
        }

        @Override
        public Void visit(TypeReference t, Map<TypeReference, TypeReference> map) {
            TypeReference a = this.argumentType;
            t.accept(this, map);
            this.argumentType = a;
            return null;
        }

        @Override
        public Void visitArrayType(ArrayType t, Map<TypeReference, TypeReference> map) {
            TypeReference a = this.argumentType;
            if (a.isArray() && t.isArray()) {
                this.argumentType = a.getElementType();
                this.visit(t.getElementType(), map);
            }
            return null;
        }

        @Override
        public Void visitGenericParameter(GenericParameter t, Map<TypeReference, TypeReference> map) {
            if (MetadataResolver.areEquivalent(this.argumentType, (TypeReference)t)) {
                return null;
            }
            TypeReference existingMapping = map.get(t);
            TypeReference mappedType = this.argumentType;
            mappedType = AddMappingsForArgumentVisitor.ensureReferenceType(mappedType);
            if (existingMapping == null) {
                if (!(mappedType instanceof RawType) && MetadataHelper.isRawType(mappedType)) {
                    TypeReference bound = MetadataHelper.getUpperBound(t);
                    TypeReference asSuper = MetadataHelper.asSuper(mappedType, bound);
                    if (asSuper != null) {
                        if (MetadataHelper.isSameType(MetadataHelper.getUpperBound(t), asSuper)) {
                            return null;
                        }
                        mappedType = asSuper;
                    } else {
                        mappedType = MetadataHelper.erase(mappedType);
                    }
                }
                map.put(t, mappedType);
            } else if (!MetadataHelper.isSubType(this.argumentType, existingMapping)) {
                TypeReference commonSuperType = MetadataHelper.asSuper(mappedType, existingMapping);
                if (commonSuperType == null) {
                    commonSuperType = MetadataHelper.asSuper(existingMapping, mappedType);
                }
                if (commonSuperType == null) {
                    commonSuperType = MetadataHelper.findCommonSuperType(existingMapping, mappedType);
                }
                map.put(t, commonSuperType);
            }
            return null;
        }

        @Override
        public Void visitWildcard(WildcardType t, Map<TypeReference, TypeReference> map) {
            return null;
        }

        @Override
        public <C extends TypeReference> Void visitCompoundType(C t, Map<TypeReference, TypeReference> map) {
            return null;
        }

        @Override
        public Void visitParameterizedType(TypeReference t, Map<TypeReference, TypeReference> map) {
            TypeReference r = MetadataHelper.asSuper(t.getUnderlyingType(), this.argumentType);
            TypeReference s = MetadataHelper.asSubType(this.argumentType, r != null ? r : t.getUnderlyingType());
            if (s != null && s instanceof IGenericInstance) {
                List<TypeReference> tArgs = ((IGenericInstance)((Object)t)).getTypeArguments();
                List<TypeReference> sArgs = ((IGenericInstance)((Object)s)).getTypeArguments();
                if (tArgs.size() == sArgs.size()) {
                    int n = tArgs.size();
                    for (int i = 0; i < n; ++i) {
                        this.argumentType = sArgs.get(i);
                        this.visit(tArgs.get(i), map);
                    }
                }
            }
            return null;
        }

        @Override
        public Void visitPrimitiveType(PrimitiveType t, Map<TypeReference, TypeReference> map) {
            return null;
        }

        @Override
        public Void visitClassType(TypeReference t, Map<TypeReference, TypeReference> map) {
            return null;
        }

        @Override
        public Void visitNullType(TypeReference t, Map<TypeReference, TypeReference> map) {
            return null;
        }

        @Override
        public Void visitBottomType(TypeReference t, Map<TypeReference, TypeReference> map) {
            return null;
        }

        @Override
        public Void visitRawType(RawType t, Map<TypeReference, TypeReference> map) {
            return null;
        }

        private static TypeReference ensureReferenceType(TypeReference mappedType) {
            if (mappedType == null) {
                return null;
            }
            if (mappedType.isPrimitive()) {
                switch (mappedType.getSimpleType()) {
                    case Boolean: {
                        return CommonTypeReferences.Boolean;
                    }
                    case Byte: {
                        return CommonTypeReferences.Byte;
                    }
                    case Character: {
                        return CommonTypeReferences.Character;
                    }
                    case Short: {
                        return CommonTypeReferences.Short;
                    }
                    case Integer: {
                        return CommonTypeReferences.Integer;
                    }
                    case Long: {
                        return CommonTypeReferences.Long;
                    }
                    case Float: {
                        return CommonTypeReferences.Float;
                    }
                    case Double: {
                        return CommonTypeReferences.Double;
                    }
                }
            }
            return mappedType;
        }
    }

    public static class BindResult {
        public static final BindResult FAILURE = new BindResult(false, null);
        public static final BindResult AMBIGUOUS = new BindResult(true, null);
        private final boolean _ambiguous;
        private final MethodReference _method;

        private BindResult(boolean ambiguous, MethodReference method) {
            this._ambiguous = ambiguous;
            this._method = method;
        }

        public final boolean isFailure() {
            return this._method == null;
        }

        public final boolean isAmbiguous() {
            return this._ambiguous;
        }

        public final MethodReference getMethod() {
            return this._method;
        }
    }
}

