/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.presentations.mindmapmode;

import javax.swing.JComponent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.presentations.mindmapmode.PresentationKeyEventDispatcher;
import org.freeplane.features.presentations.mindmapmode.PresentationState;
import org.freeplane.features.presentations.mindmapmode.PresentationStateChangeEvent;
import org.freeplane.features.presentations.mindmapmode.PresentationStateChangeListener;
import org.freeplane.features.ui.FrameController;

class PresentationAutomation
implements PresentationStateChangeListener {
    static final String SWITCH_TO_FULL_SCREEN_PROPERTY = "presentation.switchToFullScreen";
    static final String SWITCH_TO_SPOTLIGHT_PROPERTY = "presentation.switchToSpotlight";
    private boolean isPresentationRunning = false;
    private final PresentationKeyEventDispatcher[] dispatchers;

    PresentationAutomation(PresentationState state, PresentationKeyEventDispatcher ... dispatchers) {
        this.dispatchers = dispatchers;
    }

    @Override
    public void onPresentationStateChange(PresentationStateChangeEvent presentationStateChangeEvent) {
        if (presentationStateChangeEvent.eventType == PresentationStateChangeEvent.EventType.PLAYING_STATE_CHANGED) {
            this.isPresentationRunning = presentationStateChangeEvent.presentationState.isPresentationRunning();
            this.updateDispatcherState();
            this.updateFullScreenMode();
            this.updateSpotlight();
        }
    }

    private void updateFullScreenMode() {
        if (ResourceController.getResourceController().getBooleanProperty(SWITCH_TO_FULL_SCREEN_PROPERTY)) {
            FrameController viewController = (FrameController)Controller.getCurrentController().getViewController();
            viewController.setFullScreen(this.isPresentationRunning);
        }
    }

    private void updateSpotlight() {
        JComponent mapViewComponent;
        if (ResourceController.getResourceController().getBooleanProperty(SWITCH_TO_SPOTLIGHT_PROPERTY) && (mapViewComponent = this.getMapViewComponent()) != null) {
            mapViewComponent.putClientProperty("spotlight", this.isPresentationRunning);
        }
    }

    private JComponent getMapViewComponent() {
        JComponent mapViewComponent = Controller.getCurrentController().getMapViewManager().getMapViewComponent();
        return mapViewComponent;
    }

    private void updateDispatcherState() {
        for (PresentationKeyEventDispatcher dispatcher : this.dispatchers) {
            if (this.isPresentationRunning) {
                dispatcher.activate();
                continue;
            }
            dispatcher.deactivate();
        }
    }
}

