/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url.mindmapmode;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.swing.JOptionPane;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.PersistentNodeHook;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.MFileManager;

class ImportLinkedBranchAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public ImportLinkedBranchAction() {
        super("ImportLinkedBranchAction");
    }

    public void actionPerformed(ActionEvent e) {
        MapModel map = Controller.getCurrentController().getMap();
        ModeController modeController = Controller.getCurrentModeController();
        NodeModel selected = modeController.getMapController().getSelectedNode();
        IMapViewManager viewController = Controller.getCurrentController().getMapViewManager();
        if (selected == null || NodeLinks.getLink((NodeModel)selected) == null) {
            JOptionPane.showMessageDialog(viewController.getMapViewComponent(), TextUtils.getText((String)"import_linked_branch_no_link"));
            return;
        }
        URI uri = NodeLinks.getLink((NodeModel)selected).getUri();
        try {
            File file = uri.isAbsolute() && !uri.isOpaque() ? new File(uri) : new File(new URL(map.getURL(), uri.getPath()).getFile());
            NodeModel node = ((MFileManager)UrlManager.getController()).loadTree(map, file);
            if (node == map.getRootNode()) {
                return;
            }
            PersistentNodeHook.removeMapExtensions((NodeModel)node);
            node.setSide(MapController.suggestNewChildSide((NodeModel)selected, (NodeModel.Side)NodeModel.Side.DEFAULT));
            ((MMapController)modeController.getMapController()).insertNode(node, selected);
            ((MLinkController)LinkController.getController()).setLink(selected, (URI)null, 0);
            ((MLinkController)LinkController.getController()).setLink(node, (URI)null, 0);
        }
        catch (MalformedURLException ex) {
            UITools.errorMessage((Object)TextUtils.format((String)"invalid_url_msg", (Object[])new Object[]{uri.toString()}));
            LogUtils.warn((Throwable)ex);
            return;
        }
        catch (IllegalArgumentException ex) {
            UITools.errorMessage((Object)TextUtils.format((String)"invalid_file_msg", (Object[])new Object[]{uri.toString()}));
            LogUtils.warn((Throwable)ex);
            return;
        }
        catch (Exception ex) {
            UrlManager.getController().handleLoadingException(ex);
        }
    }
}

