/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.ForwardOnlyResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.Monitor;

class OracleReturnResultSet
extends ForwardOnlyResultSet {
    OracleReturnResultSet(PhysicalConnection conn, OracleStatement stmt) throws SQLException {
        super(conn, stmt);
    }

    @Override
    public void close() throws SQLException {
        try (Monitor.CloseableLock lock = this.statement.connection.acquireCloseableLock();){
            this.doClose();
        }
    }

    @Override
    protected void doClose() throws SQLException {
        this.connection.assertLockHeldByCurrentThread();
        super.doClose();
        this.statement.currentResultSet = null;
        this.statement.returnParamsFetched = false;
        this.statement.rowsDmlReturned = 0;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try (Monitor.CloseableLock lock = this.statement.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10).fillInStackTrace();
            }
            if (this.statement.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            AutoKeyInfo info = this.statement.getAutoKeyInfo();
            if (info == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
            }
            info.statement = this.statement;
            info.connection = this.connection;
            info.initMetaData(this);
            AutoKeyInfo autoKeyInfo = info;
            return autoKeyInfo;
        }
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        Monitor.CloseableLock lock = this.statement.connection.acquireCloseableLock();
        try {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    lock.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }
}

