/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsResponse;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorTarget;

public class DescribeTrafficMirrorTargetsPublisher
implements SdkPublisher<DescribeTrafficMirrorTargetsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeTrafficMirrorTargetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTrafficMirrorTargetsPublisher(Ec2AsyncClient client, DescribeTrafficMirrorTargetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTrafficMirrorTargetsPublisher(Ec2AsyncClient client, DescribeTrafficMirrorTargetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTrafficMirrorTargetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTrafficMirrorTargetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TrafficMirrorTarget> trafficMirrorTargets() {
        Function<DescribeTrafficMirrorTargetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trafficMirrorTargets() != null) {
                return response.trafficMirrorTargets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeTrafficMirrorTargetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeTrafficMirrorTargetsResponseFetcher
    implements AsyncPageFetcher<DescribeTrafficMirrorTargetsResponse> {
        private DescribeTrafficMirrorTargetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTrafficMirrorTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeTrafficMirrorTargetsResponse> nextPage(DescribeTrafficMirrorTargetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTrafficMirrorTargetsPublisher.this.client.describeTrafficMirrorTargets(DescribeTrafficMirrorTargetsPublisher.this.firstRequest);
            }
            return DescribeTrafficMirrorTargetsPublisher.this.client.describeTrafficMirrorTargets((DescribeTrafficMirrorTargetsRequest)((Object)DescribeTrafficMirrorTargetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

