/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;
import org.apache.poi.hmef.attribute.MAPIRtfAttribute;
import org.apache.poi.hsmf.MAPIMessage;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.datatypes.ByteChunk;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.Chunks;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.hsmf.datatypes.MessageSubmissionChunk;
import org.apache.poi.hsmf.datatypes.PropertyValue;
import org.apache.poi.hsmf.datatypes.RecipientChunks;
import org.apache.poi.hsmf.datatypes.StringChunk;
import org.apache.poi.hsmf.datatypes.Types;
import org.apache.poi.hsmf.exceptions.ChunkNotFoundException;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.util.CodePageUtil;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.MAPI;
import org.apache.tika.metadata.Message;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.RTFMetadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.html.HtmlEncodingDetector;
import org.apache.tika.parser.html.JSoupParser;
import org.apache.tika.parser.mailcommons.MailDateParser;
import org.apache.tika.parser.microsoft.AbstractPOIFSExtractor;
import org.apache.tika.parser.microsoft.OfficeParserConfig;
import org.apache.tika.parser.microsoft.msg.ExtendedMetadataExtractor;
import org.apache.tika.parser.microsoft.rtf.RTFParser;
import org.apache.tika.parser.txt.CharsetDetector;
import org.apache.tika.parser.txt.CharsetMatch;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class OutlookExtractor
extends AbstractPOIFSExtractor {
    static Logger LOGGER = LoggerFactory.getLogger(OutlookExtractor.class);
    private static final Metadata EMPTY_METADATA = new Metadata();
    private static final MAPIProperty[] LITERAL_TIME_MAPI_PROPERTIES = new MAPIProperty[]{MAPIProperty.CLIENT_SUBMIT_TIME, MAPIProperty.CREATION_TIME, MAPIProperty.DEFERRED_DELIVERY_TIME, MAPIProperty.DELIVER_TIME, MAPIProperty.EXPIRY_TIME, MAPIProperty.LAST_MODIFICATION_TIME, MAPIProperty.LATEST_DELIVERY_TIME, MAPIProperty.MESSAGE_DELIVERY_TIME, MAPIProperty.MESSAGE_DOWNLOAD_TIME, MAPIProperty.ORIGINAL_DELIVERY_TIME, MAPIProperty.ORIGINAL_SUBMIT_TIME, MAPIProperty.PROVIDER_SUBMIT_TIME, MAPIProperty.RECEIPT_TIME, MAPIProperty.REPLY_TIME, MAPIProperty.REPORT_TIME};
    private static final Map<MAPIProperty, Property> LITERAL_TIME_PROPERTIES = new HashMap<MAPIProperty, Property>();
    private static final Map<String, String> MESSAGE_CLASSES = new LinkedHashMap<String, String>();
    private static final Pattern IMG_TAG_PATTERN = Pattern.compile("<img ([^>]{0,1000})>");
    private static final Pattern SRC_ATTR_PATTERN = Pattern.compile("src=\"cid:([^\"]{0,1000})\"");
    private static final Pattern TEXT_CID_PATTERN = Pattern.compile("\\[cid:([^]]{0,1000})]");
    private static Pattern HEADER_KEY_PAT;
    private final MAPIMessage msg;
    private final ParseContext parseContext;
    private final boolean extractAllAlternatives;
    private final boolean extractExtendedMsgProperties;
    HtmlEncodingDetector detector = new HtmlEncodingDetector();

    private static void loadMessageClasses() {
        String fName = "/org/apache/tika/parser/microsoft/msg/mapi_message_classes.properties";
        try (BufferedReader r = new BufferedReader(new InputStreamReader(OutlookExtractor.class.getResourceAsStream(fName), StandardCharsets.UTF_8));){
            String line = r.readLine();
            while (line != null) {
                if (line.isBlank() || line.startsWith("#")) {
                    line = r.readLine();
                    continue;
                }
                String[] cols = line.split("\\s+");
                String lcKey = cols[0].toLowerCase(Locale.ROOT);
                String value = cols[1];
                if (MESSAGE_CLASSES.containsKey(lcKey)) {
                    throw new IllegalArgumentException("Can't have duplicate keys: " + lcKey);
                }
                MESSAGE_CLASSES.put(lcKey, value);
                line = r.readLine();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("can't find mapi_message_classes.properties?!");
        }
    }

    public OutlookExtractor(DirectoryNode root, Metadata metadata, ParseContext context) throws TikaException {
        super(context, metadata);
        this.parseContext = context;
        this.extractAllAlternatives = ((OfficeParserConfig)context.get(OfficeParserConfig.class)).isExtractAllAlternativesFromMSG();
        this.extractExtendedMsgProperties = ((OfficeParserConfig)context.get(OfficeParserConfig.class)).isExtractExtendedMsgProperties();
        try {
            this.msg = new MAPIMessage(root);
        }
        catch (IOException e) {
            throw new TikaException("Failed to parse Outlook message", (Throwable)e);
        }
    }

    public static void addEvenIfNull(Property property, String value, Metadata metadata) {
        if (value == null) {
            value = "";
        }
        metadata.add(property, value);
    }

    private static void setFirstChunk(List<Chunk> chunks, Property property, Metadata metadata) {
        if (chunks == null || chunks.isEmpty() || chunks.get(0) == null) {
            return;
        }
        metadata.set(property, chunks.get(0).toString());
    }

    public static String getNormalizedMessageClass(String messageClass) {
        if (messageClass == null || messageClass.isBlank()) {
            return "UNSPECIFIED";
        }
        String lc = messageClass.toLowerCase(Locale.ROOT);
        if (MESSAGE_CLASSES.containsKey(lc)) {
            return MESSAGE_CLASSES.get(lc);
        }
        return "UNKNOWN";
    }

    public void parse(XHTMLContentHandler xhtml) throws TikaException, SAXException, IOException {
        try {
            this._parse(xhtml);
        }
        catch (ChunkNotFoundException e) {
            throw new TikaException("POI MAPIMessage broken - didn't return null on missing chunk", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void _parse(XHTMLContentHandler xhtml) throws TikaException, SAXException, IOException, ChunkNotFoundException {
        void var9_25;
        void var4_8;
        this.msg.setReturnNullOnMissingChunk(true);
        if (this.msg.has7BitEncodingStrings()) {
            this.guess7BitEncoding(this.msg);
        }
        Map<String, String[]> headers = this.normalizeHeaders(this.msg.getHeaders());
        this.handleFromTo(headers, this.parentMetadata);
        this.handleMessageInfo(this.msg, headers, this.parentMetadata);
        if (this.extractExtendedMsgProperties) {
            ExtendedMetadataExtractor.extract(this.msg, this.parentMetadata);
        }
        try {
            for (String string : this.msg.getRecipientEmailAddressList()) {
                if (string == null) continue;
                this.parentMetadata.add("Message-Recipient-Address", string);
            }
        }
        catch (ChunkNotFoundException chunkNotFoundException) {
            // empty catch block
        }
        for (Map.Entry entry : headers.entrySet()) {
            String headerKey = (String)entry.getKey();
            for (String string : (String[])entry.getValue()) {
                this.parentMetadata.add("Message:Raw-Header:" + headerKey, string);
            }
        }
        this.handleGeneralDates(this.msg, headers, this.parentMetadata);
        this.writeSelectHeadersInBody(this.parentMetadata, this.msg, xhtml);
        Chunk htmlChunk = null;
        Object var4_7 = null;
        Chunk textChunk = null;
        for (Chunk chunk : this.msg.getMainChunks().getChunks()) {
            if (chunk.getChunkId() == MAPIProperty.BODY_HTML.id) {
                htmlChunk = chunk;
            }
            if (chunk.getChunkId() == MAPIProperty.RTF_COMPRESSED.id) {
                Chunk chunk2 = chunk;
            }
            if (chunk.getChunkId() != MAPIProperty.BODY.id) continue;
            textChunk = chunk;
        }
        HashSet<String> hashSet = new HashSet<String>();
        this.handleBodyChunks(htmlChunk, (Chunk)var4_8, textChunk, xhtml, hashSet);
        AttachmentChunks[] attachmentChunksArray = this.msg.getAttachmentFiles();
        int n = attachmentChunksArray.length;
        boolean bl = false;
        while (var9_25 < n) {
            AttachmentChunks attachment = attachmentChunksArray[var9_25];
            Metadata attachMetadata = new Metadata();
            this.updateAttachmentMetadata(attachment, attachMetadata, hashSet);
            String filename = null;
            if (!StringUtils.isBlank((String)attachMetadata.get(MAPI.ATTACH_LONG_FILE_NAME))) {
                filename = attachMetadata.get(MAPI.ATTACH_LONG_FILE_NAME);
            } else if (!StringUtils.isBlank((String)attachMetadata.get(MAPI.ATTACH_DISPLAY_NAME))) {
                filename = attachMetadata.get(MAPI.ATTACH_DISPLAY_NAME);
            } else if (!StringUtils.isBlank((String)attachMetadata.get(MAPI.ATTACH_FILE_NAME))) {
                filename = attachMetadata.get(MAPI.ATTACH_FILE_NAME);
            }
            String mimeType = attachMetadata.get(MAPI.ATTACH_MIME);
            if (attachment.getAttachData() != null) {
                this.handleEmbeddedResource(TikaInputStream.get((byte[])attachment.getAttachData().getValue()), attachMetadata, filename, null, null, mimeType, xhtml, true);
            }
            if (attachment.getAttachmentDirectory() != null) {
                this.handleEmbeddedOfficeDoc((DirectoryEntry)attachment.getAttachmentDirectory().getDirectory(), attachMetadata, filename, xhtml, true);
            }
            ++var9_25;
        }
    }

    private void updateAttachmentMetadata(AttachmentChunks attachment, Metadata metadata, Set<String> contentIdNames) {
        String contentId;
        StringChunk contentIdChunk = attachment.getAttachContentId();
        if (contentIdChunk != null && !StringUtils.isBlank((String)(contentId = contentIdChunk.getValue()))) {
            if (contentIdNames.contains(contentId = contentId.trim())) {
                metadata.set("embeddedResourceType", TikaCoreProperties.EmbeddedResourceType.INLINE.name());
            }
            metadata.set(MAPI.ATTACH_CONTENT_ID, contentId);
        }
        this.addStringChunkToMetadata(MAPI.ATTACH_LONG_PATH_NAME, attachment.getAttachLongPathName(), metadata);
        this.addStringChunkToMetadata(MAPI.ATTACH_LONG_FILE_NAME, attachment.getAttachLongFileName(), metadata);
        this.addStringChunkToMetadata(MAPI.ATTACH_FILE_NAME, attachment.getAttachFileName(), metadata);
        this.addStringChunkToMetadata(MAPI.ATTACH_CONTENT_LOCATION, attachment.getAttachContentLocation(), metadata);
        this.addStringChunkToMetadata(MAPI.ATTACH_DISPLAY_NAME, attachment.getAttachDisplayName(), metadata);
        this.addStringChunkToMetadata(MAPI.ATTACH_EXTENSION, attachment.getAttachExtension(), metadata);
        this.addStringChunkToMetadata(MAPI.ATTACH_MIME, attachment.getAttachMimeTag(), metadata);
        this.addStringChunkToMetadata(MAPI.ATTACH_LANGUAGE, attachment.getAttachLanguage(), metadata);
    }

    private void addStringChunkToMetadata(Property property, StringChunk stringChunk, Metadata metadata) {
        if (stringChunk == null) {
            return;
        }
        String v = stringChunk.getValue();
        if (StringUtils.isBlank((String)v)) {
            return;
        }
        metadata.set(property, v);
    }

    private void handleMessageInfo(MAPIMessage msg, Map<String, String[]> headers, Metadata metadata) throws ChunkNotFoundException {
        List inReplyToIds;
        List internetReferences;
        Chunk chunk;
        String mc;
        metadata.set(TikaCoreProperties.TITLE, msg.getSubject());
        String topic = msg.getConversationTopic();
        metadata.set(TikaCoreProperties.SUBJECT, topic);
        metadata.set(TikaCoreProperties.DESCRIPTION, topic);
        metadata.set(MAPI.CONVERSATION_TOPIC, topic);
        Chunks mainChunks = msg.getMainChunks();
        if (mainChunks == null) {
            return;
        }
        if (mainChunks.getMessageId() != null) {
            metadata.set(MAPI.INTERNET_MESSAGE_ID, mainChunks.getMessageId().getValue());
        }
        if ((mc = msg.getStringFromChunk(mainChunks.getMessageClass())) != null) {
            metadata.set(MAPI.MESSAGE_CLASS_RAW, mc);
        }
        metadata.set(MAPI.MESSAGE_CLASS, OutlookExtractor.getNormalizedMessageClass(mc));
        List conversationIndex = (List)mainChunks.getAll().get(MAPIProperty.CONVERSATION_INDEX);
        if (conversationIndex != null && !conversationIndex.isEmpty() && (chunk = (Chunk)conversationIndex.get(0)) instanceof ByteChunk) {
            Object bytes = ((ByteChunk)chunk).getValue();
            String hex = Hex.encodeHexString((byte[])bytes);
            metadata.set(MAPI.CONVERSATION_INDEX, hex);
        }
        if ((internetReferences = (List)mainChunks.getAll().get(MAPIProperty.INTERNET_REFERENCES)) != null) {
            for (Object ref : internetReferences) {
                if (!(ref instanceof StringChunk)) continue;
                metadata.add(MAPI.INTERNET_REFERENCES, ((StringChunk)ref).getValue());
            }
        }
        if ((inReplyToIds = (List)mainChunks.getAll().get(MAPIProperty.IN_REPLY_TO_ID)) != null && !inReplyToIds.isEmpty()) {
            metadata.add(MAPI.IN_REPLY_TO_ID, ((Chunk)inReplyToIds.get(0)).toString());
        }
        for (Map.Entry entry : LITERAL_TIME_PROPERTIES.entrySet()) {
            List timeProp = (List)mainChunks.getProperties().get(entry.getKey());
            if (timeProp == null || timeProp.isEmpty()) continue;
            Calendar cal = ((PropertyValue.TimePropertyValue)timeProp.get(0)).getValue();
            metadata.set((Property)entry.getValue(), cal);
        }
        MessageSubmissionChunk messageSubmissionChunk = mainChunks.getSubmissionChunk();
        if (messageSubmissionChunk != null) {
            String string = messageSubmissionChunk.getSubmissionId();
            metadata.set(MAPI.SUBMISSION_ID, string);
            metadata.set(MAPI.SUBMISSION_ACCEPTED_AT_TIME, messageSubmissionChunk.getAcceptedAtTime());
        }
    }

    private void handleGeneralDates(MAPIMessage msg, Map<String, String[]> headers, Metadata metadata) throws ChunkNotFoundException {
        if (msg.getMessageDate() != null) {
            metadata.set(TikaCoreProperties.CREATED, msg.getMessageDate().getTime());
            metadata.set(TikaCoreProperties.MODIFIED, msg.getMessageDate().getTime());
        } else if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String[]> header : headers.entrySet()) {
                String headerKey = header.getKey();
                if (!headerKey.toLowerCase(Locale.ROOT).startsWith("date:")) continue;
                String date = headerKey.substring(headerKey.indexOf(58) + 1).trim();
                try {
                    Date d = MailDateParser.parseDateLenient((String)date);
                    metadata.set(TikaCoreProperties.CREATED, d);
                    metadata.set(TikaCoreProperties.MODIFIED, d);
                    break;
                }
                catch (SecurityException e) {
                    throw e;
                }
                catch (Exception e) {
                    metadata.set(TikaCoreProperties.CREATED, date);
                    metadata.set(TikaCoreProperties.MODIFIED, date);
                    break;
                }
            }
        }
        List timeProp = (List)msg.getMainChunks().getProperties().get(MAPIProperty.LAST_MODIFICATION_TIME);
        if (timeProp != null && !timeProp.isEmpty()) {
            Calendar cal = ((PropertyValue.TimePropertyValue)timeProp.get(0)).getValue();
            metadata.set(TikaCoreProperties.MODIFIED, cal);
        }
    }

    private void handleBodyChunks(Chunk htmlChunk, Chunk rtfChunk, Chunk textChunk, XHTMLContentHandler xhtml, Set<String> contentIdNames) throws SAXException, IOException, TikaException {
        if (this.extractAllAlternatives) {
            this.extractAllAlternatives(htmlChunk, rtfChunk, textChunk, xhtml, contentIdNames);
            return;
        }
        this._handleBestBodyChunk(htmlChunk, rtfChunk, textChunk, xhtml, contentIdNames);
    }

    private void _handleBestBodyChunk(Chunk htmlChunk, Chunk rtfChunk, Chunk textChunk, XHTMLContentHandler xhtml, Set<String> contentIdNames) throws SAXException, IOException, TikaException {
        ByteChunk chunk;
        if (htmlChunk != null) {
            byte[] data = null;
            if (htmlChunk instanceof ByteChunk) {
                data = ((ByteChunk)htmlChunk).getValue();
            } else if (htmlChunk instanceof StringChunk) {
                data = ((StringChunk)htmlChunk).getRawValue();
            }
            if (data != null) {
                Parser htmlParser = EmbeddedDocumentUtil.tryToFindExistingLeafParser(JSoupParser.class, (ParseContext)this.parseContext);
                if (htmlParser == null) {
                    htmlParser = new JSoupParser();
                }
                Metadata htmlMetadata = new Metadata();
                try (TikaInputStream tis = TikaInputStream.get((byte[])data);){
                    htmlParser.parse((InputStream)tis, (ContentHandler)new EmbeddedContentHandler((ContentHandler)new BodyContentHandler((ContentHandler)xhtml)), htmlMetadata, this.parseContext);
                }
                this.extractContentIdNamesFromHtml(data, htmlMetadata, contentIdNames);
                this.parentMetadata.add(MAPI.BODY_TYPES_PROCESSED, BODY_TYPES_PROCESSED.HTML.name());
                return;
            }
        }
        if (rtfChunk != null && (chunk = (ByteChunk)rtfChunk).getValue() != null && chunk.getValue().length > 0) {
            MAPIRtfAttribute rtf = new MAPIRtfAttribute(MAPIProperty.RTF_COMPRESSED, Types.BINARY.getId(), chunk.getValue());
            RTFParser rtfParser = (RTFParser)EmbeddedDocumentUtil.tryToFindExistingLeafParser(RTFParser.class, (ParseContext)this.parseContext);
            if (rtfParser == null) {
                rtfParser = new RTFParser();
            }
            Metadata rtfMetadata = new Metadata();
            try (TikaInputStream tis = TikaInputStream.get((byte[])rtf.getData());){
                rtfParser.parseInline((InputStream)tis, (ContentHandler)xhtml, rtfMetadata, this.parseContext);
            }
            this.extractContentIdNamesFromRtf(rtf.getData(), rtfMetadata, contentIdNames);
            this.parentMetadata.add(MAPI.BODY_TYPES_PROCESSED, BODY_TYPES_PROCESSED.RTF.name());
            this.parentMetadata.set(RTFMetadata.CONTAINS_ENCAPSULATED_HTML, rtfMetadata.get(RTFMetadata.CONTAINS_ENCAPSULATED_HTML));
            return;
        }
        if (textChunk != null) {
            String s = ((StringChunk)textChunk).getValue();
            xhtml.element("p", s);
            this.extractContentIdNamesFromText(s, contentIdNames);
            this.parentMetadata.add(MAPI.BODY_TYPES_PROCESSED, BODY_TYPES_PROCESSED.TEXT.name());
        }
    }

    private void extractContentIdNamesFromRtf(byte[] data, Metadata metadata, Set<String> contentIdNames) {
        this.extractContentIdNamesFromHtml(data, metadata, contentIdNames);
    }

    private void extractContentIdNamesFromHtml(byte[] data, Metadata metadata, Set<String> contentIdNames) {
        String html = new String(data, StandardCharsets.UTF_8);
        Matcher imageMatcher = IMG_TAG_PATTERN.matcher(html);
        Matcher cidSrcMatcher = SRC_ATTR_PATTERN.matcher("");
        while (imageMatcher.find()) {
            String imgElementContents = imageMatcher.group(1);
            cidSrcMatcher.reset(imgElementContents);
            while (cidSrcMatcher.find()) {
                String cid = cidSrcMatcher.group(1);
                cid = cid.trim();
                contentIdNames.add(cid);
            }
        }
    }

    private void extractContentIdNamesFromText(String s, Set<String> contentIdNames) {
        Matcher m = TEXT_CID_PATTERN.matcher(s);
        while (m.find()) {
            contentIdNames.add(m.group(1));
        }
    }

    private void extractAllAlternatives(Chunk htmlChunk, Chunk rtfChunk, Chunk textChunk, XHTMLContentHandler xhtml, Set<String> contentIdNames) throws TikaException, SAXException, IOException {
        byte[] data;
        if (htmlChunk != null && (data = this.getValue(htmlChunk)) != null) {
            this.handleEmbeddedResource(TikaInputStream.get((byte[])data), "html-body", null, MediaType.TEXT_HTML.toString(), xhtml, true);
            this.extractContentIdNamesFromHtml(data, new Metadata(), contentIdNames);
            this.parentMetadata.add(MAPI.BODY_TYPES_PROCESSED, BODY_TYPES_PROCESSED.HTML.name());
        }
        if (rtfChunk != null) {
            ByteChunk chunk = (ByteChunk)rtfChunk;
            MAPIRtfAttribute rtf = new MAPIRtfAttribute(MAPIProperty.RTF_COMPRESSED, Types.BINARY.getId(), chunk.getValue());
            byte[] data2 = rtf.getData();
            if (data2 != null) {
                Metadata rtfMetadata = new Metadata();
                this.handleEmbeddedResource(TikaInputStream.get((byte[])data2), rtfMetadata, "rtf-body", null, null, "application/rtf", xhtml, true);
                this.extractContentIdNamesFromRtf(data2, rtfMetadata, contentIdNames);
                this.parentMetadata.add(MAPI.BODY_TYPES_PROCESSED, BODY_TYPES_PROCESSED.RTF.name());
                this.parentMetadata.set(RTFMetadata.CONTAINS_ENCAPSULATED_HTML, rtfMetadata.get(RTFMetadata.CONTAINS_ENCAPSULATED_HTML));
            }
        }
        if (textChunk != null && (data = this.getValue(textChunk)) != null) {
            Metadata chunkMetadata = new Metadata();
            chunkMetadata.set(TikaCoreProperties.CONTENT_TYPE_PARSER_OVERRIDE, MediaType.TEXT_PLAIN.toString());
            this.handleEmbeddedResource(TikaInputStream.get((byte[])data), chunkMetadata, null, "text-body", null, MediaType.TEXT_PLAIN.toString(), xhtml, true);
            if (textChunk instanceof StringChunk) {
                this.extractContentIdNamesFromText(((StringChunk)textChunk).getValue(), contentIdNames);
            }
            this.parentMetadata.add(MAPI.BODY_TYPES_PROCESSED, BODY_TYPES_PROCESSED.TEXT.name());
        }
    }

    private byte[] getValue(Chunk chunk) {
        byte[] data = null;
        if (chunk instanceof ByteChunk) {
            data = ((ByteChunk)chunk).getValue();
        } else if (chunk instanceof StringChunk) {
            data = ((StringChunk)chunk).getRawValue();
        }
        return data;
    }

    private void handleFromTo(Map<String, String[]> headers, Metadata metadata) throws ChunkNotFoundException {
        String from = this.msg.getDisplayFrom();
        metadata.set(TikaCoreProperties.CREATOR, from);
        metadata.set("Message-From", from);
        metadata.set("Message-To", this.msg.getDisplayTo());
        metadata.set("Message-Cc", this.msg.getDisplayCC());
        metadata.set("Message-Bcc", this.msg.getDisplayBCC());
        Chunks chunks = this.msg.getMainChunks();
        StringChunk sentByServerType = chunks.getSentByServerType();
        if (sentByServerType != null) {
            metadata.set(MAPI.SENT_BY_SERVER_TYPE, sentByServerType.getValue());
        }
        Map mainChunks = this.msg.getMainChunks().getAll();
        List senderAddresType = (List)mainChunks.get(MAPIProperty.SENDER_ADDRTYPE);
        String senderAddressTypeString = "";
        if (senderAddresType != null && senderAddresType.size() > 0) {
            senderAddressTypeString = ((Chunk)senderAddresType.get(0)).toString();
        }
        OutlookExtractor.setFirstChunk((List)mainChunks.get(MAPIProperty.SENDER_NAME), Message.MESSAGE_FROM_NAME, metadata);
        OutlookExtractor.setFirstChunk((List)mainChunks.get(MAPIProperty.SENT_REPRESENTING_NAME), MAPI.FROM_REPRESENTING_NAME, metadata);
        OutlookExtractor.setFirstChunk((List)mainChunks.get(MAPIProperty.SENDER_EMAIL_ADDRESS), Message.MESSAGE_FROM_EMAIL, metadata);
        OutlookExtractor.setFirstChunk((List)mainChunks.get(MAPIProperty.SENT_REPRESENTING_EMAIL_ADDRESS), MAPI.FROM_REPRESENTING_EMAIL, metadata);
        for (Recipient recipient : this.buildRecipients()) {
            switch (recipient.recipientType) {
                case TO: {
                    OutlookExtractor.addEvenIfNull(Message.MESSAGE_TO_NAME, recipient.name, metadata);
                    OutlookExtractor.addEvenIfNull(Message.MESSAGE_TO_DISPLAY_NAME, recipient.displayName, metadata);
                    OutlookExtractor.addEvenIfNull(Message.MESSAGE_TO_EMAIL, recipient.emailAddress, metadata);
                    break;
                }
                case CC: {
                    OutlookExtractor.addEvenIfNull(Message.MESSAGE_CC_NAME, recipient.name, metadata);
                    OutlookExtractor.addEvenIfNull(Message.MESSAGE_CC_DISPLAY_NAME, recipient.displayName, metadata);
                    OutlookExtractor.addEvenIfNull(Message.MESSAGE_CC_EMAIL, recipient.emailAddress, metadata);
                    break;
                }
                case BCC: {
                    OutlookExtractor.addEvenIfNull(Message.MESSAGE_BCC_NAME, recipient.name, metadata);
                    OutlookExtractor.addEvenIfNull(Message.MESSAGE_BCC_DISPLAY_NAME, recipient.displayName, metadata);
                    OutlookExtractor.addEvenIfNull(Message.MESSAGE_BCC_EMAIL, recipient.emailAddress, metadata);
                    break;
                }
            }
        }
    }

    private Map<String, String[]> normalizeHeaders(String[] rows) {
        LinkedHashMap<String, String[]> ret = new LinkedHashMap<String, String[]>();
        if (rows == null) {
            return ret;
        }
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<String, List> headers = new LinkedHashMap<String, List>();
        Matcher headerKeyMatcher = HEADER_KEY_PAT.matcher("");
        String lastKey = null;
        int consec = 0;
        for (String row : rows) {
            headerKeyMatcher.reset(row);
            if (headerKeyMatcher.find()) {
                if (lastKey != null) {
                    List vals = (List)headers.get(lastKey);
                    vals = vals == null ? new ArrayList() : vals;
                    vals.add(this.decodeHeader(sb.toString()));
                    headers.put(lastKey, vals);
                }
                sb.setLength(0);
                lastKey = headerKeyMatcher.group(1).trim();
                sb.append(headerKeyMatcher.group(2).trim());
                consec = 0;
            } else {
                if (consec > 0) {
                    sb.append("\n");
                }
                sb.append(row);
            }
            ++consec;
        }
        if (sb.length() > 0 && lastKey != null) {
            List vals = (List)headers.get(lastKey);
            vals = vals == null ? new ArrayList() : vals;
            vals.add(this.decodeHeader(sb.toString()));
            headers.put(lastKey, vals);
        }
        for (Map.Entry entry : headers.entrySet()) {
            ret.put((String)entry.getKey(), ((List)entry.getValue()).toArray(new String[0]));
        }
        return ret;
    }

    private String decodeHeader(String header) {
        return DecoderUtil.decodeEncodedWords((String)header, (DecodeMonitor)DecodeMonitor.SILENT);
    }

    private void header(XHTMLContentHandler xhtml, String key, String value) throws SAXException {
        if (value != null && value.length() > 0) {
            xhtml.element("dt", key);
            xhtml.element("dd", value);
        }
    }

    private void guess7BitEncoding(MAPIMessage msg) {
        Chunks mainChunks;
        block16: {
            mainChunks = msg.getMainChunks();
            if (mainChunks == null) {
                return;
            }
            Map props = mainChunks.getProperties();
            if (props != null) {
                for (MAPIProperty prop : new MAPIProperty[]{MAPIProperty.MESSAGE_CODEPAGE, MAPIProperty.INTERNET_CPID}) {
                    List val = (List)props.get(prop);
                    if (val == null || val.size() <= 0) continue;
                    int codepage = ((PropertyValue.LongPropertyValue)val.get(0)).getValue();
                    String encoding = null;
                    try {
                        encoding = CodePageUtil.codepageToEncoding((int)codepage, (boolean)true);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    if (!this.tryToSet7BitEncoding(msg, encoding)) continue;
                    return;
                }
            }
            try {
                String[] headers = msg.getHeaders();
                if (headers != null && headers.length > 0) {
                    Pattern p = Pattern.compile("Content-Type:.*?charset=[\"']?([^;'\"]+)[\"']?", 2);
                    for (String header : headers) {
                        String charset;
                        Matcher m;
                        if (!header.startsWith("Content-Type") || !(m = p.matcher(header)).matches() || !this.tryToSet7BitEncoding(msg, charset = m.group(1))) continue;
                        return;
                    }
                }
            }
            catch (ChunkNotFoundException headers) {
                // empty catch block
            }
            try {
                String html = msg.getHtmlBody();
                if (html == null || html.length() <= 0) break block16;
                Charset charset = null;
                try {
                    charset = this.detector.detect((InputStream)UnsynchronizedByteArrayInputStream.builder().setByteArray(html.getBytes(StandardCharsets.UTF_8)).get(), EMPTY_METADATA);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (charset != null && this.tryToSet7BitEncoding(msg, charset.name())) {
                    return;
                }
            }
            catch (ChunkNotFoundException html) {
                // empty catch block
            }
        }
        StringChunk text = mainChunks.getTextBodyChunk();
        if (text != null) {
            CharsetDetector detector = new CharsetDetector();
            detector.setText(text.getRawValue());
            CharsetMatch match = detector.detect();
            if (match != null && match.getConfidence() > 35 && this.tryToSet7BitEncoding(msg, match.getName())) {
                return;
            }
        }
    }

    private boolean tryToSet7BitEncoding(MAPIMessage msg, String charsetName) {
        if (charsetName == null) {
            return false;
        }
        if (charsetName.equalsIgnoreCase("utf-8")) {
            return false;
        }
        try {
            if (Charset.isSupported(charsetName)) {
                msg.set7BitEncoding(charsetName);
                return true;
            }
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    private void writeSelectHeadersInBody(Metadata metadata, MAPIMessage msg, XHTMLContentHandler xhtml) throws SAXException, ChunkNotFoundException {
        if (!this.officeParserConfig.isWriteSelectHeadersInBody()) {
            return;
        }
        String subject = metadata.get(TikaCoreProperties.TITLE);
        subject = subject == null ? "" : subject;
        xhtml.element("h1", subject);
        xhtml.startElement("dl");
        String from = metadata.get("Message-From");
        if (from != null) {
            this.header(xhtml, "From", from);
        }
        this.header(xhtml, "To", msg.getDisplayTo());
        this.header(xhtml, "Cc", msg.getDisplayCC());
        this.header(xhtml, "Bcc", msg.getDisplayBCC());
        try {
            this.header(xhtml, "Recipients", msg.getRecipientEmailAddress());
        }
        catch (ChunkNotFoundException chunkNotFoundException) {
            // empty catch block
        }
        xhtml.endElement("dl");
    }

    private List<Recipient> buildRecipients() {
        RecipientChunks[] recipientChunks = this.msg.getRecipientDetailsChunks();
        if (recipientChunks == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<Recipient> recipients = new LinkedList<Recipient>();
        for (RecipientChunks chunks : recipientChunks) {
            Object val;
            Recipient r = new Recipient();
            r.displayName = chunks.getRecipientDisplayNameChunk() != null ? chunks.getRecipientDisplayNameChunk().toString() : null;
            r.name = chunks.getRecipientNameChunk() != null ? chunks.getRecipientNameChunk().toString() : null;
            r.emailAddress = chunks.getRecipientEmailAddress();
            List vals = (List)chunks.getProperties().get(MAPIProperty.RECIPIENT_TYPE);
            RECIPIENT_TYPE recipientType = RECIPIENT_TYPE.UNSPECIFIED;
            if (vals != null && vals.size() > 0 && (val = ((PropertyValue)vals.get(0)).getValue()) instanceof Integer) {
                recipientType = RECIPIENT_TYPE.getTypeFromVal((Integer)val);
            }
            r.recipientType = recipientType;
            vals = (List)chunks.getProperties().get(MAPIProperty.ADDRTYPE);
            if (vals != null && vals.size() > 0 && (val = ((PropertyValue)vals.get(0)).toString()) != null) {
                if (((String)(val = ((String)val).toLowerCase(Locale.US))).equals("ex")) {
                    r.addressType = ADDRESS_TYPE.EX;
                } else if (((String)val).equals("smtp")) {
                    r.addressType = ADDRESS_TYPE.SMTP;
                }
            }
            recipients.add(r);
        }
        return recipients;
    }

    static {
        for (MAPIProperty property : LITERAL_TIME_MAPI_PROPERTIES) {
            Object name = property.mapiProperty.toLowerCase(Locale.ROOT);
            name = ((String)name).substring(3);
            name = ((String)name).replace('_', '-');
            name = "mapi:" + (String)name;
            Property tikaProp = Property.internalDate((String)name);
            LITERAL_TIME_PROPERTIES.put(property, tikaProp);
        }
        OutlookExtractor.loadMessageClasses();
        HEADER_KEY_PAT = Pattern.compile("\\A([\\x21-\\x39\\x3B-\\x7E]+):(.*?)\\Z");
    }

    private static class Recipient {
        String name;
        String displayName;
        RECIPIENT_TYPE recipientType;
        String emailAddress;
        ADDRESS_TYPE addressType;

        private Recipient() {
        }
    }

    private static enum ADDRESS_TYPE {
        EX,
        SMTP;

    }

    public static enum RECIPIENT_TYPE {
        TO(1),
        CC(2),
        BCC(3),
        UNRECOGNIZED(-1),
        UNSPECIFIED(-1);

        private final int val;

        private RECIPIENT_TYPE(int val) {
            this.val = val;
        }

        public static RECIPIENT_TYPE getTypeFromVal(int val) {
            if (val > 0 && val < 4) {
                return RECIPIENT_TYPE.values()[val - 1];
            }
            return UNRECOGNIZED;
        }
    }

    public static enum BODY_TYPES_PROCESSED {
        HTML,
        RTF,
        TEXT;

    }
}

