/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkGaborImageSource_h
#define sitkGaborImageSource_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageSourceTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class GaborImageSource
\brief Generate an n-dimensional image of a Gabor filter.

GaborImageSource generates an image of either the real (i.e. symmetric) or complex (i.e. antisymmetric) part of the Gabor filter with the orientation directed along the x-axis. The GaborKernelFunction is used to evaluate the contribution along the x-axis whereas a non-normalized 1-D Gaussian envelope provides the contribution in each of the remaining N dimensions. Orientation can be manipulated via the Transform classes of the toolkit.

The output image may be of any dimension.

This implementation was contributed as a paper to the Insight Journal https://doi.org/10.54294/dhogdz
\sa itk::simple::GaborSource for the procedural interface
\sa itk::GaborImageSource for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT GaborImageSource : public ImageFilter {
    public:
      using Self = GaborImageSource;

      /** Destructor */
      virtual ~GaborImageSource();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      GaborImageSource();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;



\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOutputPixelType ( PixelIDValueEnum OutputPixelType ) { this->m_OutputPixelType = OutputPixelType; return *this; }

      /**
       */
      PixelIDValueEnum GetOutputPixelType() const { return this->m_OutputPixelType; }\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSize ( std::vector<unsigned int> Size ) { this->m_Size = std::move(Size); return *this; }

      /**
       */
      std::vector<unsigned int> GetSize() const { return this->m_Size; }\

      /**
       * Set/Get the standard deviation in each direction.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSigma ( std::vector<double> Sigma ) { this->m_Sigma = std::move(Sigma); return *this; }

      /** Set the values of the Sigma vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetSigma( double value ) { this->m_Sigma = std::vector<double>(3, value); return *this; }

      /**
       * Set/Get the standard deviation in each direction.
       */
      std::vector<double> GetSigma() const { return this->m_Sigma; }\

      /**
       * Set/Get the mean in each direction.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetMean ( std::vector<double> Mean ) { this->m_Mean = std::move(Mean); return *this; }

      /** Set the values of the Mean vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetMean( double value ) { this->m_Mean = std::vector<double>(3, value); return *this; }

      /**
       * Set/Get the mean in each direction.
       */
      std::vector<double> GetMean() const { return this->m_Mean; }\

      /**
       * Set/Get the modulation frequency of the sine or cosine component.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetFrequency ( double Frequency ) { this->m_Frequency = Frequency; return *this; }

      /**
       * Set/Get the modulation frequency of the sine or cosine component.
       */
      double GetFrequency() const { return this->m_Frequency; }\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOrigin ( std::vector<double> Origin ) { this->m_Origin = std::move(Origin); return *this; }

      /**
       */
      std::vector<double> GetOrigin() const { return this->m_Origin; }\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSpacing ( std::vector<double> Spacing ) { this->m_Spacing = std::move(Spacing); return *this; }

      /**
       */
      std::vector<double> GetSpacing() const { return this->m_Spacing; }\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetDirection ( std::vector<double> Direction ) { this->m_Direction = Direction; return *this; }

      /**
       */
      std::vector<double> GetDirection() const { return this->m_Direction; }

      /** Name of this class */
      std::string GetName() const { return std::string ("GaborImageSource"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute (  );


    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)(  );
      template <class TImageType> Image ExecuteInternal (  );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      PixelIDValueEnum  m_OutputPixelType{itk::simple::sitkFloat32};

      std::vector<unsigned int>  m_Size{std::vector<unsigned int>(3, 64)};

      std::vector<double>  m_Sigma{std::vector<double>(3, 16.0)};

      std::vector<double>  m_Mean{std::vector<double>(3, 32.0)};

      double  m_Frequency{0.4};

      std::vector<double>  m_Origin{std::vector<double>(3, 0.0)};

      std::vector<double>  m_Spacing{std::vector<double>(3, 1.0)};

      /* Passing a zero sized array, defaults to identiy matrix. The size of the array must exactly match the direction matrix for the dimension of the image. */
      std::vector<double>  m_Direction{std::vector<double>()};





    };



   /**
     * \brief Generate an n-dimensional image of a Gabor filter.
     *
     * This function directly calls the execute method of GaborImageSource
     * in order to support a procedural API
     *
     * \sa itk::simple::GaborImageSource for the object oriented interface
     */
SITKBasicFilters_EXPORT Image GaborSource ( PixelIDValueEnum outputPixelType = itk::simple::sitkFloat32, std::vector<unsigned int> size = std::vector<unsigned int>(3, 64), std::vector<double> sigma = std::vector<double>(3, 16.0), std::vector<double> mean = std::vector<double>(3, 32.0), double frequency = 0.4, std::vector<double> origin = std::vector<double>(3, 0.0), std::vector<double> spacing = std::vector<double>(3, 1.0), std::vector<double> direction = std::vector<double>() );
}
#endif
