/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import org.apache.tomcat.dbcp.dbcp2.PoolingConnection;

public class PStmtKey {
    private static final StatementBuilder CallConcurrency = (connection, pStmtKey) -> connection.prepareCall(pStmtKey.sql, pStmtKey.resultSetType, pStmtKey.resultSetConcurrency);
    private static final StatementBuilder CallHoldability = (connection, pStmtKey) -> connection.prepareCall(pStmtKey.sql, pStmtKey.resultSetType, pStmtKey.resultSetConcurrency, pStmtKey.resultSetHoldability);
    private static final StatementBuilder CallSQL = (connection, pStmtKey) -> connection.prepareCall(pStmtKey.sql);
    private static final StatementBuilder StatementAutoGeneratedKeys = (connection, pStmtKey) -> connection.prepareStatement(pStmtKey.sql, pStmtKey.autoGeneratedKeys);
    private static final StatementBuilder StatementColumnIndexes = (connection, pStmtKey) -> connection.prepareStatement(pStmtKey.sql, pStmtKey.columnIndexes);
    private static final StatementBuilder StatementColumnNames = (connection, pStmtKey) -> connection.prepareStatement(pStmtKey.sql, pStmtKey.columnNames);
    private static final StatementBuilder StatementConcurrency = (connection, pStmtKey) -> connection.prepareStatement(pStmtKey.sql, pStmtKey.resultSetType, pStmtKey.resultSetConcurrency);
    private static final StatementBuilder StatementHoldability = (connection, pStmtKey) -> connection.prepareStatement(pStmtKey.sql, pStmtKey.resultSetType, pStmtKey.resultSetConcurrency, pStmtKey.resultSetHoldability);
    private static final StatementBuilder StatementSQL = (connection, pStmtKey) -> connection.prepareStatement(pStmtKey.sql);
    private final String sql;
    private final Integer resultSetType;
    private final Integer resultSetConcurrency;
    private final Integer resultSetHoldability;
    private final String catalog;
    private final String schema;
    private final Integer autoGeneratedKeys;
    private final int[] columnIndexes;
    private final String[] columnNames;
    private final transient StatementBuilder statementBuilder;
    private final PoolingConnection.StatementType statementType;

    private static StatementBuilder match(PoolingConnection.StatementType statementType, StatementBuilder statementBuilder, StatementBuilder statementBuilder2) {
        switch (Objects.requireNonNull(statementType, "statementType")) {
            case PREPARED_STATEMENT: {
                return statementBuilder;
            }
            case CALLABLE_STATEMENT: {
                return statementBuilder2;
            }
        }
        throw new IllegalArgumentException(statementType.toString());
    }

    @Deprecated
    public PStmtKey(String string) {
        this(string, null, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    @Deprecated
    public PStmtKey(String string, int n, int n2) {
        this(string, null, n, n2, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    @Deprecated
    public PStmtKey(String string, String string2) {
        this(string, string2, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    @Deprecated
    public PStmtKey(String string, String string2, int n) {
        this(string, string2, PoolingConnection.StatementType.PREPARED_STATEMENT, (Integer)n);
    }

    @Deprecated
    public PStmtKey(String string, String string2, int n, int n2) {
        this(string, string2, n, n2, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    @Deprecated
    public PStmtKey(String string, String string2, int n, int n2, int n3) {
        this(string, string2, n, n2, n3, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    @Deprecated
    public PStmtKey(String string, String string2, int n, int n2, int n3, PoolingConnection.StatementType statementType) {
        this(string, string2, null, (Integer)n, (Integer)n2, (Integer)n3, null, null, null, statementType, (PStmtKey pStmtKey) -> PStmtKey.match(statementType, StatementHoldability, CallHoldability));
    }

    @Deprecated
    public PStmtKey(String string, String string2, int n, int n2, PoolingConnection.StatementType statementType) {
        this(string, string2, null, (Integer)n, (Integer)n2, null, null, null, null, statementType, (PStmtKey pStmtKey) -> PStmtKey.match(statementType, StatementConcurrency, CallConcurrency));
    }

    @Deprecated
    public PStmtKey(String string, String string2, int[] nArray) {
        this(string, string2, null, null, null, null, null, nArray, null, PoolingConnection.StatementType.PREPARED_STATEMENT, StatementColumnIndexes);
    }

    @Deprecated
    public PStmtKey(String string, String string2, PoolingConnection.StatementType statementType) {
        this(string, string2, null, null, null, null, null, null, null, statementType, (PStmtKey pStmtKey) -> PStmtKey.match(statementType, StatementSQL, CallSQL));
    }

    @Deprecated
    public PStmtKey(String string, String string2, PoolingConnection.StatementType statementType, Integer n) {
        this(string, string2, null, null, null, null, n, null, null, statementType, (PStmtKey pStmtKey) -> PStmtKey.match(statementType, StatementAutoGeneratedKeys, CallSQL));
    }

    public PStmtKey(String string, String string2, String string3) {
        this(string, string2, string3, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    public PStmtKey(String string, String string2, String string3, int n) {
        this(string, string2, string3, PoolingConnection.StatementType.PREPARED_STATEMENT, (Integer)n);
    }

    public PStmtKey(String string, String string2, String string3, int n, int n2) {
        this(string, string2, string3, n, n2, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    public PStmtKey(String string, String string2, String string3, int n, int n2, int n3) {
        this(string, string2, string3, n, n2, n3, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    public PStmtKey(String string, String string2, String string3, int n, int n2, int n3, PoolingConnection.StatementType statementType) {
        this(string, string2, string3, (Integer)n, (Integer)n2, (Integer)n3, null, null, null, statementType, (PStmtKey pStmtKey) -> PStmtKey.match(statementType, StatementHoldability, CallHoldability));
    }

    public PStmtKey(String string, String string2, String string3, int n, int n2, PoolingConnection.StatementType statementType) {
        this(string, string2, string3, (Integer)n, (Integer)n2, null, null, null, null, statementType, (PStmtKey pStmtKey) -> PStmtKey.match(statementType, StatementConcurrency, CallConcurrency));
    }

    public PStmtKey(String string, String string2, String string3, int[] nArray) {
        this(string, string2, string3, null, null, null, null, nArray, null, PoolingConnection.StatementType.PREPARED_STATEMENT, StatementColumnIndexes);
    }

    private PStmtKey(String string, String string2, String string3, Integer n, Integer n2, Integer n3, Integer n4, int[] nArray, String[] stringArray, PoolingConnection.StatementType statementType, Function<PStmtKey, StatementBuilder> function) {
        this.sql = Objects.requireNonNull(string, "sql").trim();
        this.catalog = string2;
        this.schema = string3;
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        this.resultSetHoldability = n3;
        this.autoGeneratedKeys = n4;
        this.columnIndexes = this.clone(nArray);
        this.columnNames = this.clone(stringArray);
        this.statementBuilder = Objects.requireNonNull(Objects.requireNonNull(function, "statementBuilder").apply(this), "statementBuilder");
        this.statementType = statementType;
    }

    private PStmtKey(String string, String string2, String string3, Integer n, Integer n2, Integer n3, Integer n4, int[] nArray, String[] stringArray, PoolingConnection.StatementType statementType, StatementBuilder statementBuilder) {
        this.sql = string;
        this.catalog = string2;
        this.schema = string3;
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        this.resultSetHoldability = n3;
        this.autoGeneratedKeys = n4;
        this.columnIndexes = this.clone(nArray);
        this.columnNames = this.clone(stringArray);
        this.statementBuilder = Objects.requireNonNull(statementBuilder, "statementBuilder");
        this.statementType = statementType;
    }

    public PStmtKey(String string, String string2, String string3, PoolingConnection.StatementType statementType) {
        this(string, string2, string3, null, null, null, null, null, null, statementType, (PStmtKey pStmtKey) -> PStmtKey.match(statementType, StatementSQL, CallSQL));
    }

    public PStmtKey(String string, String string2, String string3, PoolingConnection.StatementType statementType, Integer n) {
        this(string, string2, string3, null, null, null, n, null, null, statementType, (PStmtKey pStmtKey) -> PStmtKey.match(statementType, StatementAutoGeneratedKeys, CallSQL));
    }

    public PStmtKey(String string, String string2, String string3, String[] stringArray) {
        this(string, string2, string3, null, null, null, null, null, stringArray, PoolingConnection.StatementType.PREPARED_STATEMENT, StatementColumnNames);
    }

    @Deprecated
    public PStmtKey(String string, String string2, String[] stringArray) {
        this(string, string2, null, null, null, null, null, null, stringArray, PoolingConnection.StatementType.PREPARED_STATEMENT, StatementColumnNames);
    }

    private int[] clone(int[] nArray) {
        return nArray == null ? null : (int[])nArray.clone();
    }

    private String[] clone(String[] stringArray) {
        return stringArray == null ? null : (String[])stringArray.clone();
    }

    public Statement createStatement(Connection connection) throws SQLException {
        return this.statementBuilder.createStatement(connection, this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PStmtKey pStmtKey = (PStmtKey)object;
        if (!Objects.equals(this.autoGeneratedKeys, pStmtKey.autoGeneratedKeys)) {
            return false;
        }
        if (!Objects.equals(this.catalog, pStmtKey.catalog)) {
            return false;
        }
        if (!Arrays.equals(this.columnIndexes, pStmtKey.columnIndexes)) {
            return false;
        }
        if (!Arrays.equals(this.columnNames, pStmtKey.columnNames)) {
            return false;
        }
        if (!Objects.equals(this.resultSetConcurrency, pStmtKey.resultSetConcurrency)) {
            return false;
        }
        if (!Objects.equals(this.resultSetHoldability, pStmtKey.resultSetHoldability)) {
            return false;
        }
        if (!Objects.equals(this.resultSetType, pStmtKey.resultSetType)) {
            return false;
        }
        if (!Objects.equals(this.schema, pStmtKey.schema)) {
            return false;
        }
        if (!Objects.equals(this.sql, pStmtKey.sql)) {
            return false;
        }
        return this.statementType == pStmtKey.statementType;
    }

    public Integer getAutoGeneratedKeys() {
        return this.autoGeneratedKeys;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public int[] getColumnIndexes() {
        return this.clone(this.columnIndexes);
    }

    public String[] getColumnNames() {
        return this.clone(this.columnNames);
    }

    public Integer getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public Integer getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public Integer getResultSetType() {
        return this.resultSetType;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getSql() {
        return this.sql;
    }

    public PoolingConnection.StatementType getStmtType() {
        return this.statementType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autoGeneratedKeys, this.catalog, Arrays.hashCode(this.columnIndexes), Arrays.hashCode(this.columnNames), this.resultSetConcurrency, this.resultSetHoldability, this.resultSetType, this.schema, this.sql, this.statementType});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PStmtKey: sql=");
        stringBuilder.append(this.sql);
        stringBuilder.append(", catalog=");
        stringBuilder.append(this.catalog);
        stringBuilder.append(", schema=");
        stringBuilder.append(this.schema);
        stringBuilder.append(", resultSetType=");
        stringBuilder.append(this.resultSetType);
        stringBuilder.append(", resultSetConcurrency=");
        stringBuilder.append(this.resultSetConcurrency);
        stringBuilder.append(", resultSetHoldability=");
        stringBuilder.append(this.resultSetHoldability);
        stringBuilder.append(", autoGeneratedKeys=");
        stringBuilder.append(this.autoGeneratedKeys);
        stringBuilder.append(", columnIndexes=");
        stringBuilder.append(Arrays.toString(this.columnIndexes));
        stringBuilder.append(", columnNames=");
        stringBuilder.append(Arrays.toString(this.columnNames));
        stringBuilder.append(", statementType=");
        stringBuilder.append((Object)this.statementType);
        return stringBuilder.toString();
    }

    @FunctionalInterface
    private static interface StatementBuilder {
        public Statement createStatement(Connection var1, PStmtKey var2) throws SQLException;
    }
}

