﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/quicksight/QuickSight_EXPORTS.h>
#include <aws/quicksight/model/GroupMember.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace QuickSight {
namespace Model {
class DescribeGroupMembershipResult {
 public:
  AWS_QUICKSIGHT_API DescribeGroupMembershipResult() = default;
  AWS_QUICKSIGHT_API DescribeGroupMembershipResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_QUICKSIGHT_API DescribeGroupMembershipResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{

  inline const GroupMember& GetGroupMember() const { return m_groupMember; }
  template <typename GroupMemberT = GroupMember>
  void SetGroupMember(GroupMemberT&& value) {
    m_groupMemberHasBeenSet = true;
    m_groupMember = std::forward<GroupMemberT>(value);
  }
  template <typename GroupMemberT = GroupMember>
  DescribeGroupMembershipResult& WithGroupMember(GroupMemberT&& value) {
    SetGroupMember(std::forward<GroupMemberT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeGroupMembershipResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The HTTP status of the request.</p>
   */
  inline int GetStatus() const { return m_status; }
  inline void SetStatus(int value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline DescribeGroupMembershipResult& WithStatus(int value) {
    SetStatus(value);
    return *this;
  }
  ///@}
 private:
  GroupMember m_groupMember;

  Aws::String m_requestId;

  int m_status{0};
  bool m_groupMemberHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
  bool m_statusHasBeenSet = false;
};

}  // namespace Model
}  // namespace QuickSight
}  // namespace Aws
