﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cleanrooms/CleanRooms_EXPORTS.h>
#include <aws/cleanrooms/model/AnalysisMethod.h>
#include <aws/cleanrooms/model/AnalysisRuleType.h>
#include <aws/cleanrooms/model/SchemaType.h>
#include <aws/cleanrooms/model/SelectedAnalysisMethod.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CleanRooms {
namespace Model {

/**
 * <p>The schema summary for the objects listed by the request.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/SchemaSummary">AWS
 * API Reference</a></p>
 */
class SchemaSummary {
 public:
  AWS_CLEANROOMS_API SchemaSummary() = default;
  AWS_CLEANROOMS_API SchemaSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLEANROOMS_API SchemaSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLEANROOMS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name for the schema object.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  SchemaSummary& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of schema object.</p>
   */
  inline SchemaType GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(SchemaType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline SchemaSummary& WithType(SchemaType value) {
    SetType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique account ID for the Amazon Web Services account that owns the
   * schema.</p>
   */
  inline const Aws::String& GetCreatorAccountId() const { return m_creatorAccountId; }
  inline bool CreatorAccountIdHasBeenSet() const { return m_creatorAccountIdHasBeenSet; }
  template <typename CreatorAccountIdT = Aws::String>
  void SetCreatorAccountId(CreatorAccountIdT&& value) {
    m_creatorAccountIdHasBeenSet = true;
    m_creatorAccountId = std::forward<CreatorAccountIdT>(value);
  }
  template <typename CreatorAccountIdT = Aws::String>
  SchemaSummary& WithCreatorAccountId(CreatorAccountIdT&& value) {
    SetCreatorAccountId(std::forward<CreatorAccountIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time the schema object was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreateTime() const { return m_createTime; }
  inline bool CreateTimeHasBeenSet() const { return m_createTimeHasBeenSet; }
  template <typename CreateTimeT = Aws::Utils::DateTime>
  void SetCreateTime(CreateTimeT&& value) {
    m_createTimeHasBeenSet = true;
    m_createTime = std::forward<CreateTimeT>(value);
  }
  template <typename CreateTimeT = Aws::Utils::DateTime>
  SchemaSummary& WithCreateTime(CreateTimeT&& value) {
    SetCreateTime(std::forward<CreateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time the schema object was last updated.</p>
   */
  inline const Aws::Utils::DateTime& GetUpdateTime() const { return m_updateTime; }
  inline bool UpdateTimeHasBeenSet() const { return m_updateTimeHasBeenSet; }
  template <typename UpdateTimeT = Aws::Utils::DateTime>
  void SetUpdateTime(UpdateTimeT&& value) {
    m_updateTimeHasBeenSet = true;
    m_updateTime = std::forward<UpdateTimeT>(value);
  }
  template <typename UpdateTimeT = Aws::Utils::DateTime>
  SchemaSummary& WithUpdateTime(UpdateTimeT&& value) {
    SetUpdateTime(std::forward<UpdateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique ID for the collaboration that the schema belongs to.</p>
   */
  inline const Aws::String& GetCollaborationId() const { return m_collaborationId; }
  inline bool CollaborationIdHasBeenSet() const { return m_collaborationIdHasBeenSet; }
  template <typename CollaborationIdT = Aws::String>
  void SetCollaborationId(CollaborationIdT&& value) {
    m_collaborationIdHasBeenSet = true;
    m_collaborationId = std::forward<CollaborationIdT>(value);
  }
  template <typename CollaborationIdT = Aws::String>
  SchemaSummary& WithCollaborationId(CollaborationIdT&& value) {
    SetCollaborationId(std::forward<CollaborationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique ARN for the collaboration that the schema belongs to.</p>
   */
  inline const Aws::String& GetCollaborationArn() const { return m_collaborationArn; }
  inline bool CollaborationArnHasBeenSet() const { return m_collaborationArnHasBeenSet; }
  template <typename CollaborationArnT = Aws::String>
  void SetCollaborationArn(CollaborationArnT&& value) {
    m_collaborationArnHasBeenSet = true;
    m_collaborationArn = std::forward<CollaborationArnT>(value);
  }
  template <typename CollaborationArnT = Aws::String>
  SchemaSummary& WithCollaborationArn(CollaborationArnT&& value) {
    SetCollaborationArn(std::forward<CollaborationArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The types of analysis rules that are associated with this schema object.</p>
   */
  inline const Aws::Vector<AnalysisRuleType>& GetAnalysisRuleTypes() const { return m_analysisRuleTypes; }
  inline bool AnalysisRuleTypesHasBeenSet() const { return m_analysisRuleTypesHasBeenSet; }
  template <typename AnalysisRuleTypesT = Aws::Vector<AnalysisRuleType>>
  void SetAnalysisRuleTypes(AnalysisRuleTypesT&& value) {
    m_analysisRuleTypesHasBeenSet = true;
    m_analysisRuleTypes = std::forward<AnalysisRuleTypesT>(value);
  }
  template <typename AnalysisRuleTypesT = Aws::Vector<AnalysisRuleType>>
  SchemaSummary& WithAnalysisRuleTypes(AnalysisRuleTypesT&& value) {
    SetAnalysisRuleTypes(std::forward<AnalysisRuleTypesT>(value));
    return *this;
  }
  inline SchemaSummary& AddAnalysisRuleTypes(AnalysisRuleType value) {
    m_analysisRuleTypesHasBeenSet = true;
    m_analysisRuleTypes.push_back(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The analysis method for the associated schema.</p> <p>
   * <code>DIRECT_QUERY</code> allows SQL queries to be run directly on this
   * table.</p> <p> <code>DIRECT_JOB</code> allows PySpark jobs to be run directly on
   * this table.</p> <p> <code>MULTIPLE</code> allows both SQL queries and PySpark
   * jobs to be run directly on this table.</p>
   */
  inline AnalysisMethod GetAnalysisMethod() const { return m_analysisMethod; }
  inline bool AnalysisMethodHasBeenSet() const { return m_analysisMethodHasBeenSet; }
  inline void SetAnalysisMethod(AnalysisMethod value) {
    m_analysisMethodHasBeenSet = true;
    m_analysisMethod = value;
  }
  inline SchemaSummary& WithAnalysisMethod(AnalysisMethod value) {
    SetAnalysisMethod(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the schema summary resource.</p>
   */
  inline const Aws::String& GetResourceArn() const { return m_resourceArn; }
  inline bool ResourceArnHasBeenSet() const { return m_resourceArnHasBeenSet; }
  template <typename ResourceArnT = Aws::String>
  void SetResourceArn(ResourceArnT&& value) {
    m_resourceArnHasBeenSet = true;
    m_resourceArn = std::forward<ResourceArnT>(value);
  }
  template <typename ResourceArnT = Aws::String>
  SchemaSummary& WithResourceArn(ResourceArnT&& value) {
    SetResourceArn(std::forward<ResourceArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The selected analysis methods for the schema.</p>
   */
  inline const Aws::Vector<SelectedAnalysisMethod>& GetSelectedAnalysisMethods() const { return m_selectedAnalysisMethods; }
  inline bool SelectedAnalysisMethodsHasBeenSet() const { return m_selectedAnalysisMethodsHasBeenSet; }
  template <typename SelectedAnalysisMethodsT = Aws::Vector<SelectedAnalysisMethod>>
  void SetSelectedAnalysisMethods(SelectedAnalysisMethodsT&& value) {
    m_selectedAnalysisMethodsHasBeenSet = true;
    m_selectedAnalysisMethods = std::forward<SelectedAnalysisMethodsT>(value);
  }
  template <typename SelectedAnalysisMethodsT = Aws::Vector<SelectedAnalysisMethod>>
  SchemaSummary& WithSelectedAnalysisMethods(SelectedAnalysisMethodsT&& value) {
    SetSelectedAnalysisMethods(std::forward<SelectedAnalysisMethodsT>(value));
    return *this;
  }
  inline SchemaSummary& AddSelectedAnalysisMethods(SelectedAnalysisMethod value) {
    m_selectedAnalysisMethodsHasBeenSet = true;
    m_selectedAnalysisMethods.push_back(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  SchemaType m_type{SchemaType::NOT_SET};

  Aws::String m_creatorAccountId;

  Aws::Utils::DateTime m_createTime{};

  Aws::Utils::DateTime m_updateTime{};

  Aws::String m_collaborationId;

  Aws::String m_collaborationArn;

  Aws::Vector<AnalysisRuleType> m_analysisRuleTypes;

  AnalysisMethod m_analysisMethod{AnalysisMethod::NOT_SET};

  Aws::String m_resourceArn;

  Aws::Vector<SelectedAnalysisMethod> m_selectedAnalysisMethods;
  bool m_nameHasBeenSet = false;
  bool m_typeHasBeenSet = false;
  bool m_creatorAccountIdHasBeenSet = false;
  bool m_createTimeHasBeenSet = false;
  bool m_updateTimeHasBeenSet = false;
  bool m_collaborationIdHasBeenSet = false;
  bool m_collaborationArnHasBeenSet = false;
  bool m_analysisRuleTypesHasBeenSet = false;
  bool m_analysisMethodHasBeenSet = false;
  bool m_resourceArnHasBeenSet = false;
  bool m_selectedAnalysisMethodsHasBeenSet = false;
};

}  // namespace Model
}  // namespace CleanRooms
}  // namespace Aws
