﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connectcases/ConnectCases_EXPORTS.h>
#include <aws/connectcases/model/SlaStatus.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ConnectCases {
namespace Model {

/**
 * <p>A filter for related items of type <code>SLA</code>.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/SlaFilter">AWS
 * API Reference</a></p>
 */
class SlaFilter {
 public:
  AWS_CONNECTCASES_API SlaFilter() = default;
  AWS_CONNECTCASES_API SlaFilter(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECTCASES_API SlaFilter& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECTCASES_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Name of an SLA.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  SlaFilter& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Status of an SLA.</p>
   */
  inline SlaStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(SlaStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline SlaFilter& WithStatus(SlaStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  SlaStatus m_status{SlaStatus::NOT_SET};
  bool m_nameHasBeenSet = false;
  bool m_statusHasBeenSet = false;
};

}  // namespace Model
}  // namespace ConnectCases
}  // namespace Aws
