/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.datalab.tables.popup;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.gephi.desktop.datalab.tables.AbstractElementsDataTable;
import org.gephi.graph.api.Element;
import org.jdesktop.swingx.JXTable;
import org.openide.awt.MouseUtils;

public abstract class AbstractPopupAdapter<T extends Element>
extends MouseUtils.PopupMouseAdapter {
    protected final AbstractElementsDataTable<T> elementsDataTable;
    protected final JXTable table;

    public AbstractPopupAdapter(AbstractElementsDataTable<T> elementsDataTable) {
        this.elementsDataTable = elementsDataTable;
        this.table = elementsDataTable.getTable();
    }

    protected void showPopup(MouseEvent e) {
        int selRow = this.table.rowAtPoint(e.getPoint());
        if (selRow != -1) {
            if (!this.table.getSelectionModel().isSelectedIndex(selRow)) {
                this.table.getSelectionModel().clearSelection();
                this.table.getSelectionModel().setSelectionInterval(selRow, selRow);
            }
            final Point p = e.getPoint();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    final JPopupMenu pop = AbstractPopupAdapter.this.createPopup(p);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AbstractPopupAdapter.this.showPopup(p.x, p.y, pop);
                        }
                    });
                }
            }).start();
        } else {
            this.table.getSelectionModel().clearSelection();
        }
        e.consume();
    }

    private void showPopup(int xpos, int ypos, final JPopupMenu popup) {
        if (popup != null && popup.getSubElements().length > 0) {
            PopupMenuListener p = new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    popup.removePopupMenuListener(this);
                    AbstractPopupAdapter.this.table.requestFocus();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            };
            popup.addPopupMenuListener(p);
            popup.show((Component)this.table, xpos, ypos);
        }
    }

    protected abstract JPopupMenu createPopup(Point var1);
}

