/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer;

import java.text.NumberFormat;

public abstract class ItemValueFormatter {
    public static final int FORMAT_TOOLTIP = 0;
    public static final int FORMAT_UNITS = 1;
    public static final int FORMAT_DETAILS = 2;
    public static final int FORMAT_EXPORT = 3;
    public static final ItemValueFormatter SIMPLE = new ItemValueFormatter(){

        @Override
        public String formatValue(long value, int format) {
            return Long.toString(value);
        }

        @Override
        public String getUnits(int format) {
            return null;
        }
    };
    public static final ItemValueFormatter DEFAULT_DECIMAL = new Decimal();
    public static final ItemValueFormatter DEFAULT_BYTES = new Bytes();
    public static final ItemValueFormatter DEFAULT_PERCENT = new Percent();

    public abstract String formatValue(long var1, int var3);

    public abstract String getUnits(int var1);

    public static final class Percent
    extends ItemValueFormatter {
        private static final NumberFormat PERCENT_FORMAT = NumberFormat.getPercentInstance();
        private static final NumberFormat NUMBER_FORMAT;
        private double factor;

        Percent() {
            this(3);
        }

        public Percent(int decexp) {
            this.factor = Math.pow(10.0, decexp);
        }

        @Override
        public String formatValue(long value, int format) {
            switch (format) {
                case 0: 
                case 1: {
                    return PERCENT_FORMAT.format((double)value / this.factor);
                }
                case 2: 
                case 3: {
                    return NUMBER_FORMAT.format((double)(value * 100L) / this.factor);
                }
            }
            return null;
        }

        @Override
        public String getUnits(int format) {
            switch (format) {
                case 0: 
                case 1: {
                    return null;
                }
                case 2: 
                case 3: {
                    return "%";
                }
            }
            return null;
        }

        static {
            PERCENT_FORMAT.setMinimumFractionDigits(1);
            PERCENT_FORMAT.setMaximumIntegerDigits(3);
            NUMBER_FORMAT = NumberFormat.getInstance();
            NUMBER_FORMAT.setMinimumFractionDigits(1);
            NUMBER_FORMAT.setMaximumIntegerDigits(3);
        }
    }

    private static final class Bytes
    extends ItemValueFormatter {
        private static final NumberFormat FORMAT = NumberFormat.getInstance();

        Bytes() {
        }

        @Override
        public String formatValue(long value, int format) {
            switch (format) {
                case 0: 
                case 2: 
                case 3: {
                    return FORMAT.format(value);
                }
                case 1: {
                    String est = value == 0L ? "" : "~";
                    return est + FORMAT.format(Math.round((double)value / 1024.0 / 1024.0));
                }
            }
            return null;
        }

        @Override
        public String getUnits(int format) {
            switch (format) {
                case 0: 
                case 2: 
                case 3: {
                    return "B";
                }
                case 1: {
                    return "MB";
                }
            }
            return null;
        }
    }

    public static final class Decimal
    extends ItemValueFormatter {
        private static final NumberFormat FORMAT = NumberFormat.getInstance();
        private final int factor;
        private final String units;

        Decimal() {
            this(1, null);
        }

        public Decimal(int factor, String units) {
            this.factor = factor;
            this.units = units;
        }

        @Override
        public String formatValue(long value, int format) {
            return FORMAT.format(value / (long)this.factor);
        }

        @Override
        public String getUnits(int format) {
            return this.units;
        }
    }
}

