/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.charts;

import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.ResourceBundle;

public class DateTimeAxisUtils {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.ui.charts.Bundle");
    private static final String DAYS_FORMAT = messages.getString("DateTimeAxisUtils_DaysFormat");
    private static final String HOURS_FORMAT = messages.getString("DateTimeAxisUtils_HoursFormat");
    private static final String HOURS_EXT_FORMAT = messages.getString("DateTimeAxisUtils_HoursExtFormat");
    private static final String MINUTES_FORMAT = messages.getString("DateTimeAxisUtils_MinutesFormat");
    private static final String MINUTES_EXT_FORMAT = messages.getString("DateTimeAxisUtils_MinutesExtFormat");
    private static final String SECONDS_FORMAT = messages.getString("DateTimeAxisUtils_SecondsFormat");
    private static final String SECONDS_EXT_FORMAT = messages.getString("DateTimeAxisUtils_SecondsExtFormat");
    private static final String MILLIS_FORMAT = messages.getString("DateTimeAxisUtils_MillisFormat");
    private static final String MILLIS_EXT_FORMAT = messages.getString("DateTimeAxisUtils_MillisExtFormat");
    private static final String MILLIS_FULL_FORMAT = messages.getString("DateTimeAxisUtils_MillisFullFormat");
    private static final String MILLIS_ONLY_FORMAT = messages.getString("DateTimeAxisUtils_MillisOnlyFormat");
    public static final int MIN_TIMEMARK_STEP = 100;
    public static final Color BASE_TIMELINE_COLOR = new Color(0, 0, 0);
    public static final Color MAIN_TIMELINE_COLOR = new Color(150, 150, 150);
    public static final Color TICK_TIMELINE_COLOR = new Color(230, 230, 230);
    private static final int TIME_FORMAT_UNKNOWN = -1;
    private static final int TIME_FORMAT_MILLIS = 10;
    private static final int TIME_FORMAT_SECONDS = 20;
    private static final int TIME_FORMAT_MINUTES = 30;
    private static final int TIME_FORMAT_HOURS = 40;
    private static final int TIME_FORMAT_DAYS = 50;
    private static final SimpleDateFormat daysDateFormat = new SimpleDateFormat(DAYS_FORMAT);
    private static final SimpleDateFormat hoursDateFormat = new SimpleDateFormat(HOURS_FORMAT);
    private static final SimpleDateFormat hoursDateFormatD = new SimpleDateFormat(HOURS_EXT_FORMAT);
    private static final SimpleDateFormat minutesDateFormat = new SimpleDateFormat(MINUTES_FORMAT);
    private static final SimpleDateFormat minutesDateFormatD = new SimpleDateFormat(MINUTES_EXT_FORMAT);
    private static final SimpleDateFormat secondsDateFormat = new SimpleDateFormat(SECONDS_FORMAT);
    private static final SimpleDateFormat secondsDateFormatD = new SimpleDateFormat(SECONDS_EXT_FORMAT);
    private static final SimpleDateFormat millisDateFormat = new SimpleDateFormat(MILLIS_FORMAT);
    private static final SimpleDateFormat millisDateFormatD = new SimpleDateFormat(MILLIS_EXT_FORMAT);
    private static final SimpleDateFormat millisDateFormatF = new SimpleDateFormat(MILLIS_FULL_FORMAT);
    private static final SimpleDateFormat onlyMillisDateFormat = new SimpleDateFormat(MILLIS_ONLY_FORMAT);
    private static final long[] timeUnitsGrid = new long[]{10L, 20L, 50L, 100L, 250L, 500L, 1000L, 2000L, 5000L, 10000L, 15000L, 30000L, 60000L, 120000L, 300000L, 600000L, 900000L, 1800000L, 3600000L, 0x6DDD00L, 10800000L, 21600000L, 43200000L, 86400000L, 172800000L, 259200000L, 432000000L};
    private static final int[] timeUnitsFormat = new int[]{10, 10, 10, 10, 10, 10, 20, 20, 20, 20, 20, 20, 30, 30, 30, 30, 30, 30, 40, 40, 40, 40, 40, 50, 50, 50, 50};
    private static final HashMap timeUnitsToIndex = new HashMap();

    public static String getDaysValue(long mark, boolean useDayMark) {
        return daysDateFormat.format(new Date(mark));
    }

    public static String getHoursValue(long mark, boolean useDayMark) {
        return useDayMark ? hoursDateFormatD.format(new Date(mark)) : hoursDateFormat.format(new Date(mark));
    }

    public static double getMaximumScale(long optimalUnits) {
        return 100.0 / (double)optimalUnits;
    }

    public static String getMillisValue(long mark, boolean useDayMark) {
        return useDayMark ? millisDateFormatD.format(new Date(mark)) : millisDateFormat.format(new Date(mark));
    }

    public static String getMillisValueFull(long mark) {
        return millisDateFormatF.format(new Date(mark));
    }

    public static String getMinutesValue(long mark, boolean useDayMark) {
        return useDayMark ? minutesDateFormatD.format(new Date(mark)) : minutesDateFormat.format(new Date(mark));
    }

    public static long getOptimalUnits(double factor) {
        for (int i = 0; i < timeUnitsGrid.length; ++i) {
            if (!((double)timeUnitsGrid[i] * factor >= 100.0)) continue;
            return timeUnitsGrid[i];
        }
        return timeUnitsGrid[timeUnitsGrid.length - 1];
    }

    public static String getSecondsValue(long mark, boolean useDayMark) {
        return useDayMark ? secondsDateFormatD.format(new Date(mark)) : secondsDateFormat.format(new Date(mark));
    }

    public static String getTimeMarkMillisString(long mark, long optimalUnits) {
        int format = DateTimeAxisUtils.getTimeUnitsFormat(optimalUnits);
        if (format != 10) {
            return "";
        }
        return onlyMillisDateFormat.format(new Date(mark));
    }

    public static String getTimeMarkNoMillisString(long mark, long optimalUnits, boolean useDayMark) {
        int format = DateTimeAxisUtils.getTimeUnitsFormat(optimalUnits);
        if (format == -1) {
            return "";
        }
        if (format == 10) {
            format = 20;
        }
        return DateTimeAxisUtils.getTimeMarkStringFromFormat(mark, format, useDayMark);
    }

    public static String getTimeMarkString(long mark, long optimalUnits, boolean useDayMark) {
        int format = DateTimeAxisUtils.getTimeUnitsFormat(optimalUnits);
        if (format == -1) {
            return "";
        }
        return DateTimeAxisUtils.getTimeMarkStringFromFormat(mark, format, useDayMark);
    }

    private static String getTimeMarkStringFromFormat(long mark, int format, boolean useDayMark) {
        switch (format) {
            case 10: {
                return DateTimeAxisUtils.getMillisValue(mark, useDayMark);
            }
            case 20: 
            case 30: 
            case 40: {
                return DateTimeAxisUtils.getSecondsValue(mark, useDayMark);
            }
            case 50: {
                return DateTimeAxisUtils.getDaysValue(mark, useDayMark);
            }
        }
        return "";
    }

    private static int getTimeUnitsFormat(long optimalUnits) {
        int timeUnitsFormatIndex = DateTimeAxisUtils.getUnitsIndex(optimalUnits);
        if (timeUnitsFormatIndex == -1) {
            return -1;
        }
        return timeUnitsFormat[timeUnitsFormatIndex];
    }

    private static int getUnitsIndex(long optimalUnits) {
        Object oTimeUnitsFormatIndex = timeUnitsToIndex.get(new Long(optimalUnits));
        if (oTimeUnitsFormatIndex == null) {
            return -1;
        }
        return (Integer)oTimeUnitsFormatIndex;
    }

    static {
        for (int i = 0; i < timeUnitsGrid.length; ++i) {
            timeUnitsToIndex.put(new Long(timeUnitsGrid[i]), i);
        }
    }
}

