# Generated by Snowball 2.2.0 - https://snowballstem.org/

from .basestemmer import BaseStemmer
from .among import Among


class TurkishStemmer(BaseStemmer):
    '''
    This class implements the stemming algorithm defined by a snowball script.
    Generated by Snowball 2.2.0 - https://snowballstem.org/
    '''

    a_0 = [
        Among(u"m", -1, -1),
        Among(u"n", -1, -1),
        Among(u"miz", -1, -1),
        Among(u"niz", -1, -1),
        Among(u"muz", -1, -1),
        Among(u"nuz", -1, -1),
        Among(u"m\u00FCz", -1, -1),
        Among(u"n\u00FCz", -1, -1),
        Among(u"m\u0131z", -1, -1),
        Among(u"n\u0131z", -1, -1)
    ]

    a_1 = [
        Among(u"leri", -1, -1),
        Among(u"lar\u0131", -1, -1)
    ]

    a_2 = [
        Among(u"ni", -1, -1),
        Among(u"nu", -1, -1),
        Among(u"n\u00FC", -1, -1),
        Among(u"n\u0131", -1, -1)
    ]

    a_3 = [
        Among(u"in", -1, -1),
        Among(u"un", -1, -1),
        Among(u"\u00FCn", -1, -1),
        Among(u"\u0131n", -1, -1)
    ]

    a_4 = [
        Among(u"a", -1, -1),
        Among(u"e", -1, -1)
    ]

    a_5 = [
        Among(u"na", -1, -1),
        Among(u"ne", -1, -1)
    ]

    a_6 = [
        Among(u"da", -1, -1),
        Among(u"ta", -1, -1),
        Among(u"de", -1, -1),
        Among(u"te", -1, -1)
    ]

    a_7 = [
        Among(u"nda", -1, -1),
        Among(u"nde", -1, -1)
    ]

    a_8 = [
        Among(u"dan", -1, -1),
        Among(u"tan", -1, -1),
        Among(u"den", -1, -1),
        Among(u"ten", -1, -1)
    ]

    a_9 = [
        Among(u"ndan", -1, -1),
        Among(u"nden", -1, -1)
    ]

    a_10 = [
        Among(u"la", -1, -1),
        Among(u"le", -1, -1)
    ]

    a_11 = [
        Among(u"ca", -1, -1),
        Among(u"ce", -1, -1)
    ]

    a_12 = [
        Among(u"im", -1, -1),
        Among(u"um", -1, -1),
        Among(u"\u00FCm", -1, -1),
        Among(u"\u0131m", -1, -1)
    ]

    a_13 = [
        Among(u"sin", -1, -1),
        Among(u"sun", -1, -1),
        Among(u"s\u00FCn", -1, -1),
        Among(u"s\u0131n", -1, -1)
    ]

    a_14 = [
        Among(u"iz", -1, -1),
        Among(u"uz", -1, -1),
        Among(u"\u00FCz", -1, -1),
        Among(u"\u0131z", -1, -1)
    ]

    a_15 = [
        Among(u"siniz", -1, -1),
        Among(u"sunuz", -1, -1),
        Among(u"s\u00FCn\u00FCz", -1, -1),
        Among(u"s\u0131n\u0131z", -1, -1)
    ]

    a_16 = [
        Among(u"lar", -1, -1),
        Among(u"ler", -1, -1)
    ]

    a_17 = [
        Among(u"niz", -1, -1),
        Among(u"nuz", -1, -1),
        Among(u"n\u00FCz", -1, -1),
        Among(u"n\u0131z", -1, -1)
    ]

    a_18 = [
        Among(u"dir", -1, -1),
        Among(u"tir", -1, -1),
        Among(u"dur", -1, -1),
        Among(u"tur", -1, -1),
        Among(u"d\u00FCr", -1, -1),
        Among(u"t\u00FCr", -1, -1),
        Among(u"d\u0131r", -1, -1),
        Among(u"t\u0131r", -1, -1)
    ]

    a_19 = [
        Among(u"cas\u0131na", -1, -1),
        Among(u"cesine", -1, -1)
    ]

    a_20 = [
        Among(u"di", -1, -1),
        Among(u"ti", -1, -1),
        Among(u"dik", -1, -1),
        Among(u"tik", -1, -1),
        Among(u"duk", -1, -1),
        Among(u"tuk", -1, -1),
        Among(u"d\u00FCk", -1, -1),
        Among(u"t\u00FCk", -1, -1),
        Among(u"d\u0131k", -1, -1),
        Among(u"t\u0131k", -1, -1),
        Among(u"dim", -1, -1),
        Among(u"tim", -1, -1),
        Among(u"dum", -1, -1),
        Among(u"tum", -1, -1),
        Among(u"d\u00FCm", -1, -1),
        Among(u"t\u00FCm", -1, -1),
        Among(u"d\u0131m", -1, -1),
        Among(u"t\u0131m", -1, -1),
        Among(u"din", -1, -1),
        Among(u"tin", -1, -1),
        Among(u"dun", -1, -1),
        Among(u"tun", -1, -1),
        Among(u"d\u00FCn", -1, -1),
        Among(u"t\u00FCn", -1, -1),
        Among(u"d\u0131n", -1, -1),
        Among(u"t\u0131n", -1, -1),
        Among(u"du", -1, -1),
        Among(u"tu", -1, -1),
        Among(u"d\u00FC", -1, -1),
        Among(u"t\u00FC", -1, -1),
        Among(u"d\u0131", -1, -1),
        Among(u"t\u0131", -1, -1)
    ]

    a_21 = [
        Among(u"sa", -1, -1),
        Among(u"se", -1, -1),
        Among(u"sak", -1, -1),
        Among(u"sek", -1, -1),
        Among(u"sam", -1, -1),
        Among(u"sem", -1, -1),
        Among(u"san", -1, -1),
        Among(u"sen", -1, -1)
    ]

    a_22 = [
        Among(u"mi\u015F", -1, -1),
        Among(u"mu\u015F", -1, -1),
        Among(u"m\u00FC\u015F", -1, -1),
        Among(u"m\u0131\u015F", -1, -1)
    ]

    a_23 = [
        Among(u"b", -1, 1),
        Among(u"c", -1, 2),
        Among(u"d", -1, 3),
        Among(u"\u011F", -1, 4)
    ]

    g_vowel = [17, 65, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 8, 0, 0, 0, 0, 0, 0, 1]

    g_U = [1, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 1]

    g_vowel1 = [1, 64, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1]

    g_vowel2 = [17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 130]

    g_vowel3 = [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1]

    g_vowel4 = [17]

    g_vowel5 = [65]

    g_vowel6 = [65]

    B_continue_stemming_noun_suffixes = False

    def __r_check_vowel_harmony(self):
        v_1 = self.limit - self.cursor
        if not self.go_out_grouping_b(TurkishStemmer.g_vowel, 97, 305):
            return False
        try:
            v_2 = self.limit - self.cursor
            try:
                if not self.eq_s_b(u"a"):
                    raise lab1()
                if not self.go_out_grouping_b(TurkishStemmer.g_vowel1, 97, 305):
                    raise lab1()
                raise lab0()
            except lab1: pass
            self.cursor = self.limit - v_2
            try:
                if not self.eq_s_b(u"e"):
                    raise lab2()
                if not self.go_out_grouping_b(TurkishStemmer.g_vowel2, 101, 252):
                    raise lab2()
                raise lab0()
            except lab2: pass
            self.cursor = self.limit - v_2
            try:
                if not self.eq_s_b(u"\u0131"):
                    raise lab3()
                if not self.go_out_grouping_b(TurkishStemmer.g_vowel3, 97, 305):
                    raise lab3()
                raise lab0()
            except lab3: pass
            self.cursor = self.limit - v_2
            try:
                if not self.eq_s_b(u"i"):
                    raise lab4()
                if not self.go_out_grouping_b(TurkishStemmer.g_vowel4, 101, 105):
                    raise lab4()
                raise lab0()
            except lab4: pass
            self.cursor = self.limit - v_2
            try:
                if not self.eq_s_b(u"o"):
                    raise lab5()
                if not self.go_out_grouping_b(TurkishStemmer.g_vowel5, 111, 117):
                    raise lab5()
                raise lab0()
            except lab5: pass
            self.cursor = self.limit - v_2
            try:
                if not self.eq_s_b(u"\u00F6"):
                    raise lab6()
                if not self.go_out_grouping_b(TurkishStemmer.g_vowel6, 246, 252):
                    raise lab6()
                raise lab0()
            except lab6: pass
            self.cursor = self.limit - v_2
            try:
                if not self.eq_s_b(u"u"):
                    raise lab7()
                if not self.go_out_grouping_b(TurkishStemmer.g_vowel5, 111, 117):
                    raise lab7()
                raise lab0()
            except lab7: pass
            self.cursor = self.limit - v_2
            if not self.eq_s_b(u"\u00FC"):
                return False
            if not self.go_out_grouping_b(TurkishStemmer.g_vowel6, 246, 252):
                return False
        except lab0: pass
        self.cursor = self.limit - v_1
        return True

    def __r_mark_suffix_with_optional_n_consonant(self):
        try:
            v_1 = self.limit - self.cursor
            try:
                if not self.eq_s_b(u"n"):
                    raise lab1()
                v_2 = self.limit - self.cursor
                if not self.in_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                    raise lab1()
                self.cursor = self.limit - v_2
                raise lab0()
            except lab1: pass
            self.cursor = self.limit - v_1
            v_3 = self.limit - self.cursor
            try:
                v_4 = self.limit - self.cursor
                if not self.eq_s_b(u"n"):
                    raise lab2()
                self.cursor = self.limit - v_4
                return False
            except lab2: pass
            self.cursor = self.limit - v_3
            v_5 = self.limit - self.cursor
            if self.cursor <= self.limit_backward:
                return False
            self.cursor -= 1
            if not self.in_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                return False
            self.cursor = self.limit - v_5
        except lab0: pass
        return True

    def __r_mark_suffix_with_optional_s_consonant(self):
        try:
            v_1 = self.limit - self.cursor
            try:
                if not self.eq_s_b(u"s"):
                    raise lab1()
                v_2 = self.limit - self.cursor
                if not self.in_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                    raise lab1()
                self.cursor = self.limit - v_2
                raise lab0()
            except lab1: pass
            self.cursor = self.limit - v_1
            v_3 = self.limit - self.cursor
            try:
                v_4 = self.limit - self.cursor
                if not self.eq_s_b(u"s"):
                    raise lab2()
                self.cursor = self.limit - v_4
                return False
            except lab2: pass
            self.cursor = self.limit - v_3
            v_5 = self.limit - self.cursor
            if self.cursor <= self.limit_backward:
                return False
            self.cursor -= 1
            if not self.in_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                return False
            self.cursor = self.limit - v_5
        except lab0: pass
        return True

    def __r_mark_suffix_with_optional_y_consonant(self):
        try:
            v_1 = self.limit - self.cursor
            try:
                if not self.eq_s_b(u"y"):
                    raise lab1()
                v_2 = self.limit - self.cursor
                if not self.in_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                    raise lab1()
                self.cursor = self.limit - v_2
                raise lab0()
            except lab1: pass
            self.cursor = self.limit - v_1
            v_3 = self.limit - self.cursor
            try:
                v_4 = self.limit - self.cursor
                if not self.eq_s_b(u"y"):
                    raise lab2()
                self.cursor = self.limit - v_4
                return False
            except lab2: pass
            self.cursor = self.limit - v_3
            v_5 = self.limit - self.cursor
            if self.cursor <= self.limit_backward:
                return False
            self.cursor -= 1
            if not self.in_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                return False
            self.cursor = self.limit - v_5
        except lab0: pass
        return True

    def __r_mark_suffix_with_optional_U_vowel(self):
        try:
            v_1 = self.limit - self.cursor
            try:
                if not self.in_grouping_b(TurkishStemmer.g_U, 105, 305):
                    raise lab1()
                v_2 = self.limit - self.cursor
                if not self.out_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                    raise lab1()
                self.cursor = self.limit - v_2
                raise lab0()
            except lab1: pass
            self.cursor = self.limit - v_1
            v_3 = self.limit - self.cursor
            try:
                v_4 = self.limit - self.cursor
                if not self.in_grouping_b(TurkishStemmer.g_U, 105, 305):
                    raise lab2()
                self.cursor = self.limit - v_4
                return False
            except lab2: pass
            self.cursor = self.limit - v_3
            v_5 = self.limit - self.cursor
            if self.cursor <= self.limit_backward:
                return False
            self.cursor -= 1
            if not self.out_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                return False
            self.cursor = self.limit - v_5
        except lab0: pass
        return True

    def __r_mark_possessives(self):
        if self.find_among_b(TurkishStemmer.a_0) == 0:
            return False
        if not self.__r_mark_suffix_with_optional_U_vowel():
            return False
        return True

    def __r_mark_sU(self):
        if not self.__r_check_vowel_harmony():
            return False
        if not self.in_grouping_b(TurkishStemmer.g_U, 105, 305):
            return False
        if not self.__r_mark_suffix_with_optional_s_consonant():
            return False
        return True

    def __r_mark_lArI(self):
        if self.find_among_b(TurkishStemmer.a_1) == 0:
            return False
        return True

    def __r_mark_yU(self):
        if not self.__r_check_vowel_harmony():
            return False
        if not self.in_grouping_b(TurkishStemmer.g_U, 105, 305):
            return False
        if not self.__r_mark_suffix_with_optional_y_consonant():
            return False
        return True

    def __r_mark_nU(self):
        if not self.__r_check_vowel_harmony():
            return False
        if self.find_among_b(TurkishStemmer.a_2) == 0:
            return False
        return True

    def __r_mark_nUn(self):
        if not self.__r_check_vowel_harmony():
            return False
        if self.find_among_b(TurkishStemmer.a_3) == 0:
            return False
        if not self.__r_mark_suffix_with_optional_n_consonant():
            return False
        return True

    def __r_mark_yA(self):
        if not self.__r_check_vowel_harmony():
            return False
        if self.find_among_b(TurkishStemmer.a_4) == 0:
            return False
        if not self.__r_mark_suffix_with_optional_y_consonant():
            return False
        return True

    def __r_mark_nA(self):
        if not self.__r_check_vowel_harmony():
            return False
        if self.find_among_b(TurkishStemmer.a_5) == 0:
            return False
        return True

    def __r_mark_DA(self):
        if not self.__r_check_vowel_harmony():
            return False
        if self.find_among_b(TurkishStemmer.a_6) == 0:
            return False
        return True

    def __r_mark_ndA(self):
        if not self.__r_check_vowel_harmony():
            return False
        if self.find_among_b(TurkishStemmer.a_7) == 0:
            return False
        return True

    def __r_mark_DAn(self):
        if not self.__r_check_vowel_harmony():
            return False
        if self.find_among_b(TurkishStemmer.a_8) == 0:
            return False
        return True

    def __r_mark_ndAn(self):
        if not self.__r_check_vowel_harmony():
            return False
        if self.find_among_b(TurkishStemmer.a_9) == 0:
            return False
        return True

    def __r_mark_ylA(self):
        if not self.__r_check_vowel_harmony():
            return False
        if self.find_among_b(TurkishStemmer.a_10) == 0:
            return False
        if not self.__r_mark_suffix_with_optional_y_consonant():
            return False
        return True

    def __r_mark_ki(self):
        if not self.eq_s_b(u"ki"):
            return False
        return True

    def __r_mark_ncA(self):
        if not self.__r_check_vowel_harmony():
            return False
        if self.find_among_b(TurkishStemmer.a_11) == 0:
            return False
        if not self.__r_mark_suffix_with_optional_n_consonant():
            return False
        return True

    def __r_mark_yUm(self):
        if not self.__r_check_vowel_harmony():
            return False
        if self.find_among_b(TurkishStemmer.a_12) == 0:
            return False
        if not self.__r_mark_suffix_with_optional_y_consonant():
            return False
        return True

    def __r_mark_sUn(self):
        if not self.__r_check_vowel_harmony():
            return False
        if self.find_among_b(TurkishStemmer.a_13) == 0:
            return False
        return True

    def __r_mark_yUz(self):
        if not self.__r_check_vowel_harmony():
            return False
        if self.find_among_b(TurkishStemmer.a_14) == 0:
            return False
        if not self.__r_mark_suffix_with_optional_y_consonant():
            return False
        return True

    def __r_mark_sUnUz(self):
        if self.find_among_b(TurkishStemmer.a_15) == 0:
            return False
        return True

    def __r_mark_lAr(self):
        if not self.__r_check_vowel_harmony():
            return False
        if self.find_among_b(TurkishStemmer.a_16) == 0:
            return False
        return True

    def __r_mark_nUz(self):
        if not self.__r_check_vowel_harmony():
            return False
        if self.find_among_b(TurkishStemmer.a_17) == 0:
            return False
        return True

    def __r_mark_DUr(self):
        if not self.__r_check_vowel_harmony():
            return False
        if self.find_among_b(TurkishStemmer.a_18) == 0:
            return False
        return True

    def __r_mark_cAsInA(self):
        if self.find_among_b(TurkishStemmer.a_19) == 0:
            return False
        return True

    def __r_mark_yDU(self):
        if not self.__r_check_vowel_harmony():
            return False
        if self.find_among_b(TurkishStemmer.a_20) == 0:
            return False
        if not self.__r_mark_suffix_with_optional_y_consonant():
            return False
        return True

    def __r_mark_ysA(self):
        if self.find_among_b(TurkishStemmer.a_21) == 0:
            return False
        if not self.__r_mark_suffix_with_optional_y_consonant():
            return False
        return True

    def __r_mark_ymUs_(self):
        if not self.__r_check_vowel_harmony():
            return False
        if self.find_among_b(TurkishStemmer.a_22) == 0:
            return False
        if not self.__r_mark_suffix_with_optional_y_consonant():
            return False
        return True

    def __r_mark_yken(self):
        if not self.eq_s_b(u"ken"):
            return False
        if not self.__r_mark_suffix_with_optional_y_consonant():
            return False
        return True

    def __r_stem_nominal_verb_suffixes(self):
        self.ket = self.cursor
        self.B_continue_stemming_noun_suffixes = True
        try:
            v_1 = self.limit - self.cursor
            try:
                try:
                    v_2 = self.limit - self.cursor
                    try:
                        if not self.__r_mark_ymUs_():
                            raise lab3()
                        raise lab2()
                    except lab3: pass
                    self.cursor = self.limit - v_2
                    try:
                        if not self.__r_mark_yDU():
                            raise lab4()
                        raise lab2()
                    except lab4: pass
                    self.cursor = self.limit - v_2
                    try:
                        if not self.__r_mark_ysA():
                            raise lab5()
                        raise lab2()
                    except lab5: pass
                    self.cursor = self.limit - v_2
                    if not self.__r_mark_yken():
                        raise lab1()
                except lab2: pass
                raise lab0()
            except lab1: pass
            self.cursor = self.limit - v_1
            try:
                if not self.__r_mark_cAsInA():
                    raise lab6()
                try:
                    v_3 = self.limit - self.cursor
                    try:
                        if not self.__r_mark_sUnUz():
                            raise lab8()
                        raise lab7()
                    except lab8: pass
                    self.cursor = self.limit - v_3
                    try:
                        if not self.__r_mark_lAr():
                            raise lab9()
                        raise lab7()
                    except lab9: pass
                    self.cursor = self.limit - v_3
                    try:
                        if not self.__r_mark_yUm():
                            raise lab10()
                        raise lab7()
                    except lab10: pass
                    self.cursor = self.limit - v_3
                    try:
                        if not self.__r_mark_sUn():
                            raise lab11()
                        raise lab7()
                    except lab11: pass
                    self.cursor = self.limit - v_3
                    try:
                        if not self.__r_mark_yUz():
                            raise lab12()
                        raise lab7()
                    except lab12: pass
                    self.cursor = self.limit - v_3
                except lab7: pass
                if not self.__r_mark_ymUs_():
                    raise lab6()
                raise lab0()
            except lab6: pass
            self.cursor = self.limit - v_1
            try:
                if not self.__r_mark_lAr():
                    raise lab13()
                self.bra = self.cursor
                if not self.slice_del():
                    return False

                v_4 = self.limit - self.cursor
                try:
                    self.ket = self.cursor
                    try:
                        v_5 = self.limit - self.cursor
                        try:
                            if not self.__r_mark_DUr():
                                raise lab16()
                            raise lab15()
                        except lab16: pass
                        self.cursor = self.limit - v_5
                        try:
                            if not self.__r_mark_yDU():
                                raise lab17()
                            raise lab15()
                        except lab17: pass
                        self.cursor = self.limit - v_5
                        try:
                            if not self.__r_mark_ysA():
                                raise lab18()
                            raise lab15()
                        except lab18: pass
                        self.cursor = self.limit - v_5
                        if not self.__r_mark_ymUs_():
                            self.cursor = self.limit - v_4
                            raise lab14()
                    except lab15: pass
                except lab14: pass
                self.B_continue_stemming_noun_suffixes = False
                raise lab0()
            except lab13: pass
            self.cursor = self.limit - v_1
            try:
                if not self.__r_mark_nUz():
                    raise lab19()
                try:
                    v_6 = self.limit - self.cursor
                    try:
                        if not self.__r_mark_yDU():
                            raise lab21()
                        raise lab20()
                    except lab21: pass
                    self.cursor = self.limit - v_6
                    if not self.__r_mark_ysA():
                        raise lab19()
                except lab20: pass
                raise lab0()
            except lab19: pass
            self.cursor = self.limit - v_1
            try:
                try:
                    v_7 = self.limit - self.cursor
                    try:
                        if not self.__r_mark_sUnUz():
                            raise lab24()
                        raise lab23()
                    except lab24: pass
                    self.cursor = self.limit - v_7
                    try:
                        if not self.__r_mark_yUz():
                            raise lab25()
                        raise lab23()
                    except lab25: pass
                    self.cursor = self.limit - v_7
                    try:
                        if not self.__r_mark_sUn():
                            raise lab26()
                        raise lab23()
                    except lab26: pass
                    self.cursor = self.limit - v_7
                    if not self.__r_mark_yUm():
                        raise lab22()
                except lab23: pass
                self.bra = self.cursor
                if not self.slice_del():
                    return False

                v_8 = self.limit - self.cursor
                try:
                    self.ket = self.cursor
                    if not self.__r_mark_ymUs_():
                        self.cursor = self.limit - v_8
                        raise lab27()
                except lab27: pass
                raise lab0()
            except lab22: pass
            self.cursor = self.limit - v_1
            if not self.__r_mark_DUr():
                return False
            self.bra = self.cursor
            if not self.slice_del():
                return False

            v_9 = self.limit - self.cursor
            try:
                self.ket = self.cursor
                try:
                    v_10 = self.limit - self.cursor
                    try:
                        if not self.__r_mark_sUnUz():
                            raise lab30()
                        raise lab29()
                    except lab30: pass
                    self.cursor = self.limit - v_10
                    try:
                        if not self.__r_mark_lAr():
                            raise lab31()
                        raise lab29()
                    except lab31: pass
                    self.cursor = self.limit - v_10
                    try:
                        if not self.__r_mark_yUm():
                            raise lab32()
                        raise lab29()
                    except lab32: pass
                    self.cursor = self.limit - v_10
                    try:
                        if not self.__r_mark_sUn():
                            raise lab33()
                        raise lab29()
                    except lab33: pass
                    self.cursor = self.limit - v_10
                    try:
                        if not self.__r_mark_yUz():
                            raise lab34()
                        raise lab29()
                    except lab34: pass
                    self.cursor = self.limit - v_10
                except lab29: pass
                if not self.__r_mark_ymUs_():
                    self.cursor = self.limit - v_9
                    raise lab28()
            except lab28: pass
        except lab0: pass
        self.bra = self.cursor
        if not self.slice_del():
            return False

        return True

    def __r_stem_suffix_chain_before_ki(self):
        self.ket = self.cursor
        if not self.__r_mark_ki():
            return False
        try:
            v_1 = self.limit - self.cursor
            try:
                if not self.__r_mark_DA():
                    raise lab1()
                self.bra = self.cursor
                if not self.slice_del():
                    return False

                v_2 = self.limit - self.cursor
                try:
                    self.ket = self.cursor
                    try:
                        v_3 = self.limit - self.cursor
                        try:
                            if not self.__r_mark_lAr():
                                raise lab4()
                            self.bra = self.cursor
                            if not self.slice_del():
                                return False

                            v_4 = self.limit - self.cursor
                            try:
                                if not self.__r_stem_suffix_chain_before_ki():
                                    self.cursor = self.limit - v_4
                                    raise lab5()
                            except lab5: pass
                            raise lab3()
                        except lab4: pass
                        self.cursor = self.limit - v_3
                        if not self.__r_mark_possessives():
                            self.cursor = self.limit - v_2
                            raise lab2()
                        self.bra = self.cursor
                        if not self.slice_del():
                            return False

                        v_5 = self.limit - self.cursor
                        try:
                            self.ket = self.cursor
                            if not self.__r_mark_lAr():
                                self.cursor = self.limit - v_5
                                raise lab6()
                            self.bra = self.cursor
                            if not self.slice_del():
                                return False

                            if not self.__r_stem_suffix_chain_before_ki():
                                self.cursor = self.limit - v_5
                                raise lab6()
                        except lab6: pass
                    except lab3: pass
                except lab2: pass
                raise lab0()
            except lab1: pass
            self.cursor = self.limit - v_1
            try:
                if not self.__r_mark_nUn():
                    raise lab7()
                self.bra = self.cursor
                if not self.slice_del():
                    return False

                v_6 = self.limit - self.cursor
                try:
                    self.ket = self.cursor
                    try:
                        v_7 = self.limit - self.cursor
                        try:
                            if not self.__r_mark_lArI():
                                raise lab10()
                            self.bra = self.cursor
                            if not self.slice_del():
                                return False

                            raise lab9()
                        except lab10: pass
                        self.cursor = self.limit - v_7
                        try:
                            self.ket = self.cursor
                            try:
                                v_8 = self.limit - self.cursor
                                try:
                                    if not self.__r_mark_possessives():
                                        raise lab13()
                                    raise lab12()
                                except lab13: pass
                                self.cursor = self.limit - v_8
                                if not self.__r_mark_sU():
                                    raise lab11()
                            except lab12: pass
                            self.bra = self.cursor
                            if not self.slice_del():
                                return False

                            v_9 = self.limit - self.cursor
                            try:
                                self.ket = self.cursor
                                if not self.__r_mark_lAr():
                                    self.cursor = self.limit - v_9
                                    raise lab14()
                                self.bra = self.cursor
                                if not self.slice_del():
                                    return False

                                if not self.__r_stem_suffix_chain_before_ki():
                                    self.cursor = self.limit - v_9
                                    raise lab14()
                            except lab14: pass
                            raise lab9()
                        except lab11: pass
                        self.cursor = self.limit - v_7
                        if not self.__r_stem_suffix_chain_before_ki():
                            self.cursor = self.limit - v_6
                            raise lab8()
                    except lab9: pass
                except lab8: pass
                raise lab0()
            except lab7: pass
            self.cursor = self.limit - v_1
            if not self.__r_mark_ndA():
                return False
            try:
                v_10 = self.limit - self.cursor
                try:
                    if not self.__r_mark_lArI():
                        raise lab16()
                    self.bra = self.cursor
                    if not self.slice_del():
                        return False

                    raise lab15()
                except lab16: pass
                self.cursor = self.limit - v_10
                try:
                    if not self.__r_mark_sU():
                        raise lab17()
                    self.bra = self.cursor
                    if not self.slice_del():
                        return False

                    v_11 = self.limit - self.cursor
                    try:
                        self.ket = self.cursor
                        if not self.__r_mark_lAr():
                            self.cursor = self.limit - v_11
                            raise lab18()
                        self.bra = self.cursor
                        if not self.slice_del():
                            return False

                        if not self.__r_stem_suffix_chain_before_ki():
                            self.cursor = self.limit - v_11
                            raise lab18()
                    except lab18: pass
                    raise lab15()
                except lab17: pass
                self.cursor = self.limit - v_10
                if not self.__r_stem_suffix_chain_before_ki():
                    return False
            except lab15: pass
        except lab0: pass
        return True

    def __r_stem_noun_suffixes(self):
        try:
            v_1 = self.limit - self.cursor
            try:
                self.ket = self.cursor
                if not self.__r_mark_lAr():
                    raise lab1()
                self.bra = self.cursor
                if not self.slice_del():
                    return False

                v_2 = self.limit - self.cursor
                try:
                    if not self.__r_stem_suffix_chain_before_ki():
                        self.cursor = self.limit - v_2
                        raise lab2()
                except lab2: pass
                raise lab0()
            except lab1: pass
            self.cursor = self.limit - v_1
            try:
                self.ket = self.cursor
                if not self.__r_mark_ncA():
                    raise lab3()
                self.bra = self.cursor
                if not self.slice_del():
                    return False

                v_3 = self.limit - self.cursor
                try:
                    try:
                        v_4 = self.limit - self.cursor
                        try:
                            self.ket = self.cursor
                            if not self.__r_mark_lArI():
                                raise lab6()
                            self.bra = self.cursor
                            if not self.slice_del():
                                return False

                            raise lab5()
                        except lab6: pass
                        self.cursor = self.limit - v_4
                        try:
                            self.ket = self.cursor
                            try:
                                v_5 = self.limit - self.cursor
                                try:
                                    if not self.__r_mark_possessives():
                                        raise lab9()
                                    raise lab8()
                                except lab9: pass
                                self.cursor = self.limit - v_5
                                if not self.__r_mark_sU():
                                    raise lab7()
                            except lab8: pass
                            self.bra = self.cursor
                            if not self.slice_del():
                                return False

                            v_6 = self.limit - self.cursor
                            try:
                                self.ket = self.cursor
                                if not self.__r_mark_lAr():
                                    self.cursor = self.limit - v_6
                                    raise lab10()
                                self.bra = self.cursor
                                if not self.slice_del():
                                    return False

                                if not self.__r_stem_suffix_chain_before_ki():
                                    self.cursor = self.limit - v_6
                                    raise lab10()
                            except lab10: pass
                            raise lab5()
                        except lab7: pass
                        self.cursor = self.limit - v_4
                        self.ket = self.cursor
                        if not self.__r_mark_lAr():
                            self.cursor = self.limit - v_3
                            raise lab4()
                        self.bra = self.cursor
                        if not self.slice_del():
                            return False

                        if not self.__r_stem_suffix_chain_before_ki():
                            self.cursor = self.limit - v_3
                            raise lab4()
                    except lab5: pass
                except lab4: pass
                raise lab0()
            except lab3: pass
            self.cursor = self.limit - v_1
            try:
                self.ket = self.cursor
                try:
                    v_7 = self.limit - self.cursor
                    try:
                        if not self.__r_mark_ndA():
                            raise lab13()
                        raise lab12()
                    except lab13: pass
                    self.cursor = self.limit - v_7
                    if not self.__r_mark_nA():
                        raise lab11()
                except lab12: pass
                try:
                    v_8 = self.limit - self.cursor
                    try:
                        if not self.__r_mark_lArI():
                            raise lab15()
                        self.bra = self.cursor
                        if not self.slice_del():
                            return False

                        raise lab14()
                    except lab15: pass
                    self.cursor = self.limit - v_8
                    try:
                        if not self.__r_mark_sU():
                            raise lab16()
                        self.bra = self.cursor
                        if not self.slice_del():
                            return False

                        v_9 = self.limit - self.cursor
                        try:
                            self.ket = self.cursor
                            if not self.__r_mark_lAr():
                                self.cursor = self.limit - v_9
                                raise lab17()
                            self.bra = self.cursor
                            if not self.slice_del():
                                return False

                            if not self.__r_stem_suffix_chain_before_ki():
                                self.cursor = self.limit - v_9
                                raise lab17()
                        except lab17: pass
                        raise lab14()
                    except lab16: pass
                    self.cursor = self.limit - v_8
                    if not self.__r_stem_suffix_chain_before_ki():
                        raise lab11()
                except lab14: pass
                raise lab0()
            except lab11: pass
            self.cursor = self.limit - v_1
            try:
                self.ket = self.cursor
                try:
                    v_10 = self.limit - self.cursor
                    try:
                        if not self.__r_mark_ndAn():
                            raise lab20()
                        raise lab19()
                    except lab20: pass
                    self.cursor = self.limit - v_10
                    if not self.__r_mark_nU():
                        raise lab18()
                except lab19: pass
                try:
                    v_11 = self.limit - self.cursor
                    try:
                        if not self.__r_mark_sU():
                            raise lab22()
                        self.bra = self.cursor
                        if not self.slice_del():
                            return False

                        v_12 = self.limit - self.cursor
                        try:
                            self.ket = self.cursor
                            if not self.__r_mark_lAr():
                                self.cursor = self.limit - v_12
                                raise lab23()
                            self.bra = self.cursor
                            if not self.slice_del():
                                return False

                            if not self.__r_stem_suffix_chain_before_ki():
                                self.cursor = self.limit - v_12
                                raise lab23()
                        except lab23: pass
                        raise lab21()
                    except lab22: pass
                    self.cursor = self.limit - v_11
                    if not self.__r_mark_lArI():
                        raise lab18()
                except lab21: pass
                raise lab0()
            except lab18: pass
            self.cursor = self.limit - v_1
            try:
                self.ket = self.cursor
                if not self.__r_mark_DAn():
                    raise lab24()
                self.bra = self.cursor
                if not self.slice_del():
                    return False

                v_13 = self.limit - self.cursor
                try:
                    self.ket = self.cursor
                    try:
                        v_14 = self.limit - self.cursor
                        try:
                            if not self.__r_mark_possessives():
                                raise lab27()
                            self.bra = self.cursor
                            if not self.slice_del():
                                return False

                            v_15 = self.limit - self.cursor
                            try:
                                self.ket = self.cursor
                                if not self.__r_mark_lAr():
                                    self.cursor = self.limit - v_15
                                    raise lab28()
                                self.bra = self.cursor
                                if not self.slice_del():
                                    return False

                                if not self.__r_stem_suffix_chain_before_ki():
                                    self.cursor = self.limit - v_15
                                    raise lab28()
                            except lab28: pass
                            raise lab26()
                        except lab27: pass
                        self.cursor = self.limit - v_14
                        try:
                            if not self.__r_mark_lAr():
                                raise lab29()
                            self.bra = self.cursor
                            if not self.slice_del():
                                return False

                            v_16 = self.limit - self.cursor
                            try:
                                if not self.__r_stem_suffix_chain_before_ki():
                                    self.cursor = self.limit - v_16
                                    raise lab30()
                            except lab30: pass
                            raise lab26()
                        except lab29: pass
                        self.cursor = self.limit - v_14
                        if not self.__r_stem_suffix_chain_before_ki():
                            self.cursor = self.limit - v_13
                            raise lab25()
                    except lab26: pass
                except lab25: pass
                raise lab0()
            except lab24: pass
            self.cursor = self.limit - v_1
            try:
                self.ket = self.cursor
                try:
                    v_17 = self.limit - self.cursor
                    try:
                        if not self.__r_mark_nUn():
                            raise lab33()
                        raise lab32()
                    except lab33: pass
                    self.cursor = self.limit - v_17
                    if not self.__r_mark_ylA():
                        raise lab31()
                except lab32: pass
                self.bra = self.cursor
                if not self.slice_del():
                    return False

                v_18 = self.limit - self.cursor
                try:
                    try:
                        v_19 = self.limit - self.cursor
                        try:
                            self.ket = self.cursor
                            if not self.__r_mark_lAr():
                                raise lab36()
                            self.bra = self.cursor
                            if not self.slice_del():
                                return False

                            if not self.__r_stem_suffix_chain_before_ki():
                                raise lab36()
                            raise lab35()
                        except lab36: pass
                        self.cursor = self.limit - v_19
                        try:
                            self.ket = self.cursor
                            try:
                                v_20 = self.limit - self.cursor
                                try:
                                    if not self.__r_mark_possessives():
                                        raise lab39()
                                    raise lab38()
                                except lab39: pass
                                self.cursor = self.limit - v_20
                                if not self.__r_mark_sU():
                                    raise lab37()
                            except lab38: pass
                            self.bra = self.cursor
                            if not self.slice_del():
                                return False

                            v_21 = self.limit - self.cursor
                            try:
                                self.ket = self.cursor
                                if not self.__r_mark_lAr():
                                    self.cursor = self.limit - v_21
                                    raise lab40()
                                self.bra = self.cursor
                                if not self.slice_del():
                                    return False

                                if not self.__r_stem_suffix_chain_before_ki():
                                    self.cursor = self.limit - v_21
                                    raise lab40()
                            except lab40: pass
                            raise lab35()
                        except lab37: pass
                        self.cursor = self.limit - v_19
                        if not self.__r_stem_suffix_chain_before_ki():
                            self.cursor = self.limit - v_18
                            raise lab34()
                    except lab35: pass
                except lab34: pass
                raise lab0()
            except lab31: pass
            self.cursor = self.limit - v_1
            try:
                self.ket = self.cursor
                if not self.__r_mark_lArI():
                    raise lab41()
                self.bra = self.cursor
                if not self.slice_del():
                    return False

                raise lab0()
            except lab41: pass
            self.cursor = self.limit - v_1
            try:
                if not self.__r_stem_suffix_chain_before_ki():
                    raise lab42()
                raise lab0()
            except lab42: pass
            self.cursor = self.limit - v_1
            try:
                self.ket = self.cursor
                try:
                    v_22 = self.limit - self.cursor
                    try:
                        if not self.__r_mark_DA():
                            raise lab45()
                        raise lab44()
                    except lab45: pass
                    self.cursor = self.limit - v_22
                    try:
                        if not self.__r_mark_yU():
                            raise lab46()
                        raise lab44()
                    except lab46: pass
                    self.cursor = self.limit - v_22
                    if not self.__r_mark_yA():
                        raise lab43()
                except lab44: pass
                self.bra = self.cursor
                if not self.slice_del():
                    return False

                v_23 = self.limit - self.cursor
                try:
                    self.ket = self.cursor
                    try:
                        v_24 = self.limit - self.cursor
                        try:
                            if not self.__r_mark_possessives():
                                raise lab49()
                            self.bra = self.cursor
                            if not self.slice_del():
                                return False

                            v_25 = self.limit - self.cursor
                            try:
                                self.ket = self.cursor
                                if not self.__r_mark_lAr():
                                    self.cursor = self.limit - v_25
                                    raise lab50()
                            except lab50: pass
                            raise lab48()
                        except lab49: pass
                        self.cursor = self.limit - v_24
                        if not self.__r_mark_lAr():
                            self.cursor = self.limit - v_23
                            raise lab47()
                    except lab48: pass
                    self.bra = self.cursor
                    if not self.slice_del():
                        return False

                    self.ket = self.cursor
                    if not self.__r_stem_suffix_chain_before_ki():
                        self.cursor = self.limit - v_23
                        raise lab47()
                except lab47: pass
                raise lab0()
            except lab43: pass
            self.cursor = self.limit - v_1
            self.ket = self.cursor
            try:
                v_26 = self.limit - self.cursor
                try:
                    if not self.__r_mark_possessives():
                        raise lab52()
                    raise lab51()
                except lab52: pass
                self.cursor = self.limit - v_26
                if not self.__r_mark_sU():
                    return False
            except lab51: pass
            self.bra = self.cursor
            if not self.slice_del():
                return False

            v_27 = self.limit - self.cursor
            try:
                self.ket = self.cursor
                if not self.__r_mark_lAr():
                    self.cursor = self.limit - v_27
                    raise lab53()
                self.bra = self.cursor
                if not self.slice_del():
                    return False

                if not self.__r_stem_suffix_chain_before_ki():
                    self.cursor = self.limit - v_27
                    raise lab53()
            except lab53: pass
        except lab0: pass
        return True

    def __r_post_process_last_consonants(self):
        self.ket = self.cursor
        among_var = self.find_among_b(TurkishStemmer.a_23)
        if among_var == 0:
            return False
        self.bra = self.cursor
        if among_var == 1:
            if not self.slice_from(u"p"):
                return False
        elif among_var == 2:
            if not self.slice_from(u"\u00E7"):
                return False
        elif among_var == 3:
            if not self.slice_from(u"t"):
                return False
        else:
            if not self.slice_from(u"k"):
                return False
        return True

    def __r_append_U_to_stems_ending_with_d_or_g(self):
        v_1 = self.limit - self.cursor
        try:
            v_2 = self.limit - self.cursor
            try:
                if not self.eq_s_b(u"d"):
                    raise lab1()
                raise lab0()
            except lab1: pass
            self.cursor = self.limit - v_2
            if not self.eq_s_b(u"g"):
                return False
        except lab0: pass
        self.cursor = self.limit - v_1
        try:
            v_3 = self.limit - self.cursor
            try:
                v_4 = self.limit - self.cursor
                if not self.go_out_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                    raise lab3()
                try:
                    v_5 = self.limit - self.cursor
                    try:
                        if not self.eq_s_b(u"a"):
                            raise lab5()
                        raise lab4()
                    except lab5: pass
                    self.cursor = self.limit - v_5
                    if not self.eq_s_b(u"\u0131"):
                        raise lab3()
                except lab4: pass
                self.cursor = self.limit - v_4
                c = self.cursor
                self.insert(self.cursor, self.cursor, u"\u0131")
                self.cursor = c
                raise lab2()
            except lab3: pass
            self.cursor = self.limit - v_3
            try:
                v_6 = self.limit - self.cursor
                if not self.go_out_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                    raise lab6()
                try:
                    v_7 = self.limit - self.cursor
                    try:
                        if not self.eq_s_b(u"e"):
                            raise lab8()
                        raise lab7()
                    except lab8: pass
                    self.cursor = self.limit - v_7
                    if not self.eq_s_b(u"i"):
                        raise lab6()
                except lab7: pass
                self.cursor = self.limit - v_6
                c = self.cursor
                self.insert(self.cursor, self.cursor, u"i")
                self.cursor = c
                raise lab2()
            except lab6: pass
            self.cursor = self.limit - v_3
            try:
                v_8 = self.limit - self.cursor
                if not self.go_out_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                    raise lab9()
                try:
                    v_9 = self.limit - self.cursor
                    try:
                        if not self.eq_s_b(u"o"):
                            raise lab11()
                        raise lab10()
                    except lab11: pass
                    self.cursor = self.limit - v_9
                    if not self.eq_s_b(u"u"):
                        raise lab9()
                except lab10: pass
                self.cursor = self.limit - v_8
                c = self.cursor
                self.insert(self.cursor, self.cursor, u"u")
                self.cursor = c
                raise lab2()
            except lab9: pass
            self.cursor = self.limit - v_3
            v_10 = self.limit - self.cursor
            if not self.go_out_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                return False
            try:
                v_11 = self.limit - self.cursor
                try:
                    if not self.eq_s_b(u"\u00F6"):
                        raise lab13()
                    raise lab12()
                except lab13: pass
                self.cursor = self.limit - v_11
                if not self.eq_s_b(u"\u00FC"):
                    return False
            except lab12: pass
            self.cursor = self.limit - v_10
            c = self.cursor
            self.insert(self.cursor, self.cursor, u"\u00FC")
            self.cursor = c
        except lab2: pass
        return True

    def __r_is_reserved_word(self):
        if not self.eq_s_b(u"ad"):
            return False
        v_1 = self.limit - self.cursor
        try:
            if not self.eq_s_b(u"soy"):
                self.cursor = self.limit - v_1
                raise lab0()
        except lab0: pass
        if self.cursor > self.limit_backward:
            return False
        return True

    def __r_more_than_one_syllable_word(self):
        v_1 = self.cursor
        v_2 = 2
        while True:
            v_3 = self.cursor
            try:
                if not self.go_out_grouping(TurkishStemmer.g_vowel, 97, 305):
                    raise lab0()
                self.cursor += 1
                v_2 -= 1
                continue
            except lab0: pass
            self.cursor = v_3
            break
        if v_2 > 0:
            return False
        self.cursor = v_1
        return True

    def __r_postlude(self):
        self.limit_backward = self.cursor
        self.cursor = self.limit
        v_1 = self.limit - self.cursor
        try:
            if not self.__r_is_reserved_word():
                raise lab0()
            return False
        except lab0: pass
        self.cursor = self.limit - v_1
        v_2 = self.limit - self.cursor
        self.__r_append_U_to_stems_ending_with_d_or_g()
        self.cursor = self.limit - v_2
        v_3 = self.limit - self.cursor
        self.__r_post_process_last_consonants()
        self.cursor = self.limit - v_3
        self.cursor = self.limit_backward
        return True

    def _stem(self):
        if not self.__r_more_than_one_syllable_word():
            return False
        self.limit_backward = self.cursor
        self.cursor = self.limit
        v_1 = self.limit - self.cursor
        self.__r_stem_nominal_verb_suffixes()
        self.cursor = self.limit - v_1
        if not self.B_continue_stemming_noun_suffixes:
            return False
        v_2 = self.limit - self.cursor
        self.__r_stem_noun_suffixes()
        self.cursor = self.limit - v_2
        self.cursor = self.limit_backward
        if not self.__r_postlude():
            return False
        return True


class lab0(BaseException): pass


class lab1(BaseException): pass


class lab2(BaseException): pass


class lab3(BaseException): pass


class lab4(BaseException): pass


class lab5(BaseException): pass


class lab6(BaseException): pass


class lab7(BaseException): pass


class lab8(BaseException): pass


class lab9(BaseException): pass


class lab10(BaseException): pass


class lab11(BaseException): pass


class lab12(BaseException): pass


class lab13(BaseException): pass


class lab14(BaseException): pass


class lab15(BaseException): pass


class lab16(BaseException): pass


class lab17(BaseException): pass


class lab18(BaseException): pass


class lab19(BaseException): pass


class lab20(BaseException): pass


class lab21(BaseException): pass


class lab22(BaseException): pass


class lab23(BaseException): pass


class lab24(BaseException): pass


class lab25(BaseException): pass


class lab26(BaseException): pass


class lab27(BaseException): pass


class lab28(BaseException): pass


class lab29(BaseException): pass


class lab30(BaseException): pass


class lab31(BaseException): pass


class lab32(BaseException): pass


class lab33(BaseException): pass


class lab34(BaseException): pass


class lab35(BaseException): pass


class lab36(BaseException): pass


class lab37(BaseException): pass


class lab38(BaseException): pass


class lab39(BaseException): pass


class lab40(BaseException): pass


class lab41(BaseException): pass


class lab42(BaseException): pass


class lab43(BaseException): pass


class lab44(BaseException): pass


class lab45(BaseException): pass


class lab46(BaseException): pass


class lab47(BaseException): pass


class lab48(BaseException): pass


class lab49(BaseException): pass


class lab50(BaseException): pass


class lab51(BaseException): pass


class lab52(BaseException): pass


class lab53(BaseException): pass
