# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.9

import enum
import datetime
import sys
import types
import typing

import winsdk.system
import winsdk.windows.foundation
import winsdk.windows.foundation.collections
import winsdk.windows.networking
import winsdk.windows.networking.sockets
import winsdk.windows.storage.streams

class PeerDiscoveryTypes(enum.IntFlag):
    NONE = 0
    BROWSE = 0x1
    TRIGGERED = 0x2

class PeerRole(enum.IntEnum):
    PEER = 0
    HOST = 1
    CLIENT = 2

class PeerWatcherStatus(enum.IntEnum):
    CREATED = 0
    STARTED = 1
    ENUMERATION_COMPLETED = 2
    STOPPING = 3
    STOPPED = 4
    ABORTED = 5

class TriggeredConnectState(enum.IntEnum):
    PEER_FOUND = 0
    LISTENING = 1
    CONNECTING = 2
    COMPLETED = 3
    CANCELED = 4
    FAILED = 5

Self = typing.TypeVar('Self')

class ConnectionRequestedEventArgs(winsdk.system.Object):
    peer_information: typing.Optional[PeerInformation]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ConnectionRequestedEventArgs: ...

class PeerFinder(winsdk.system.Object):
    display_name: typing.ClassVar[str]
    allow_wi_fi_direct: typing.ClassVar[winsdk.system.Boolean]
    allow_infrastructure: typing.ClassVar[winsdk.system.Boolean]
    allow_bluetooth: typing.ClassVar[winsdk.system.Boolean]
    alternate_identities: typing.ClassVar[typing.Optional[winsdk.windows.foundation.collections.IMap[str, str]]]
    supported_discovery_types: typing.ClassVar[PeerDiscoveryTypes]
    role: typing.ClassVar[PeerRole]
    discovery_data: typing.ClassVar[typing.Optional[winsdk.windows.storage.streams.IBuffer]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> PeerFinder: ...
    @staticmethod
    def connect_async(peer_information: typing.Optional[PeerInformation]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.networking.sockets.StreamSocket]: ...
    @staticmethod
    def create_watcher() -> typing.Optional[PeerWatcher]: ...
    @staticmethod
    def find_all_peers_async() -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[PeerInformation]]: ...
    @typing.overload
    @staticmethod
    def start() -> None: ...
    @typing.overload
    @staticmethod
    def start(peer_message: str) -> None: ...
    @staticmethod
    def stop() -> None: ...
    @staticmethod
    def add_connection_requested(handler: winsdk.windows.foundation.TypedEventHandler[winsdk.system.Object, ConnectionRequestedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @staticmethod
    def remove_connection_requested(cookie: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @staticmethod
    def add_triggered_connection_state_changed(handler: winsdk.windows.foundation.TypedEventHandler[winsdk.system.Object, TriggeredConnectionStateChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @staticmethod
    def remove_triggered_connection_state_changed(cookie: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class PeerInformation(winsdk.system.Object):
    display_name: str
    discovery_data: typing.Optional[winsdk.windows.storage.streams.IBuffer]
    id: str
    host_name: typing.Optional[winsdk.windows.networking.HostName]
    service_name: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> PeerInformation: ...

class PeerWatcher(winsdk.system.Object):
    status: PeerWatcherStatus
    @staticmethod
    def _from(obj: winsdk.system.Object) -> PeerWatcher: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...
    def add_added(self, handler: winsdk.windows.foundation.TypedEventHandler[PeerWatcher, PeerInformation]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_added(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_enumeration_completed(self, handler: winsdk.windows.foundation.TypedEventHandler[PeerWatcher, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_enumeration_completed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_removed(self, handler: winsdk.windows.foundation.TypedEventHandler[PeerWatcher, PeerInformation]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_removed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_stopped(self, handler: winsdk.windows.foundation.TypedEventHandler[PeerWatcher, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_stopped(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_updated(self, handler: winsdk.windows.foundation.TypedEventHandler[PeerWatcher, PeerInformation]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_updated(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ProximityDevice(winsdk.system.Object):
    bits_per_second: winsdk.system.UInt64
    device_id: str
    max_message_bytes: winsdk.system.UInt32
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ProximityDevice: ...
    @staticmethod
    def from_id(device_id: str) -> typing.Optional[ProximityDevice]: ...
    @staticmethod
    def get_default() -> typing.Optional[ProximityDevice]: ...
    @staticmethod
    def get_device_selector() -> str: ...
    @typing.overload
    def publish_binary_message(self, message_type: str, message: typing.Optional[winsdk.windows.storage.streams.IBuffer]) -> winsdk.system.Int64: ...
    @typing.overload
    def publish_binary_message(self, message_type: str, message: typing.Optional[winsdk.windows.storage.streams.IBuffer], message_transmitted_handler: typing.Optional[MessageTransmittedHandler]) -> winsdk.system.Int64: ...
    @typing.overload
    def publish_message(self, message_type: str, message: str) -> winsdk.system.Int64: ...
    @typing.overload
    def publish_message(self, message_type: str, message: str, message_transmitted_handler: typing.Optional[MessageTransmittedHandler]) -> winsdk.system.Int64: ...
    @typing.overload
    def publish_uri_message(self, message: typing.Optional[winsdk.windows.foundation.Uri]) -> winsdk.system.Int64: ...
    @typing.overload
    def publish_uri_message(self, message: typing.Optional[winsdk.windows.foundation.Uri], message_transmitted_handler: typing.Optional[MessageTransmittedHandler]) -> winsdk.system.Int64: ...
    def stop_publishing_message(self, message_id: winsdk.system.Int64) -> None: ...
    def stop_subscribing_for_message(self, subscription_id: winsdk.system.Int64) -> None: ...
    def subscribe_for_message(self, message_type: str, message_received_handler: typing.Optional[MessageReceivedHandler]) -> winsdk.system.Int64: ...
    def add_device_arrived(self, arrived_handler: typing.Optional[DeviceArrivedEventHandler]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_device_arrived(self, cookie: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_device_departed(self, departed_handler: typing.Optional[DeviceDepartedEventHandler]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_device_departed(self, cookie: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ProximityMessage(winsdk.system.Object):
    data: typing.Optional[winsdk.windows.storage.streams.IBuffer]
    data_as_string: str
    message_type: str
    subscription_id: winsdk.system.Int64
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ProximityMessage: ...

class TriggeredConnectionStateChangedEventArgs(winsdk.system.Object):
    id: winsdk.system.UInt32
    socket: typing.Optional[winsdk.windows.networking.sockets.StreamSocket]
    state: TriggeredConnectState
    @staticmethod
    def _from(obj: winsdk.system.Object) -> TriggeredConnectionStateChangedEventArgs: ...

DeviceArrivedEventHandler = typing.Callable[[typing.Optional[ProximityDevice]], None]

DeviceDepartedEventHandler = typing.Callable[[typing.Optional[ProximityDevice]], None]

MessageReceivedHandler = typing.Callable[[typing.Optional[ProximityDevice], typing.Optional[ProximityMessage]], None]

MessageTransmittedHandler = typing.Callable[[typing.Optional[ProximityDevice], winsdk.system.Int64], None]

