// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_Gaming_UI_H
#define WINRT_Windows_Gaming_UI_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/impl/Windows.ApplicationModel.Activation.2.h"
#include "winrt/impl/Windows.Foundation.2.h"
#include "winrt/impl/Windows.Foundation.Collections.2.h"
#include "winrt/impl/Windows.Gaming.UI.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_Gaming_UI_IGameBarStatics<D>::VisibilityChanged(winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Gaming::UI::IGameBarStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Gaming::UI::IGameBarStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameBarStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_VisibilityChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameBarStatics>**)this;
            check_hresult(_winrt_abi_type->add_VisibilityChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Gaming_UI_IGameBarStatics<D>::VisibilityChanged(auto_revoke_t, winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, VisibilityChanged_revoker>(this, VisibilityChanged(handler));
    }
    template <typename D> auto consume_Windows_Gaming_UI_IGameBarStatics<D>::VisibilityChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Gaming::UI::IGameBarStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Gaming::UI::IGameBarStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameBarStatics>**)&_winrt_casted_result;
            _winrt_abi_type->remove_VisibilityChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameBarStatics>**)this;
            _winrt_abi_type->remove_VisibilityChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Gaming_UI_IGameBarStatics<D>::IsInputRedirectedChanged(winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Gaming::UI::IGameBarStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Gaming::UI::IGameBarStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameBarStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_IsInputRedirectedChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameBarStatics>**)this;
            check_hresult(_winrt_abi_type->add_IsInputRedirectedChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Gaming_UI_IGameBarStatics<D>::IsInputRedirectedChanged(auto_revoke_t, winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, IsInputRedirectedChanged_revoker>(this, IsInputRedirectedChanged(handler));
    }
    template <typename D> auto consume_Windows_Gaming_UI_IGameBarStatics<D>::IsInputRedirectedChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Gaming::UI::IGameBarStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Gaming::UI::IGameBarStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameBarStatics>**)&_winrt_casted_result;
            _winrt_abi_type->remove_IsInputRedirectedChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameBarStatics>**)this;
            _winrt_abi_type->remove_IsInputRedirectedChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Gaming_UI_IGameBarStatics<D>::Visible() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Gaming::UI::IGameBarStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Gaming::UI::IGameBarStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameBarStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Visible(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameBarStatics>**)this;
            check_hresult(_winrt_abi_type->get_Visible(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Gaming_UI_IGameBarStatics<D>::IsInputRedirected() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Gaming::UI::IGameBarStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Gaming::UI::IGameBarStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameBarStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsInputRedirected(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameBarStatics>**)this;
            check_hresult(_winrt_abi_type->get_IsInputRedirected(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Gaming_UI_IGameChatMessageReceivedEventArgs<D>::AppId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Gaming::UI::IGameChatMessageReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Gaming::UI::IGameChatMessageReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatMessageReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AppId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatMessageReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_AppId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Gaming_UI_IGameChatMessageReceivedEventArgs<D>::AppDisplayName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Gaming::UI::IGameChatMessageReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Gaming::UI::IGameChatMessageReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatMessageReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AppDisplayName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatMessageReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_AppDisplayName(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Gaming_UI_IGameChatMessageReceivedEventArgs<D>::SenderName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Gaming::UI::IGameChatMessageReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Gaming::UI::IGameChatMessageReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatMessageReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SenderName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatMessageReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_SenderName(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Gaming_UI_IGameChatMessageReceivedEventArgs<D>::Message() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Gaming::UI::IGameChatMessageReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Gaming::UI::IGameChatMessageReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatMessageReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Message(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatMessageReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Message(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Gaming_UI_IGameChatMessageReceivedEventArgs<D>::Origin() const
    {
        winrt::Windows::Gaming::UI::GameChatMessageOrigin value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Gaming::UI::IGameChatMessageReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Gaming::UI::IGameChatMessageReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatMessageReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Origin(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatMessageReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Origin(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Gaming_UI_IGameChatOverlay<D>::DesiredPosition() const
    {
        winrt::Windows::Gaming::UI::GameChatOverlayPosition value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Gaming::UI::IGameChatOverlay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Gaming::UI::IGameChatOverlay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatOverlay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DesiredPosition(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatOverlay>**)this;
            check_hresult(_winrt_abi_type->get_DesiredPosition(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Gaming_UI_IGameChatOverlay<D>::DesiredPosition(winrt::Windows::Gaming::UI::GameChatOverlayPosition const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Gaming::UI::IGameChatOverlay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Gaming::UI::IGameChatOverlay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatOverlay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_DesiredPosition(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatOverlay>**)this;
            check_hresult(_winrt_abi_type->put_DesiredPosition(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Gaming_UI_IGameChatOverlay<D>::AddMessage(param::hstring const& sender, param::hstring const& message, winrt::Windows::Gaming::UI::GameChatMessageOrigin const& origin) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Gaming::UI::IGameChatOverlay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Gaming::UI::IGameChatOverlay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatOverlay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AddMessage(*(void**)(&sender), *(void**)(&message), static_cast<int32_t>(origin)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatOverlay>**)this;
            check_hresult(_winrt_abi_type->AddMessage(*(void**)(&sender), *(void**)(&message), static_cast<int32_t>(origin)));
        }
    }
    template <typename D> auto consume_Windows_Gaming_UI_IGameChatOverlayMessageSource<D>::MessageReceived(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Gaming::UI::GameChatOverlayMessageSource, winrt::Windows::Gaming::UI::GameChatMessageReceivedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Gaming::UI::IGameChatOverlayMessageSource>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Gaming::UI::IGameChatOverlayMessageSource, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatOverlayMessageSource>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_MessageReceived(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatOverlayMessageSource>**)this;
            check_hresult(_winrt_abi_type->add_MessageReceived(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Gaming_UI_IGameChatOverlayMessageSource<D>::MessageReceived(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Gaming::UI::GameChatOverlayMessageSource, winrt::Windows::Gaming::UI::GameChatMessageReceivedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, MessageReceived_revoker>(this, MessageReceived(handler));
    }
    template <typename D> auto consume_Windows_Gaming_UI_IGameChatOverlayMessageSource<D>::MessageReceived(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Gaming::UI::IGameChatOverlayMessageSource>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Gaming::UI::IGameChatOverlayMessageSource, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatOverlayMessageSource>**)&_winrt_casted_result;
            _winrt_abi_type->remove_MessageReceived(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatOverlayMessageSource>**)this;
            _winrt_abi_type->remove_MessageReceived(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Gaming_UI_IGameChatOverlayMessageSource<D>::SetDelayBeforeClosingAfterMessageReceived(winrt::Windows::Foundation::TimeSpan const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Gaming::UI::IGameChatOverlayMessageSource>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Gaming::UI::IGameChatOverlayMessageSource, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatOverlayMessageSource>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetDelayBeforeClosingAfterMessageReceived(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatOverlayMessageSource>**)this;
            check_hresult(_winrt_abi_type->SetDelayBeforeClosingAfterMessageReceived(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_Gaming_UI_IGameChatOverlayStatics<D>::GetDefault() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Gaming::UI::IGameChatOverlayStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Gaming::UI::IGameChatOverlayStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatOverlayStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDefault(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameChatOverlayStatics>**)this;
            check_hresult(_winrt_abi_type->GetDefault(&value));
        }
        return winrt::Windows::Gaming::UI::GameChatOverlay{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Gaming_UI_IGameUIProviderActivatedEventArgs<D>::GameUIArgs() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Gaming::UI::IGameUIProviderActivatedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Gaming::UI::IGameUIProviderActivatedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameUIProviderActivatedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_GameUIArgs(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameUIProviderActivatedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_GameUIArgs(&value));
        }
        return winrt::Windows::Foundation::Collections::ValueSet{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Gaming_UI_IGameUIProviderActivatedEventArgs<D>::ReportCompleted(winrt::Windows::Foundation::Collections::ValueSet const& results) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Gaming::UI::IGameUIProviderActivatedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Gaming::UI::IGameUIProviderActivatedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameUIProviderActivatedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReportCompleted(*(void**)(&results)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Gaming::UI::IGameUIProviderActivatedEventArgs>**)this;
            check_hresult(_winrt_abi_type->ReportCompleted(*(void**)(&results)));
        }
    }
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Gaming::UI::IGameBarStatics> : produce_base<D, winrt::Windows::Gaming::UI::IGameBarStatics>
    {
        int32_t __stdcall add_VisibilityChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().VisibilityChanged(*reinterpret_cast<winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_VisibilityChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().VisibilityChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_IsInputRedirectedChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().IsInputRedirectedChanged(*reinterpret_cast<winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_IsInputRedirectedChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsInputRedirectedChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall get_Visible(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().Visible());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsInputRedirected(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsInputRedirected());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Gaming::UI::IGameChatMessageReceivedEventArgs> : produce_base<D, winrt::Windows::Gaming::UI::IGameChatMessageReceivedEventArgs>
    {
        int32_t __stdcall get_AppId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().AppId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AppDisplayName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().AppDisplayName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SenderName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().SenderName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Message(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Message());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Origin(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Gaming::UI::GameChatMessageOrigin>(this->shim().Origin());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Gaming::UI::IGameChatOverlay> : produce_base<D, winrt::Windows::Gaming::UI::IGameChatOverlay>
    {
        int32_t __stdcall get_DesiredPosition(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Gaming::UI::GameChatOverlayPosition>(this->shim().DesiredPosition());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_DesiredPosition(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DesiredPosition(*reinterpret_cast<winrt::Windows::Gaming::UI::GameChatOverlayPosition const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall AddMessage(void* sender, void* message, int32_t origin) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AddMessage(*reinterpret_cast<hstring const*>(&sender), *reinterpret_cast<hstring const*>(&message), *reinterpret_cast<winrt::Windows::Gaming::UI::GameChatMessageOrigin const*>(&origin));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Gaming::UI::IGameChatOverlayMessageSource> : produce_base<D, winrt::Windows::Gaming::UI::IGameChatOverlayMessageSource>
    {
        int32_t __stdcall add_MessageReceived(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().MessageReceived(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Gaming::UI::GameChatOverlayMessageSource, winrt::Windows::Gaming::UI::GameChatMessageReceivedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_MessageReceived(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().MessageReceived(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall SetDelayBeforeClosingAfterMessageReceived(int64_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetDelayBeforeClosingAfterMessageReceived(*reinterpret_cast<winrt::Windows::Foundation::TimeSpan const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Gaming::UI::IGameChatOverlayStatics> : produce_base<D, winrt::Windows::Gaming::UI::IGameChatOverlayStatics>
    {
        int32_t __stdcall GetDefault(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Gaming::UI::GameChatOverlay>(this->shim().GetDefault());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Gaming::UI::IGameUIProviderActivatedEventArgs> : produce_base<D, winrt::Windows::Gaming::UI::IGameUIProviderActivatedEventArgs>
    {
        int32_t __stdcall get_GameUIArgs(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::ValueSet>(this->shim().GameUIArgs());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReportCompleted(void* results) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ReportCompleted(*reinterpret_cast<winrt::Windows::Foundation::Collections::ValueSet const*>(&results));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
}
WINRT_EXPORT namespace winrt::Windows::Gaming::UI
{
    inline auto GameBar::VisibilityChanged(winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const& handler)
    {
        return impl::call_factory<GameBar, IGameBarStatics>([&](IGameBarStatics const& f) { return f.VisibilityChanged(handler); });
    }
    inline auto GameBar::VisibilityChanged(auto_revoke_t, winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const& handler)
    {
        auto f = get_activation_factory<GameBar, winrt::Windows::Gaming::UI::IGameBarStatics>();
        return GameBar::VisibilityChanged_revoker{ f, f.VisibilityChanged(handler) };
    }
    inline auto GameBar::VisibilityChanged(winrt::event_token const& token)
    {
        impl::call_factory<GameBar, IGameBarStatics>([&](IGameBarStatics const& f) { return f.VisibilityChanged(token); });
    }
    inline auto GameBar::IsInputRedirectedChanged(winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const& handler)
    {
        return impl::call_factory<GameBar, IGameBarStatics>([&](IGameBarStatics const& f) { return f.IsInputRedirectedChanged(handler); });
    }
    inline auto GameBar::IsInputRedirectedChanged(auto_revoke_t, winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const& handler)
    {
        auto f = get_activation_factory<GameBar, winrt::Windows::Gaming::UI::IGameBarStatics>();
        return GameBar::IsInputRedirectedChanged_revoker{ f, f.IsInputRedirectedChanged(handler) };
    }
    inline auto GameBar::IsInputRedirectedChanged(winrt::event_token const& token)
    {
        impl::call_factory<GameBar, IGameBarStatics>([&](IGameBarStatics const& f) { return f.IsInputRedirectedChanged(token); });
    }
    inline auto GameBar::Visible()
    {
        return impl::call_factory_cast<bool(*)(IGameBarStatics const&), GameBar, IGameBarStatics>([](IGameBarStatics const& f) { return f.Visible(); });
    }
    inline auto GameBar::IsInputRedirected()
    {
        return impl::call_factory_cast<bool(*)(IGameBarStatics const&), GameBar, IGameBarStatics>([](IGameBarStatics const& f) { return f.IsInputRedirected(); });
    }
    inline auto GameChatOverlay::GetDefault()
    {
        return impl::call_factory_cast<winrt::Windows::Gaming::UI::GameChatOverlay(*)(IGameChatOverlayStatics const&), GameChatOverlay, IGameChatOverlayStatics>([](IGameChatOverlayStatics const& f) { return f.GetDefault(); });
    }
    inline GameChatOverlayMessageSource::GameChatOverlayMessageSource() :
        GameChatOverlayMessageSource(impl::call_factory_cast<GameChatOverlayMessageSource(*)(winrt::Windows::Foundation::IActivationFactory const&), GameChatOverlayMessageSource>([](winrt::Windows::Foundation::IActivationFactory const& f) { return f.template ActivateInstance<GameChatOverlayMessageSource>(); }))
    {
    }
}
namespace std
{
#ifndef WINRT_LEAN_AND_MEAN
    template<> struct hash<winrt::Windows::Gaming::UI::IGameBarStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Gaming::UI::IGameChatMessageReceivedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Gaming::UI::IGameChatOverlay> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Gaming::UI::IGameChatOverlayMessageSource> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Gaming::UI::IGameChatOverlayStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Gaming::UI::IGameUIProviderActivatedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Gaming::UI::GameBar> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Gaming::UI::GameChatMessageReceivedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Gaming::UI::GameChatOverlay> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Gaming::UI::GameChatOverlayMessageSource> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Gaming::UI::GameUIProviderActivatedEventArgs> : winrt::impl::hash_base {};
#endif
#ifdef __cpp_lib_format
#endif
}
#endif
