// Generated by gmmproc 2.66.6 -- DO NOT MODIFY!


#include <glibmm.h>

#include <atkmm/range.h>
#include <atkmm/private/range_p.h>


/*
 * Copyright 2015 The atkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <atk/atk.h>

namespace Atk
{

Range::Range(double lower_limit, double upper_limit, const Glib::ustring& description)
{
  gobject_ = atk_range_new(lower_limit, upper_limit, description.c_str());
}

} //namespace Atk


namespace
{
} // anonymous namespace


namespace Glib
{

Atk::Range wrap(AtkRange* object, bool take_copy)
{
  return Atk::Range(object, take_copy);
}

} // namespace Glib


namespace Atk
{


// static
GType Range::get_type()
{
  return atk_range_get_type();
}

Range::Range()
:
  gobject_ (nullptr) // Allows creation of invalid wrapper, e.g. for output arguments to methods.
{}

Range::Range(const Range& other)
:
  gobject_ ((other.gobject_) ? atk_range_copy(other.gobject_) : nullptr)
{}

Range::Range(Range&& other) noexcept
:
  gobject_(other.gobject_)
{
  other.gobject_ = nullptr;
}

Range& Range::operator=(Range&& other) noexcept
{
  Range temp (std::move(other));
  swap(temp);
  return *this;
}

Range::Range(AtkRange* gobject, bool make_a_copy)
:
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.
  gobject_ ((make_a_copy && gobject) ? atk_range_copy(gobject) : gobject)
{}

Range& Range::operator=(const Range& other)
{
  Range temp (other);
  swap(temp);
  return *this;
}

Range::~Range() noexcept
{
  if(gobject_)
    atk_range_free(gobject_);
}

void Range::swap(Range& other) noexcept
{
  std::swap(gobject_, other.gobject_);
}

AtkRange* Range::gobj_copy() const
{
  return atk_range_copy(gobject_);
}


double Range::get_lower_limit() const
{
  return atk_range_get_lower_limit(const_cast<AtkRange*>(gobj()));
}

double Range::get_upper_limit() const
{
  return atk_range_get_upper_limit(const_cast<AtkRange*>(gobj()));
}

Glib::ustring Range::_get_description() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(atk_range_get_description(const_cast<AtkRange*>(gobj())));
}


} // namespace Atk


