﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/b2bi/B2BI_EXPORTS.h>
#include <aws/b2bi/model/TransformerJobStatus.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/b2bi/model/S3Location.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace B2BI
{
namespace Model
{
  class GetTransformerJobResult
  {
  public:
    AWS_B2BI_API GetTransformerJobResult();
    AWS_B2BI_API GetTransformerJobResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_B2BI_API GetTransformerJobResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>Returns the current state of the transformer job, either
     * <code>running</code>, <code>succeeded</code>, or <code>failed</code>.</p>
     */
    inline const TransformerJobStatus& GetStatus() const{ return m_status; }

    /**
     * <p>Returns the current state of the transformer job, either
     * <code>running</code>, <code>succeeded</code>, or <code>failed</code>.</p>
     */
    inline void SetStatus(const TransformerJobStatus& value) { m_status = value; }

    /**
     * <p>Returns the current state of the transformer job, either
     * <code>running</code>, <code>succeeded</code>, or <code>failed</code>.</p>
     */
    inline void SetStatus(TransformerJobStatus&& value) { m_status = std::move(value); }

    /**
     * <p>Returns the current state of the transformer job, either
     * <code>running</code>, <code>succeeded</code>, or <code>failed</code>.</p>
     */
    inline GetTransformerJobResult& WithStatus(const TransformerJobStatus& value) { SetStatus(value); return *this;}

    /**
     * <p>Returns the current state of the transformer job, either
     * <code>running</code>, <code>succeeded</code>, or <code>failed</code>.</p>
     */
    inline GetTransformerJobResult& WithStatus(TransformerJobStatus&& value) { SetStatus(std::move(value)); return *this;}


    /**
     * <p>Returns the location for the output files. If the caller specified a
     * directory for the output, then this contains the full path to the output file,
     * including the file name generated by the service.</p>
     */
    inline const Aws::Vector<S3Location>& GetOutputFiles() const{ return m_outputFiles; }

    /**
     * <p>Returns the location for the output files. If the caller specified a
     * directory for the output, then this contains the full path to the output file,
     * including the file name generated by the service.</p>
     */
    inline void SetOutputFiles(const Aws::Vector<S3Location>& value) { m_outputFiles = value; }

    /**
     * <p>Returns the location for the output files. If the caller specified a
     * directory for the output, then this contains the full path to the output file,
     * including the file name generated by the service.</p>
     */
    inline void SetOutputFiles(Aws::Vector<S3Location>&& value) { m_outputFiles = std::move(value); }

    /**
     * <p>Returns the location for the output files. If the caller specified a
     * directory for the output, then this contains the full path to the output file,
     * including the file name generated by the service.</p>
     */
    inline GetTransformerJobResult& WithOutputFiles(const Aws::Vector<S3Location>& value) { SetOutputFiles(value); return *this;}

    /**
     * <p>Returns the location for the output files. If the caller specified a
     * directory for the output, then this contains the full path to the output file,
     * including the file name generated by the service.</p>
     */
    inline GetTransformerJobResult& WithOutputFiles(Aws::Vector<S3Location>&& value) { SetOutputFiles(std::move(value)); return *this;}

    /**
     * <p>Returns the location for the output files. If the caller specified a
     * directory for the output, then this contains the full path to the output file,
     * including the file name generated by the service.</p>
     */
    inline GetTransformerJobResult& AddOutputFiles(const S3Location& value) { m_outputFiles.push_back(value); return *this; }

    /**
     * <p>Returns the location for the output files. If the caller specified a
     * directory for the output, then this contains the full path to the output file,
     * including the file name generated by the service.</p>
     */
    inline GetTransformerJobResult& AddOutputFiles(S3Location&& value) { m_outputFiles.push_back(std::move(value)); return *this; }


    /**
     * <p>Returns an optional error message, which gets populated when the job is not
     * run successfully.</p>
     */
    inline const Aws::String& GetMessage() const{ return m_message; }

    /**
     * <p>Returns an optional error message, which gets populated when the job is not
     * run successfully.</p>
     */
    inline void SetMessage(const Aws::String& value) { m_message = value; }

    /**
     * <p>Returns an optional error message, which gets populated when the job is not
     * run successfully.</p>
     */
    inline void SetMessage(Aws::String&& value) { m_message = std::move(value); }

    /**
     * <p>Returns an optional error message, which gets populated when the job is not
     * run successfully.</p>
     */
    inline void SetMessage(const char* value) { m_message.assign(value); }

    /**
     * <p>Returns an optional error message, which gets populated when the job is not
     * run successfully.</p>
     */
    inline GetTransformerJobResult& WithMessage(const Aws::String& value) { SetMessage(value); return *this;}

    /**
     * <p>Returns an optional error message, which gets populated when the job is not
     * run successfully.</p>
     */
    inline GetTransformerJobResult& WithMessage(Aws::String&& value) { SetMessage(std::move(value)); return *this;}

    /**
     * <p>Returns an optional error message, which gets populated when the job is not
     * run successfully.</p>
     */
    inline GetTransformerJobResult& WithMessage(const char* value) { SetMessage(value); return *this;}


    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }

    
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }

    
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }

    
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }

    
    inline GetTransformerJobResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}

    
    inline GetTransformerJobResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}

    
    inline GetTransformerJobResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}

  private:

    TransformerJobStatus m_status;

    Aws::Vector<S3Location> m_outputFiles;

    Aws::String m_message;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace B2BI
} // namespace Aws
