﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/dataexchange/model/RedshiftDataShareAsset.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace DataExchange
{
namespace Model
{

RedshiftDataShareAsset::RedshiftDataShareAsset() : 
    m_arnHasBeenSet(false)
{
}

RedshiftDataShareAsset::RedshiftDataShareAsset(JsonView jsonValue)
  : RedshiftDataShareAsset()
{
  *this = jsonValue;
}

RedshiftDataShareAsset& RedshiftDataShareAsset::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("Arn"))
  {
    m_arn = jsonValue.GetString("Arn");

    m_arnHasBeenSet = true;
  }

  return *this;
}

JsonValue RedshiftDataShareAsset::Jsonize() const
{
  JsonValue payload;

  if(m_arnHasBeenSet)
  {
   payload.WithString("Arn", m_arn);

  }

  return payload;
}

} // namespace Model
} // namespace DataExchange
} // namespace Aws
