﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/deadline/model/JobDetailsIdentifiers.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace deadline
{
namespace Model
{

JobDetailsIdentifiers::JobDetailsIdentifiers() : 
    m_jobIdHasBeenSet(false)
{
}

JobDetailsIdentifiers::JobDetailsIdentifiers(JsonView jsonValue)
  : JobDetailsIdentifiers()
{
  *this = jsonValue;
}

JobDetailsIdentifiers& JobDetailsIdentifiers::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("jobId"))
  {
    m_jobId = jsonValue.GetString("jobId");

    m_jobIdHasBeenSet = true;
  }

  return *this;
}

JsonValue JobDetailsIdentifiers::Jsonize() const
{
  JsonValue payload;

  if(m_jobIdHasBeenSet)
  {
   payload.WithString("jobId", m_jobId);

  }

  return payload;
}

} // namespace Model
} // namespace deadline
} // namespace Aws
