﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/devicefarm/DeviceFarm_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/devicefarm/model/ArtifactType.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace DeviceFarm
{
namespace Model
{

  /**
   * <p>Represents the output of a test. Examples of artifacts include logs and
   * screenshots.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/Artifact">AWS
   * API Reference</a></p>
   */
  class Artifact
  {
  public:
    AWS_DEVICEFARM_API Artifact();
    AWS_DEVICEFARM_API Artifact(Aws::Utils::Json::JsonView jsonValue);
    AWS_DEVICEFARM_API Artifact& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_DEVICEFARM_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The artifact's ARN.</p>
     */
    inline const Aws::String& GetArn() const{ return m_arn; }
    inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
    inline void SetArn(const Aws::String& value) { m_arnHasBeenSet = true; m_arn = value; }
    inline void SetArn(Aws::String&& value) { m_arnHasBeenSet = true; m_arn = std::move(value); }
    inline void SetArn(const char* value) { m_arnHasBeenSet = true; m_arn.assign(value); }
    inline Artifact& WithArn(const Aws::String& value) { SetArn(value); return *this;}
    inline Artifact& WithArn(Aws::String&& value) { SetArn(std::move(value)); return *this;}
    inline Artifact& WithArn(const char* value) { SetArn(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The artifact's name.</p>
     */
    inline const Aws::String& GetName() const{ return m_name; }
    inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
    inline void SetName(const Aws::String& value) { m_nameHasBeenSet = true; m_name = value; }
    inline void SetName(Aws::String&& value) { m_nameHasBeenSet = true; m_name = std::move(value); }
    inline void SetName(const char* value) { m_nameHasBeenSet = true; m_name.assign(value); }
    inline Artifact& WithName(const Aws::String& value) { SetName(value); return *this;}
    inline Artifact& WithName(Aws::String&& value) { SetName(std::move(value)); return *this;}
    inline Artifact& WithName(const char* value) { SetName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The artifact's type.</p> <p>Allowed values include the following:</p> <ul>
     * <li> <p>UNKNOWN</p> </li> <li> <p>SCREENSHOT</p> </li> <li> <p>DEVICE_LOG</p>
     * </li> <li> <p>MESSAGE_LOG</p> </li> <li> <p>VIDEO_LOG</p> </li> <li>
     * <p>RESULT_LOG</p> </li> <li> <p>SERVICE_LOG</p> </li> <li> <p>WEBKIT_LOG</p>
     * </li> <li> <p>INSTRUMENTATION_OUTPUT</p> </li> <li> <p>EXERCISER_MONKEY_OUTPUT:
     * the artifact (log) generated by an Android fuzz test.</p> </li> <li>
     * <p>CALABASH_JSON_OUTPUT</p> </li> <li> <p>CALABASH_PRETTY_OUTPUT</p> </li> <li>
     * <p>CALABASH_STANDARD_OUTPUT</p> </li> <li> <p>CALABASH_JAVA_XML_OUTPUT</p> </li>
     * <li> <p>AUTOMATION_OUTPUT</p> </li> <li> <p>APPIUM_SERVER_OUTPUT</p> </li> <li>
     * <p>APPIUM_JAVA_OUTPUT</p> </li> <li> <p>APPIUM_JAVA_XML_OUTPUT</p> </li> <li>
     * <p>APPIUM_PYTHON_OUTPUT</p> </li> <li> <p>APPIUM_PYTHON_XML_OUTPUT</p> </li>
     * <li> <p>EXPLORER_EVENT_LOG</p> </li> <li> <p>EXPLORER_SUMMARY_LOG</p> </li> <li>
     * <p>APPLICATION_CRASH_REPORT</p> </li> <li> <p>XCTEST_LOG</p> </li> <li>
     * <p>VIDEO</p> </li> <li> <p>CUSTOMER_ARTIFACT</p> </li> <li>
     * <p>CUSTOMER_ARTIFACT_LOG</p> </li> <li> <p>TESTSPEC_OUTPUT</p> </li> </ul>
     */
    inline const ArtifactType& GetType() const{ return m_type; }
    inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
    inline void SetType(const ArtifactType& value) { m_typeHasBeenSet = true; m_type = value; }
    inline void SetType(ArtifactType&& value) { m_typeHasBeenSet = true; m_type = std::move(value); }
    inline Artifact& WithType(const ArtifactType& value) { SetType(value); return *this;}
    inline Artifact& WithType(ArtifactType&& value) { SetType(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The artifact's file extension.</p>
     */
    inline const Aws::String& GetExtension() const{ return m_extension; }
    inline bool ExtensionHasBeenSet() const { return m_extensionHasBeenSet; }
    inline void SetExtension(const Aws::String& value) { m_extensionHasBeenSet = true; m_extension = value; }
    inline void SetExtension(Aws::String&& value) { m_extensionHasBeenSet = true; m_extension = std::move(value); }
    inline void SetExtension(const char* value) { m_extensionHasBeenSet = true; m_extension.assign(value); }
    inline Artifact& WithExtension(const Aws::String& value) { SetExtension(value); return *this;}
    inline Artifact& WithExtension(Aws::String&& value) { SetExtension(std::move(value)); return *this;}
    inline Artifact& WithExtension(const char* value) { SetExtension(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The presigned Amazon S3 URL that can be used with a GET request to download
     * the artifact's file.</p>
     */
    inline const Aws::String& GetUrl() const{ return m_url; }
    inline bool UrlHasBeenSet() const { return m_urlHasBeenSet; }
    inline void SetUrl(const Aws::String& value) { m_urlHasBeenSet = true; m_url = value; }
    inline void SetUrl(Aws::String&& value) { m_urlHasBeenSet = true; m_url = std::move(value); }
    inline void SetUrl(const char* value) { m_urlHasBeenSet = true; m_url.assign(value); }
    inline Artifact& WithUrl(const Aws::String& value) { SetUrl(value); return *this;}
    inline Artifact& WithUrl(Aws::String&& value) { SetUrl(std::move(value)); return *this;}
    inline Artifact& WithUrl(const char* value) { SetUrl(value); return *this;}
    ///@}
  private:

    Aws::String m_arn;
    bool m_arnHasBeenSet = false;

    Aws::String m_name;
    bool m_nameHasBeenSet = false;

    ArtifactType m_type;
    bool m_typeHasBeenSet = false;

    Aws::String m_extension;
    bool m_extensionHasBeenSet = false;

    Aws::String m_url;
    bool m_urlHasBeenSet = false;
  };

} // namespace Model
} // namespace DeviceFarm
} // namespace Aws
